var minimosService = function($filter, tablaService, terminosValidateService) {

	return {

		inicializarMinimos: function(data, seccion){			
			var tablaMinGar;
			var tablaMinAnio;
			var tipoMin      = data.tipoMin;
			var minimosAnio  = data.minimosAnio;
			var minimosCateg = data.minimosCateg;
			var na           = data.na;
			var anios        = data.anios;
						
			if (tipoMin == "categoria") 
			{
				tablaMinGar  = this.crearTablaMinimosGaranzatidosCateg(minimosCateg, null, anios);				
				tablaMinAnio = this.crearTablaMinimosGaranzatidosAnio(minimosAnio , null, anios);								
				this.inicializarDivMinimos("categoria", seccion);
			} 
			else if (tipoMin == "anio") 
			{
				tablaMinGar  = this.crearTablaMinimosGaranzatidosCateg(minimosCateg, null, anios);				
				tablaMinAnio = this.crearTablaMinimosGaranzatidosAnio(minimosAnio , null, anios);
				this.inicializarDivMinimos("anio", seccion);
			} 
			else if (na) 
			{
				tablaMinAnio = this.crearTablaMinimosGaranzatidosAnio (minimosAnio , null, anios);
				tablaMinGar  = this.crearTablaMinimosGaranzatidosCateg(minimosCateg, null, anios);							
				this.inicializarDivMinimos(null, seccion);
			}	
			return {tablaMinGar: tablaMinGar, tablaMinAnio : tablaMinAnio, tipoMin:tipoMin, idsCat:null };
	    },
	    
	    inicializarDivMinimos: function(tipoMin, seccion){	    	
			if(tipoMin == "categoria")
			{
				$("#divMinCate"+seccion).show();
				$("#divMinAnio"+seccion).hide();			
			}
			else if(tipoMin == "anio")
			{
				$("#divMinAnio"+seccion).show();
				$("#divMinCate"+seccion).hide();
			}
			else		
			{
				$("#divMinAnio"+seccion).hide();
				$("#divMinCate"+seccion).hide();
			}
	    },
	    	    
		crearTablaMinimosGaranzatidosCateg: function(data, encabezados, anios){
		    	var tabla = {encabezados:null, metadatos:null, columnasEliminar: null, datos:null, mensajes : null, valida:true, nombre: "Minimos Garantizados"};
		    	
		    	//Se crean los encabezados de una tabla
			    tabla.encabezados=[ {"valor":"Box Office", "colspan":"2"},
			   		                {"valor":"Categoria",  "colspan":"1"} ];
			    	
			    for(var i=0; i<anios.length; i++)
			    	tabla.encabezados.push({"valor":anios[i], "colspan":"1"});
			   	
			    //Se crean los metadatos de la tabla
			    tabla.metadatos= [  {"nombre":"rango a",   "tipo":"text", "min":1, "max":10,   "formateo":"numero"},
			   	                    {"nombre":"rango b",   "tipo":"text", "min":1, "max":10,   "formateo":"numero"},
			   	                    {"nombre":"categoria", "tipo":"String", "min":1, "max":25, "formateo":"texto"}
			   	                 ];	    	
			   	
			   	for(var i=0; i<anios.length; i++)
			   	    tabla.metadatos.push({"tipo":"text", "min":1, "max":10, "formateo":"moneda"});

			   	//Se crean los datos
			   	tabla.datos = [];
				for(var i=0; i < data.length;i++)
				{
				   		var fila = [];
				    	for(var j=0; j < data[0].length;j++)
					   	{
				    		if(data[i][j] == null || data[i][j] == "null")
				    			fila.push({"valor" : null});
				    		else if(j <= 1)
				    			fila.push({"valor" : $filter('numDigMoneda')(data[i][j],2)});
				    		else if(j > 2)
				    		    fila.push({"valor" : $filter('numDigMoneda')(data[i][j],2)});
				    		else
				    		    fila.push({"valor" : data[i][j]});
					   	}	
				    	tabla.datos.push(fila);
				}
				//Se asginan valores por default vacios
				tabla.datos[0][0].valor = null;
				tabla.datos[0][1].valor = null;
				tabla.mensajes = [];
				for(var i=0; i < data.length;i++)
				    tabla.mensajes.push("");
		    		    			   	 		   	 	
		    	return tabla;
		    },
		    		    
		    crearTablaMinimosGaranzatidosAnio: function(data, encabezados, anios){
		    	var tabla = {encabezados:null, metadatos:null, columnasEliminar: null, datos:null, mensajes : null, valida:true, nombre: "Minimos Garantizados"};
		    	
		    	tabla.encabezados     =[];
		    	tabla.metadatos       =[];
		    	tabla.columnasEliminar=[];
			    			    	
			    tabla.encabezados.push({"valor":"Periodos" , "colspan":"1"});
			    tabla.encabezados.push({"valor":"$ MG"     , "colspan":"1"});
			    tabla.encabezados.push({"valor":"Aplica MG", "colspan":"1"});
			   	
		    	for(var i=0; i<anios.length; i++)
			   	    tabla.metadatos.push({"tipo":"text", "min":1, "max":10, "formateo":"numero"});
			   	
			   	//Se crean los datos
			   	tabla.datos = [];
				for(var i=0; i < data.length;i++)
				{
						var fila = [];
				    	for(var j=0; j < data[0].length;j++)
					   	{		    		
				    		if(data[i][j] == null)
				    			fila.push({"valor" : null});
				    		else if(j == 1 && data[i][j] != null)
				    	        fila.push({"valor" : $filter('numDigMoneda')(data[i][j],2)});
				    		else
				    		    fila.push({"valor" : data[i][j]});
					   	}	
				    	tabla.datos.push(fila);
				}
				   	 
				tabla.mensajes = [""];
				for(var i=0; i < data.length;i++)
					tabla.mensajes.push("");
		    		    			   	 		   	 		   	 		   	 
		    	return tabla;
		    },
		    	
		    obtenerMinAniosGuardar: function(tipoMin, idTabCat, idTabAnio){		    	
		    	var aniosMin = [];
		    	if (tipoMin == "categoria") 
				{													
					$("#"+idTabCat+ " thead tr th").each(function(index) {
						if(index > 1)
						{
							if($(this).text().includes("-"))
								aniosMin.push($(this).text())
						}						
																									   
					});				
				}
				else  if (tipoMin == "anio")
				{										
					$("#"+idTabAnio+ " tbody tr").each(function() {
						if($(this).find("td:first"))
						   aniosMin.push($(this).text())
					});				
				}
		    	return aniosMin;
		    },
		    
		    editarTablaMinGarantizados: function(operacion, index, encabezado, tablaMinGar, idsCat, idCatEli, tablaRevenueBox){
		    	var tablaN;
				var numAnio = (tablaMinGar.datos[0].length - 3) + 1;
				var modificado = false;
				switch (operacion) {
				case 'removeRow':
					tablaN = tablaService.removeRow(tablaMinGar.datos, index);
					
					if(tablaRevenueBox)
					  tablaService.removeRow(tablaRevenueBox.datos, index);					
					
					modificado = true;										
					break;
				case 'addRow':
					tablaN = tablaService.addRow(tablaMinGar.datos);
					
					if(tablaRevenueBox)
					   tablaService.addRow(tablaRevenueBox.datos);	
					
					modificado = true;
					break;
				case 'addColumn':			
					tablaN = tablaService.addColumn(tablaMinGar.datos, tablaMinGar.encabezados, null, encabezado);
					modificado = true;
					break;
				default:
				}
				
				if(modificado)
				{
					tablaMinGar.datos       = tablaN.datos       != null ? tablaN.datos      : tablaMinGar.datos;
					tablaMinGar.encabezados = tablaN.encabezados != null ? tablaN.encabezados: tablaMinGar.encabezados;	
				}		
				return {tablaMinGar:tablaMinGar, idsCat:idsCat, idCatEli:idCatEli} 
		    },

		    editarTablaMinGarantizadosAnio: function(operacion, index, encabezado, tablaMinAnio){
		    	var tablaN;
				var numAnio = tablaMinAnio.datos[0].length + 1;
				switch (operacion) {
				case 'addColumn':
					tablaN = tablaService.addColumn(tablaMinAnio.datos, tablaMinAnio.encabezados, tablaMinAnio.columnasEliminar, encabezado);
					modificado = true;
					break;
				case 'removeColumn':
					tablaN = tablaService.removeColumn(tablaMinAnio.datos, tablaMinAnio.encabezados, tablaMinAnio.columnasEliminar, index);
					break;
				case 'removeRow':
					tablaN = tablaService.removeRow(tablaMinAnio.datos, index);																			
					break;
				case 'addRow':
					tablaN = tablaService.addRow(tablaMinAnio.datos);										
					break;
				default:		
				}
				tablaMinAnio.datos       = tablaN.datos       != null ? tablaN.datos       : tablaMinAnio.datos;
				tablaMinAnio.encabezados = tablaN.encabezados != null ? tablaN.encabezados : tablaMinAnio.encabezados;
				return tablaMinAnio;
		    },
		    
		    actualizarMinCelda: function(fila, columna, valor, tipoMin, tablaMinAnio, tablaMinGar){
		    	var valClean = $filter('numDigNormal')(valor.srcElement.value);

				if (!isNaN(valClean) && parseFloat(valClean) > 0) 
				{
					if (tipoMin == "anio") 
					{
						if (valClean == "")
							tablaMinAnio.datos[fila][columna].valor = null;
						else
							valor.srcElement.value = $filter('numDigMoneda')(valClean,2);
					} 
					else if (tipoMin == "categoria") 
					{
						if (columna != 2) 
						{
							if (valClean == "")
								tablaMinGar.datos[fila][columna].valor = null;
							else
								valor.srcElement.value = $filter('numDigMoneda')(valClean, 2);
						}
					}
				}
				else 
				{
					if (tipoMin != "categoria" && columna != 2)
						valor.srcElement.value = null;
				}
				return {tablaMinAnio:tablaMinAnio, tablaMinGar:tablaMinGar}
		    },
		    
		    validarMinimos: function(tablaMinAnio, tablaMinGar, tipoMin, idTabCat, idTabAnio){		    
		    	var continuar = true;
		    	// Se validan campos vacios		
				if(tipoMin == "categoria") 
				{			
				   tablaMinGar.datos[0][0].valor = 0;
				   tablaMinGar.datos[0][1].valor = 0; 
				   tablaMinGar = terminosValidateService.validarCeldasVacias(tablaMinGar, tablaMinGar.datos[0].length, true); 
				   continuar   = terminosValidateService.mensajeValidacion  (tablaMinGar.valida, tablaMinGar.nombre, ""); 
				   tablaMinGar.datos[0][0].valor = null; 
				   tablaMinGar.datos[0][1].valor = null; 
				}
				else if(tipoMin == "anio")
				{
				   tablaMinAnio = terminosValidateService.validarCeldasVacias(tablaMinAnio, tablaMinAnio.datos[0].length, true); 
				   continuar    = terminosValidateService.mensajeValidacion(tablaMinAnio.valida, tablaMinAnio.nombre, ""); 
				}
				
				//Se valida longitud categorias 
				if(continuar) 
				{ 
				  if(tipoMin == "categoria") 
				  { 
					 tablaMinGar = terminosValidateService.validarLongitudCeldas(tablaMinGar, null, null, [2]);
					 continuar   = terminosValidateService.mensajeValidacion(tablaMinGar.valida, tablaMinGar.nombre, ""); 
				  } 
				}
				
				//Se validan categorias repetidas 
				if(continuar)
				{ 
				  if(tipoMin == "categoria") 
				  {
					 tablaMinGar = terminosValidateService.validarCategoriasRepetidas(tablaMinGar, 2);
					 continuar   = terminosValidateService.mensajeValidacion(tablaMinGar.valida, tablaMinGar.nombre, ", existen categorias repetidas"); 
				  } 
				}
				
				//Se validan rangos 
				if(continuar) 
				{ 
				  if(tipoMin == "categoria") 
				  {
				     tablaMinGar = terminosValidateService.validarRangosTablas(tablaMinGar, 0 ,1, 1);
				     continuar   = terminosValidateService.mensajeValidacion(tablaMinGar.valida, tablaMinGar.nombre, ""); 
				  } 
				}
				
				//se valida las fechas de minimos
				if (continuar)
				{
					if(tipoMin == "categoria" || tipoMin == "anio")
					{						
						var periodos = [];
						if (tipoMin == "categoria") 
						{										
							$("#"+idTabCat+" thead tr th").each(function(index) {
								if(index > 1)
								{
									var fechas = $(this).text().split("-");
									if(fechas.length == 2)
									   periodos.push({fechaInicio: fechas[0], fechaFin: fechas[1]})						
								}					   
							});				
						}
						else if (tipoMin == "anio")
						{				
							for(var i=0; i< tablaMinAnio.datos.length; i++)
							{
								var fechas = tablaMinAnio.datos[i][0].valor.split("-");
								if(fechas.length == 2)
								    periodos.push({fechaInicio: fechas[0], fechaFin: fechas[1]})	
							}																			
						}
																	
						var valido = terminosValidateService.validarFechasPeriodos(periodos);
						continuar  = valido.validacion;
						if(!valido.validacion)
							showError(valido.mensaje);
									
						if(continuar)
						{
						   if( ($.datepicker.parseDate( 'mm/dd/yy',  $("#fechaInicioCto").val()).getTime() > $.datepicker.parseDate( 'mm/dd/yy',  periodos[0].fechaInicio).getTime()) ||  	    
							   ($.datepicker.parseDate( 'mm/dd/yy',  $("#fechaFinCto").val()).getTime()    < $.datepicker.parseDate( 'mm/dd/yy',  periodos[periodos.length-1].fechaFin).getTime()) )
						   {
							   continuar = false;
							   showError("El rango de fecha del periodo no est\u00E1 en el rango de tiempo del contrato.");
						   }			      		 
						}
					}
				}
				return continuar;
		    },
		    		    		    
		    obtenerEncabezadosExportar: function(operacion, encabezados, idTabAnio){
		    	var enc = [];
				
				if(operacion == "min_cat")
				{
				   enc[0] = encabezados[0].valor;
				   enc[1] = "";
				   for(var i=1; i<encabezados.length;i++)
					   enc[i+1] = encabezados[i].valor;	
				}
				else if(operacion == "min_anio")
				{				
					$( "#"+idTabAnio+ " thead tr" ).find("th").each(function() {
						  enc.push($(this).text());
					});		   	
					enc.splice(enc.length-1,1);				
				}
		    	return enc;
		    },
		    
		    importarExcelMin: function(data, tablaMinGar, idsCat, idCatEli){
		    	data.splice(0, 1);
				
		    	var res;
		    	
				for(var i=0; i<data.length; i++)
				{
					if(!this.verifcarFilaVacia(data[i]))
					{
						var encontrado = false;
						for(var j=0; j<tablaMinGar.datos.length; j++)
						{										
							if(tablaMinGar.datos[j][2].valor == data[i].fila[2])
							{
								tablaMinGar.datos[j][0].valor = data[i].fila[0];
								tablaMinGar.datos[j][1].valor = data[i].fila[1];
								
								var numCol = data[i].fila.length < tablaMinGar.datos[j].length ? data[i].fila.length :  tablaMinGar.datos[j].length;
								
								for(var k= 3; k< numCol; k++)
									tablaMinGar.datos[j][k].valor = data[i].fila[k];
								encontrado = true;
							}					 
						}
						
						if(!encontrado)
						{							              
							var res = this.editarTablaMinGarantizados("addRow",null,null, tablaMinGar, idsCat, idCatEli);							
							tablaMinGar = res.tablaMinGar;
							idsCat      = res.idsCat
							
							var numCol = data[i].fila.length < tablaMinGar.datos[0].length ? data[i].fila.length :  tablaMinGar.datos[0].length;
												
							tablaMinGar.datos[tablaMinGar.datos.length-1][0].valor = data[i].fila[0];
							tablaMinGar.datos[tablaMinGar.datos.length-1][1].valor = data[i].fila[1];
							tablaMinGar.datos[tablaMinGar.datos.length-1][2].valor = data[i].fila[2];
																				
							for(var k= 3; k< numCol; k++)
								tablaMinGar.datos[tablaMinGar.datos.length-1][k].valor = data[i].fila[k];											
						}						
					}
				}
				
				return {tablaMinGar :tablaMinGar, idsCat:idsCat}
		    },
		    
		    verifcarFilaVacia : function(data) {		
				var cont = 0;
				
				for(var i=0; i<data.fila.length; i++)
				{
					if(data.fila[i] === "" || data.fila[i] == null)
					   cont++
				}
				
				if(cont == data.fila.length)
					return true;
				else
					return false;
			},
			
			agregarPeriodoCategoria : function(tablaMinGar, inputFechaInicio, inputFechaFin, perant, pernuevo) {		
				var fecha =  $("#"+inputFechaInicio).val()+"-" +$("#"+inputFechaFin).val();
				if($("#"+perant).prop("checked"))
				{
					var inflacion = $("#inflacionTx").val() != "" ? parseFloat($("#inflacionTx").val()) : 0;				
															
					var res = this.editarTablaMinGarantizados("addColumn", null, fecha, tablaMinGar, null, null);
					tablaMinGar  = res.tablaMinGar;
																								        			        
			        for(var i=0; i<tablaMinGar.datos.length; i++)
			        {
			        	var minimo = tablaMinGar.datos[i][tablaMinGar.datos[0].length-2].valor;
			        	var valor     = parseFloat(minimo.replace(/\$/g,"").replace(/%/g,"").replace(/,/g,""));
			        	valor         = $("#chInflacion").prop("checked") ? (valor + ((valor*inflacion)/100)).toString() : valor.toString();			        	
			        	tablaMinGar.datos[i][tablaMinGar.datos[0].length-1].valor = $filter('numDigMoneda')(valor,2);							
			        }					
				}
				if($("#"+pernuevo).prop("checked"))
				{
					var res = this.editarTablaMinGarantizados("addColumn", null, fecha, tablaMinGar, null, null);
					tablaMinGar  = res.tablaMinGar;	
				}
				return tablaMinGar;
			},
			
			agregarPeriodoAnio : function(tablaMinAnio, inputFechaInicio, inputFechaFin, perant, pernuevo) {		
				var fecha =  $("#"+inputFechaInicio).val()+"-" +$("#"+inputFechaFin).val();
				if($("#"+perant).prop("checked"))
				{
					var inflacion = $("#inflacionTx").val() != "" ? parseFloat($("#inflacionTx").val()) : 1;				
															
					tablaMinAnio = this.editarTablaMinGarantizadosAnio("addRow", null, null, tablaMinAnio);
					
					var valor     =  parseFloat(tablaMinAnio.datos[tablaMinAnio.datos.length-2][1].valor);											
			        valor         = $("#chInflacion").prop("checked") ? (valor + ((valor*inflacion)/100)).toString() : valor.toString();
			        
					tablaMinAnio.datos[tablaMinAnio.datos.length-1][0].valor = fecha;
					tablaMinAnio.datos[tablaMinAnio.datos.length-1][1].valor = $filter('numDigMoneda')(valor,2);
					tablaMinAnio.datos[tablaMinAnio.datos.length-1][2].valor = tablaMinAnio.datos[tablaMinAnio.datos.length-2][2].valor
				}
				if($("#"+pernuevo).prop("checked"))
				{
					tablaMinAnio = this.editarTablaMinGarantizadosAnio("addRow", null, null, tablaMinAnio);
					tablaMinAnio.datos[tablaMinAnio.datos.length-1][0].valor = fecha;	
				}				 
				return tablaMinAnio;
			},
			
			generarFechaHora: function(fecha){
				return terminosValidateService.generarFechaHora(fecha);
			}
			
    };	
};

registraService("minimosService", minimosService);