package com.mx.dla.dda.contrato.license.titulo.bos;

import java.util.Calendar;
import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDAO;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.dda.contrato.titulos.dtos.CatTitulo;
import com.mx.dla.global.bos.BaseBO;

@Component
public class TituloFeeUtilBO extends BaseBO{
	
	@Autowired
	private TituloDAO tituloDAO;

	public  Titulo getTituloGuardar(CatTitulo cat, Titulo t, ContratoDTO c){
		t.setIdTitulo(cat.getIdTitulo());
		t.setIdContrato(c.getIdContrato());
		t.setVidaUtil(calcularVidaUtil(t.getFechaInicio(),t.getFechaFin()));
		t.setMesesvu(calculaMesesVidaUtil(t.getFechaInicio(),t.getFechaFin()));
		t.setEstatus("ACTIVO");
		return t;
	}
	
	/**
	 * Calcula la diferencia en meses entre dos fechas
	 * @param first less date than second param
	 * @param second greater date than first param
	 * @return diference in months 
	 */
	public static Long calculaDiferencia(Date first, Date second)
	{
		Calendar f = Calendar.getInstance();
		Calendar s = Calendar.getInstance();
		f.setTime(first);
		s.setTime(second);
		
		Integer diff= 0;
		Integer diffYears = (s.get(Calendar.YEAR) - f.get(Calendar.YEAR))*12;
		diff = diffYears - f.get(Calendar.MONTH);
		diff = diff + s.get(Calendar.MONTH) ;
		
		if(s.get(Calendar.DAY_OF_MONTH) - f.get(Calendar.DAY_OF_MONTH) > 0)
		{
			diff ++;
		}
		
		//logger.info("total of months [{}]",diff);
		return diff.longValue();
	}
	
	public   String calcularVidaUtil(Date inicio, Date fin)
	{
		return tituloDAO.calcularVidaUtil(inicio, fin, "SAP");
	}
	
	public  String calculaMesesVidaUtil(Date inicio, Date fin)
	{
		return tituloDAO.calcularVidaUtil(inicio, fin, "DDA");
	}
	
	public static Titulo getTituloSerieAuto(Titulo t, String name, String episodio){		
		t.setDescTitulo(name);
	    t.setEpisodio(episodio);
		t.setIdBv(null);
		return t;
	}
	
	public  Titulo getTituloByTitulo(Titulo origen, Titulo bd){		
		bd.setFechaInicio(origen.getFechaInicio());
		bd.setFechaFin(origen.getFechaFin());
		bd.setVidaUtil(calcularVidaUtil(origen.getFechaInicio(),origen.getFechaFin()));
		bd.setMesesvu(calculaMesesVidaUtil(origen.getFechaInicio(),origen.getFechaFin()));
		bd.setPagoCateg(origen.getPagoCateg());
		bd.setDescTitulo(origen.getDescTitulo());
		bd.setCategoriaTit(origen.getCategoriaTit());
		bd.setCategoriaTit(origen.getCategoriaTit());
		bd.setPrecioAnual(origen.getPrecioAnual());
		bd.setNombreUnico(origen.getNombreUnico());
		bd.setTemporada(origen.getTemporada());
		bd.setEpisodio(origen.getEpisodio());
		bd.setPjeExclusivo(origen.getPjeExclusivo());
		bd.setMesesExclusivo(origen.getMesesExclusivo());
		bd.setIdBv(origen.getIdBv());
		bd.setBriefcase(origen.isBriefcase());
		bd.setFlgcalculoPrecio(origen.getFlgcalculoPrecio());		
		return bd;
	}
		
	
}
