package com.mx.dla.dda.general.constants;

import com.mx.dla.dda.catalogos.dtos.Catalogable;


public enum SiNoOpcion implements Catalogable{

	SI("1","Si"),
	NO("0","No")
	;
	
	private String type;
	
	private String desc;
	
	SiNoOpcion(String type , String desc)
	{
		this.type = type;
		this.desc = desc;
	}
	
	public String getDesc() {
		return desc;
	}
	public String getType() {
		return type;
	}
	
	@Override
	public String getValue() {
		return type;
	}
	
	public static SiNoOpcion parse(String tipo)
	{
		SiNoOpcion [] values = SiNoOpcion.values();
		SiNoOpcion target = null;
		for(SiNoOpcion t : values)
		{
			if(t.getType().equals(tipo))
			{
				target = t;
				break;
			}
		}
		return target;
		
	}
}

