var tipoSuscriptor  =  "";
var tipoFee         =  "";
var tipoOperacion   =  "";
var nuevoPeriodo    = -2;
var nuevaColumna    = -2;
var nuevoCategoria  = -1;
var nuevoBono       = -1;
var validacionForma = true;
var categoriasEliminar = [];
var periodosEliminar   = [];
var colsEliminar       = [];
var edoCto             = 0;
var tablaDinam;
var aListaSuscriptor = [];
var aTipoAnio        = [];
var idPeriodoBonoF  = -1;
var uploader;
var perfil;

$(document).ready(function(){		    //Se iniciliazan elementos    	 			
	    tablaDinam = tablaDinamica(1);
	    perfil     = new PerfilController();
		perfil.ejecutarPerfil(parseInt($("#pmn").val()));
	    inicializar();
		obtenerDatos();
		inicializarBotones();
		mostrarFeesNA();	
});

function inicializarBotones(){

	$("#cargaExcel").click(function(){
		inicializarBotonCarga();	    																
	});
	
	$("#cargaFile").click(function(){		
		uploader.startUpload("modalCarga");		
	});
	
	$("#guardarBtn").click(function(){		
		if(tipoSuscriptor == "NA")
		{
			guardarNA();
		}
		else if (tipoSuscriptor == "CT")
		{
			actualizarCostosTitulosContrato();
		}
		else
		{
			guardarSuscriptorFlat();
		}
	});			
	
	$("#nuevoPeriodo").click(function()  
	{				
		nuevoPeriodo--;
		$("#selectPeriodos").find("option").remove();
		var opciones = [];
		if(tipoSuscriptor == "s")
		{
			if($("#divSuscriptores div.contenedor").length > 0)
			{
				$("#divSuscriptores div.contenedor").each(function(){	    					
					 var fecha = $(this).find("div.periodo").find("input.datepicker:first").val() + " - " + $(this).find("div.periodo input:last").val();
					 opciones.push('<option value="'+$(this).attr("id") +'">'+ fecha +'</option>');					
				});
				for(var i=(opciones.length-1); i>=0; i--)			
					$("#selectPeriodos").append(opciones[i]);
				$("#dialogAgregarPeriodo").modal('show');
				$( ".datepicker" ).datepicker( { dateFormat: 'mm/dd/yy' } );
			}
			else
			{
				agregarNuevoSuscriptor(aListaSuscriptor, "VACIO", null, null);
				showMessage("Se ha agregado un nuevo periodo.");
			}			
		}
		else
		{
			var numCol = $("table.tFlat thead tr:first").find("th").length;												
			var id     = $("table.tFlat thead tr.encabezado").find("th:nth-child("+(numCol-1)+")").attr("idper");
			$("#iniAddPeriodo").val("");
			$("#finAddPeriodo").val("");
			$("#hidIdPer").val(id);
			$("#dialogAgregarPeriodoFlat").modal('show');
			$( ".datepicker" ).datepicker( { dateFormat: 'mm/dd/yy' } );
		}																				
	});
	
	$("#aceptarPer").click(function()  
	{		
		if($("input[id=perBase]").prop('checked') == true  || 
		   $("input[id=perVacio]").prop('checked') == true)
		{			
			var valAnio = $("input[id=anioContrato]").val();			
			if(validarAnioContrato(valAnio) && verificarAniosContratosSuscriptor(valAnio))
			{
				var tipo      = $("input[id=perBase]")   .prop('checked') == true ? "BASE" : "VACIO"; 
				var inflacion = $("input[id=checkInfla]").prop('checked') == true ? true   : false;
				var idPeriodo = $("#selectPeriodos").val();
				var anioCto   = parseInt($("input[id=anioContrato]").val());				
				debugger
				agregarNuevoSuscriptor(aListaSuscriptor, tipo, inflacion, parseInt(anioCto), idPeriodo);
				$("#dialogAgregarPeriodo").modal("hide");
				$( ".datepicker" ).datepicker( { dateFormat: 'mm/dd/yy' } );
			}
			else
			{				   
			    $("#labErrAddPerS").text("El campo a\u00F1o Contrato es obligatorio, \u00FAnico y debe ser n\u00FAmero entero de dos digitos.").show();
			}			
		}
		else 
		{
			$("#labErrAddPerS").text("Se debe seleccionar alguna opci\u00F3n.").show();
			$("#dialogAgregarPeriodo").modal("show");
		}						
	});
	
	$("#aceptarPerFlat").click(function()  
	{											
		if($("input[id=perBaseF]") .prop('checked') == true  ||
		   $("input[id=perVacioF]").prop('checked') == true)
		{				
			var valAnio = $("#anioContratoFlat").val();		
			$("#labErrAddPer").hide();
			if($("#finAddPeriodo").val() == "" || $("#iniAddPeriodo").val() == "")
				$("#labErrAddPer").text("Falta registrar las fecha de inicio y fecha de termino.").show();
			else if( $.datepicker.parseDate('mm/dd/yy',$("#iniAddPeriodo").val()).getTime() >  $.datepicker.parseDate('mm/dd/yy',$("#finAddPeriodo").val()).getTime()) 	
				$("#labErrAddPer").text("La fecha fin no puede ser menor a la fecha inicio.").show();		
			else if($("#finAddPeriodo").val() == $("#iniAddPeriodo").val())	
				$("#labErrAddPer").text("Ambas fechas son iguales.").show();
			else if(valAnio == "")
				$("#labErrAddPer").text("El campo a\u00F1o Contrato es obligatorio, \u00FAnico y debe ser n\u00FAmero entero de dos digitos entre 0 y 99.").show();
			else if(!validarAnioContrato(valAnio) || !verificarAniosContratosFlat(valAnio))
				$("#labErrAddPer").text("El campo a\u00F1o Contrato es obligatorio, \u00FAnico y debe ser n\u00FAmero entero de dos digitos entre 0 y 99.").show();
			else 
			{
				$("#labErrAddPer").hide();						
				var tipo      = $("input[id=perBaseF]").prop('checked') == true ? "BASE" : "VACIO";
				var anio      = $("#anioContratoFlat").val();
				agregarNuevoPeriodoFlat(tipo, $("#hidIdPer").val(), $("#inflacion").val(), parseInt(anio));			
				$( ".datepicker" ).datepicker( { dateFormat: 'mm/dd/yy' } );
				$("#dialogAgregarPeriodoFlat").modal("hide");
			}																												
		}
		else 
		{
			$("#labErrAddPer").text("Se debe seleccionar alguna opci\u00F3n.").show();
		}
	});
}

function obtenerDatos(){	
	$.post( contextPath + '/contrato/fees/obtener.action')
	.done(function( response ) 
	{
		if(response.msgError != null)
			showError(response.msgError);
		else
			mostrarFees(response);
	});		  
}

function mostrarFees(data){	
	tipoOperacion    = data.datos[0].operacion; 
	aListaSuscriptor = data.tipoSuscriptorLista;
	aTipoAnio        = data.anioTipo;
	edoCto           = data.edoCto;
	$("#costoTotalNmb").val(data.costoTotal);
	if(data.estatus > 1){
		$("#costoTotalNmb").prop( "disabled", true);
	}
	$("#costoTotalNmb").val(data.costoTotal);
	mostrarFechaContrato(data.fechaInicioCto, data.fechaFinCto, data.inflacion);
	crearElementoBono(data);	
	
	if( tipoOperacion == "nuevo")		   						
		inicializarNuevo(data);	   	   
	else
	{	//Se verifica si se mostrara flat o suscriptor				    								
		if(data.datos[0].categorias != null)										
		   inicializarSuscriptor(data);				
		if(data.datos[0].flats != null)			
		   inicializarFlat(data);								
		if(data.datos[0].tipoPago == "NA")								
		   inicializarNA(data);																	
	}	
	
	$( ".datepicker" ).datepicker( { dateFormat: 'mm/dd/yy' } );
	if(data.edoCto != 1)
	{
		mostratPantallaEstadoNoRegistro();
	}						  
	else if(data.edoCto == 1)
	{
		mostratPantallaEstadoNoRegistro();
	}
}		

function inicializar(){
    $("#justificacion").val("");
    
    if($("#msgExito").val() != "")
    {	    	
    	showMessage($("#msgExito").val());
    	$("#msgExito").val("");
    }
    
    if($("#msgError").val() != "")
    {
    	showError($("#msgError").val());
    	$("#msgError").val("");
    }
    
	$( "input[type='radio']" ).on({
	     'click' : function( ){		                                    
		        if($(this).attr( 'id' ) == "optradioSusc")	mostrarDivSuscriptor();
		        if($(this).attr( 'id' ) == "optradioFlat")	mostrarDivFlat();
		        if($(this).attr( 'id' ) == "optradioNA")    mostrarFeesNA();
		        if($(this).attr( 'id' ) == "optradioCostoTotal")    mostrarFeesCostoTotal();
		        
		        if($(this).attr( 'id' ) == "perBase")
		        {
		        	$("#perVacio").attr('checked', false);
		        	mostrarElementosPeriodos(false);
		        }
		           
		        if($(this).attr( 'id' ) == "perVacio")
		        {
		        	$("#perBase").attr('checked', false);
		        	mostrarElementosPeriodos(true);
		        }
		        
		        if($(this).attr( 'id' ) == "perBaseF")		        
		           $("#perVacioF").attr('checked', false);		        			       
		           
		        if($(this).attr( 'id' ) == "perVacioF")		        
		           $("#perBaseF").attr('checked', false);		        			           
	     }		                     
	});							
}

function mostrarFeesCostoTotal(){
	$("#optradioNA").attr('checked', false);
	$("#optradioFlat").attr('checked', false);
	$("#optradioSusc").attr('checked', false);
	$("#optradioCostoTotal").attr('checked', true);
	tipoSuscriptor = "CT";
	$("#divSuscriptores").hide();
	$("#divCostoTotal").show();
	$("#divFlat").hide();	
	$("#divVigencia").hide();
	$("#nuevoPeriodo").hide();
	$("#cargaExcel").hide();	
    $("#divBotones").show();    
    $("#tiempoVida").hide(); 
    $("#divBonoCont").hide();
    $("#divJustificacion").hide();
}

function mostrarFeesNA(){
	$("#optradioNA").attr('checked', true);
	$("#optradioFlat").attr('checked', false);
	$("#optradioSusc").attr('checked', false);
	$("#optradioCostoTotal").attr('checked', false);
	tipoSuscriptor = "NA";
	$("#divSuscriptores").hide();
	$("#divFlat").hide();	
	$("#divVigencia").hide();
	$("#nuevoPeriodo").hide();
	$("#cargaExcel").hide();	
    $("#divBotones").show();    
    $("#tiempoVida").hide(); 
    $("#divBonoCont").hide();
    $("#divJustificacion").show();
    $("#divCostoTotal").hide();
}

function mostrarComunDiv(){
	$("#divVigencia").show();
	$("#nuevoPeriodo").show();
	$("#cargaExcel").show();
	$("#divBonoCont").show();
	$("#divJustificacion").show();
	$("#divCostoTotal").hide();
}

function crearDivHtml(html, posicion){
	return $("<div/>").append(html).addClass("col-xs-"+posicion);
}

function createTdThTabla(sizeColspan, text, enabled, id, type){
	var input = $("<input type='text' value='"+text+"'/>");
	if(enabled == false)
		input.attr("readonly","");	
	
	if(id != null)
		input.attr("id",id);
	
	if(type == 1)
	   return $("<td width='80'/>").append(input).attr("colspan",sizeColspan);
	else
	   return $("<th width='80' />").append(input).attr("colspan",sizeColspan);
}
	
function mostrarTabla(idPeriodo){					
	$("#divTabla" + idPeriodo).show();
	$("#divFlat #divTabla" + idPeriodo).show();			
	$("#divBono"  + idPeriodo).show();				
}

function mostrarElementosPeriodos(valor){	
	$("#selectPeriodos").prop( "disabled", valor);
	$("#checkInfla")    .prop( "disabled", valor);			
}

function mostrarFechaContrato(fechaInicioCto, fechaFinCto, inflacion){
	$("#fechaCtoInicio").val(fechaInicioCto);
	$("#fechaCtoFin")   .val(fechaFinCto);	
	$("#inflacion")     .val(inflacion);	
}

function crearElementoBono(data){
	var wrapper = $("<div/>").append($("<div/>").addClass("col-sm-0"));
	$("#divBonoCont").append(wrapper.append(crearDivBono().addClass("col-sm-10"))); 
	llenarBono(data.bonoSuscriptor);	
}

function inicializarNuevo(data){
	edoCto = 1;	   	   	   
	crearSuscriptor(data.datos[0], data.tipoSuscriptorLista);	   	   	   
	data.datos[0].idContratoPago = -1;	   	   
	crearFlat(data, data.tipoSuscriptorLista, data.anioTipo);	   
	$("#tabla-1 thead tr th:nth-child(2)").text("1: "+$("#fechaCtoInicio").val()+"-"+addYear($("#fechaCtoInicio").val()));  //Se pone la fecha inicial al flat nuevo
	$("#tiempoVida").hide();	
}

function inicializarSuscriptor(data){
	tipoFee     = "s";						
	$("#optradioSusc").prop('checked',true);			
	for(var i=0; i< data.datos.length; i++)
	{												
		crearSuscriptor(data.datos[i], data.tipoSuscriptorLista);
		mostrarTabla(data.datos[i].idContratoPago);	
	}				
	inicializarVacioFlat(data.fechaInicioCto, data.fechaFinCto);			
	mostrarDivSuscriptor();				
}

function inicializarFlat(data){
	tipoFee     = "f";						
	$("#optradioFlat").prop('checked',true);									
	crearFlat(data);																	
	inicializarVacioSuscriptor(data.tipoSuscriptorLista);			
	mostrarDivFlat();		
}

function inicializarNA(data){
	tipoFee     = "NA";
	mostrarFeesNA();	
	inicializarVacioFlat(data.tipoSuscriptorLista, data.anioTipo, data.fechaInicioCto, data.fechaFinCto);
	inicializarVacioSuscriptor(data.tipoSuscriptorLista);	
}

function mostratPantallaEstadoNoRegistro(){
	$('form :input').prop( "disabled", true );
	$('form div.divtabla :input').prop( "readonly", true );
	$('form table.bono   :input').prop( "readonly", true );
	$('form select').prop( "disabled", true);		
	$('form > select').prop( "readonly", true );	
	$('div[id="divBotones"] button').prop( "disabled", true );
	$('table tr').find("span").hide();
}

function setearVariablesPost(periodos, categoriasEliminar, periodosEliminar, bono){
	$("#request")         .val(JSON.stringify(periodos));				
	$("#requestEliminar") .val(JSON.stringify(categoriasEliminar));
	$("#periodosEliminar").val(JSON.stringify(periodosEliminar));
	$("#requestBono")     .val(JSON.stringify(bono));
}

function verificarActualizarResetear(){
	var aux = "nuevo";
	if(tipoOperacion != "nuevo")																					  				
		aux = tipoFee != tipoSuscriptor ? "resetear" : "actualizar"; //Se verifica que la informacion sea del mismo tipo, sino se borrara la anterior y se guarda nueva	
	$("#operacion").val(aux);	
}

function guardarSuscriptorFlat(){
	var periodos = tipoSuscriptor == "s" ? obtenerSuscriptores() : obtenerFlats();
	var bono     = obtenerBono();			
	debugger
	if(periodos.length == 0 && periodosEliminar.length == 0)
		showError("No existen datos a guardar");

	if(validacionForma && !validarAniosContratos(periodos))
	{
		validacionForma = false;		
		showError("Verifica el campo a\u00F1o Contrato es obligatorio, \u00FAnico y debe ser n\u00FAmero entero de dos digitos.");
	}		
		
	if(periodos.length != 0 && validacionForma)				
	{																
		setearVariablesPost(periodos, categoriasEliminar, periodosEliminar, bono);				
		verificarActualizarResetear();												
		
		if($("#operacion").val() == "resetear")				
			verificarCateTitulos(null, null, null, 3);
		else
		{
			$("#forma").submit();
			$("#guardarBtn").prop( "disabled", true );
		}					
	}				
	else if(periodos.length == 0 && periodosEliminar.length != 0)
	{											
		setearVariablesPost(periodos, categoriasEliminar, periodosEliminar, bono);																
		$("#operacion").val("limpiar");				
		$("#forma").submit();
		$("#guardarBtn").prop( "disabled", true );
	}	
}

function actualizarCostosTitulosContrato(){
	var mensaje = "";
	var id = 0;
	id = $("#costoTotalNmb").val();			
	$.post( contextPath + '/contrato/fees/actualizarCostosTitulos.action', { request: id} )
	.done(function( response ) 
	{	
		if(response.msgExito != "")
		{
			$('#dialogTitulosCate').find('div.modal-body').text(response.msgExito);
			$('#dialogTitulosCate').modal("show");			
		}			       
		else
		{			
			$('#dialogTitulosCate').find('div.modal-body').text(response.msgExito);
			$('#dialogTitulosCate').modal("show");		
		}
	});	
}

function guardarNA(){
	var periodos = [];			
	var periodo = {"categorias":null, "fechaFin":null, "fechaInicio":null, "idSuscriptor":null, "idContratoPago":null, "operacion":tipoOperacion, "tipoPago":"NA" };
	periodos.push(periodo);						            
		
	$("#request")         .val(JSON.stringify(periodos));							
	$("#requestEliminar") .val(JSON.stringify(categoriasEliminar));
	$("#periodosEliminar").val(JSON.stringify(periodosEliminar));
						
	verificarActualizarResetear();				
		
	if($("#operacion").val() == "resetear")				
	   verificarCateTitulos(null, null, null, 3);
	else
	{
		$("#forma").submit();
		$("#guardarBtn").prop( "disabled", true );
	}	
}

function inicializarBotonCarga(){
	uploader = new UploaderEX("cargaFeesDiv"); //Se crear el objeto para cargar archivos	    
    uploader.limpiaForma("idFormCargaAlgo");
    $("#esperaDiv").html("");
    
	if(tipoSuscriptor == "s")
	{    	
		$("#labErroExcel").hide();
		$("#divTemplate").hide();
		cargarPeriodosExcel();
		$("#dialogPeriodoExcel").modal("show");
	}    			
	else
	{
		$("#divTemplate").show();
		$("#modalCarga").modal('show');			
	}	
}

function validarAnioContrato(valor){	
	debugger
	var validar = true;
	if(valor == "" || valor == null)
	   validar = false;
	else if(validar && isNaN(valor))
		validar = false;	
	else if(validar && valor.split('').length > 2)
		validar = false;
	else if(validar && (parseInt(valor) <= 0 || parseInt(valor) >= 100) )		
		validar = false;
	
	return validar;
}

function validarAniosContratos(periodos){
	
	var valida = true;
	for(var i=0; i<periodos.length; i++)
	{
		for(var j=i+1; j<periodos.length; j++)
		{
			if(periodos[i].anioContrato == periodos[j].anioContrato)
			{
				valida = false;
				break;
			}			   
		}	
	}
	return valida;
}