package com.mx.dla.dda.contrato.transaccion.terminos.bos;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.transaccion.terminos.daos.TerminosTransaccionDAO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.TerminoMinimoDTO;
import com.mx.dla.global.bos.BaseBO;

@Service
public class TerminosRelease extends BaseBO{

	@Autowired
	private TerminosTransaccionDAO dao;
	
	private List<Long> ids;
	
	public String[][] obtenerRelease(Long idContrato, String seccion){
		
		List<TerminoMinimoDTO> valores = dao.obtenerRelease(idContrato, seccion);
		String [][] datos = {{null, null, null}};		
		
		if(valores != null && !valores.isEmpty())		
		{			
			datos = new String[valores.size()][3];						
			
			for(int i=0; i<valores.size(); i++)
			{				
				datos[i][0] = String.valueOf(valores.get(i).getDesde());
				datos[i][1] = String.valueOf(valores.get(i).getHasta());
				datos[i][2] = String.valueOf(valores.get(i).getCategoria());			
			}	
		}		 							
		return datos;	
	}	
	
	public void guardarRelease(String datos[][], Long idContrato, String seccion) throws ResultMapException, SQLException, TransaccionException{
		try
		{			
			logger.debug("release");
			ids = new ArrayList<Long>();			
			long idSeccion = dao.obtenerIdSeccion(idContrato, seccion);
			logger.debug(""+idSeccion);
		    for(int i=0; i< datos.length; i++)
		    {
		    	TerminoMinimoDTO release = this.generearMinimoDTO(datos[i][0], datos[i][1], datos[i][2]);
		    	dao.guardarValoresRelease(release, idContrato, idSeccion);
		    	ids.add(release.getId());			    
			}		    		    				    			    			    
		} catch (PersistenceException e) {
			throw new TransaccionException("Se genero un error al guardar los datos.", e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Se genero un error al guardar los datos.", e);
		}	 				
	}
	
	public TerminoMinimoDTO generearMinimoDTO(String desde, String hasta, String categoria){		
		TerminoMinimoDTO min = new TerminoMinimoDTO();
		if(desde != null)
		  min.setDesde(Double.parseDouble(desde));
		if(hasta != null)
		  min.setHasta(Double.parseDouble(hasta));		
		min.setCategoria(categoria);		
		return min;
	}

	public Long[] getIds() {
		Long[] idsA = new Long[this.ids.size()]; 
		
		if(this.ids != null){
		  for(int i=0; i<this.ids.size();i++)
		      idsA[i] = ids.get(i).longValue();	
		}
		return idsA; 
	}	
}
