package com.mx.dla.dda.restClient.bos;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.PostConstruct;

import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;

public class DLARestClientFactory extends BaseBO{

	private Map<String, String> services;
	private Map<String, DLARestClient> clients;
	
	@PostConstruct
	private void init() throws SocketTimeoutException, IOException, TransaccionException
	{
		clients = new HashMap<String, DLARestClient>();
		for(Map.Entry<String, String> entry:  services.entrySet())
		{
			String uri = entry.getValue();
			DLARestClient rc = new DLARestClient(uri);
			clients.put(entry.getKey(), rc);
		}
	}
	
	public DLARestClient getClient(String service) {
		DLARestClient client = clients.get(service);
		if (client == null) {
			throw new IllegalArgumentException("No existe el servicio: " + service);
		}
		return client;
	}
	
	public DLARestClient getClient(DLARestServices service) {
		return getClient(service.name());
	}

	public void setServices(Map<String, String> services) {
		this.services = services;
	}
}
