package com.mx.dla.dda.reporte.pagosTransaccion.actions;

import java.util.Arrays;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.titulos.constants.TipoOrden;
import com.mx.dla.dda.contrato.titulos.constants.TipoTitulo;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.reporte.pagosTransaccion.bos.PagoTransaccionHistoricoBO;
import com.mx.dla.dda.reporte.pagosTransaccion.dtos.PagoTransaccion;
import com.mx.dla.dda.reporte.pagosTransaccion.dtos.PagoTransaccionFiltros;
import com.mx.dla.global.actions.BaseAction;

public class PagoTransaccionHistoricoAction extends BaseAction{
	
	private static final long serialVersionUID = 127647227585669066L;
	private List<PagoTransaccion> pagos;
	private PagoTransaccionFiltros filtros;
	private String error;
	
	@Autowired
	private PagoTransaccionHistoricoBO pagoTransaccionBO;
	
	@Override
	public String execute() throws TransaccionException {
		try {
			return super.execute();
		} catch (Exception e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
	}
	
	public String buscaPagos()
	{
		logger.info("filtros [{}]",filtros);
		pagos =  pagoTransaccionBO.buscarPagos(filtros);
		return SUCCESS;
	}
	
	public List<CatalogoDTO> getEstudios()
	{
		return pagoTransaccionBO.buscarEstudios();
	}

	public List<TipoTitulo> getTipoTitulos() {
		return Arrays.asList(TipoTitulo.values());
	}
	
	public List<TipoOrden> getTipoOrden() {
		return Arrays.asList(TipoOrden.values());
	}
	
	public List<PagoTransaccion> getPagos() {
		return pagos;
	}
	
	public List<String> getMeses() {
		return  pagoTransaccionBO.calculaColumnaMeses(filtros);
	}
	
	
	public void setPagos(List<PagoTransaccion> pagos) {
		this.pagos = pagos;
	}
	
	public PagoTransaccionFiltros getFiltros() {
		return filtros;
	}
	public void setFiltros(PagoTransaccionFiltros filtros) {
		this.filtros = filtros;
	}
	public String getError() {
		return error;
	}
	public void setError(String error) {
		this.error = error;
	}
}
