package com.mx.dla.dda.factura.listado.bos;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.factura.listado.daos.FacturaListadoDAO;
import com.mx.dla.dda.factura.listado.dtos.FacturaListadoDTO;
import com.mx.dla.dda.factura.listado.dtos.FacturaListadoPantalla;
import com.mx.dla.global.bos.BaseBO;

@Service
public class FacturaListadoBO extends BaseBO {

	@Autowired
	private FacturaListadoDAO facturaListadoDAO;

	public List<FacturaListadoPantalla> getListadoFacturas(List<Integer> estudios, String numeroFact) {
		List<FacturaListadoPantalla> listado = new ArrayList<FacturaListadoPantalla>();

		if (numeroFact != null)
			numeroFact += "%";

		logger.debug("num:" + numeroFact);
		List<FacturaListadoDTO> listadoBd = facturaListadoDAO.getListadoFacturas(estudios, numeroFact);

		for (FacturaListadoDTO item : listadoBd) {
			FacturaListadoPantalla pantalla = this.dto2pantallaListadoFactura(item);
			listado.add(pantalla);
		}

		return listado;
	}

	public void eliminarListadoFactura(Long idFactura) {
		facturaListadoDAO.eliminarListadoFacturaDetalle(idFactura);
		facturaListadoDAO.eliminarListadoFactura(idFactura);
	}

	private FacturaListadoPantalla dto2pantallaListadoFactura(FacturaListadoDTO factura) {
		FacturaListadoPantalla pantallaItem = new FacturaListadoPantalla();

		pantallaItem.setNumero(factura.getNumero());
		pantallaItem.setEstudio(factura.getEstudio());
		pantallaItem.setFacturaSap(factura.getFacturaSap());
		pantallaItem.setDocumentoSap(factura.getDocumentoSap());

		Calendar cal = Calendar.getInstance();
		cal.setTime(factura.getFecha());
		int anio = cal.get(Calendar.YEAR);
		int mes = cal.get(Calendar.MONTH);
		int dia = cal.get(Calendar.DAY_OF_MONTH);

		String fecha = "" + (mes + 1) + "/" + dia + "/" + anio;
		pantallaItem.setFecha(fecha);

		pantallaItem.setApproved(String.valueOf(factura.getApproved()));
		pantallaItem.setSap(String.valueOf(factura.getSap()));

		pantallaItem.setAmount(factura.getAmount());

		if (pantallaItem.getApproved().compareTo("1") == 0)
			pantallaItem.setAcciones("1");
		else
			pantallaItem.setAcciones("2");

		pantallaItem.setIdFactura(String.valueOf(factura.getIdFactura()));
		return pantallaItem;
	}
}
