package com.mx.dla.dda.ncredito.general.bos;

import java.io.IOException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.general.constants.InterfazWSRespuesta;
import com.mx.dla.dda.ncredito.general.dtos.ContratoNotaCreditoGeneralDTO;
import com.mx.dla.dda.ncredito.ws.dtos.DTNotaCredito;
import com.mx.dla.dda.ncredito.ws.dtos.NotaCreditoDTO;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;

@Component
public class NotaCreditoWServiceBO extends BaseBO {

	@Autowired
	public DLARestClientFactory			 dlaRestClientFactory;

	@Autowired
	private NCreditoConvertidordDto2Rest convertidor;

	@Value("${factura.detalle.isoMedida}")
	protected String					 isoMedida;

	public Integer notificaFacturaInterfaz(ContratoNotaCreditoGeneralDTO facturaDTO) {

		Integer estatus = 0;

		DTNotaCredito message = convertidor.generaFacturaWS(facturaDTO);

		try {
			logger.info("Notificar Factura Request : {}", message.getRegistro());

			DLARestClient client = dlaRestClientFactory.getClient(DLARestServices.NOTA_CREDITO_CARGA);
			NotaCreditoDTO response = client.get(message, NotaCreditoDTO.class);
			
			logger.info("Notificar Factura Response {}", response.getEstatusDda());

			if (response != null && response.getEstatusDda() != null && InterfazWSRespuesta.parse(response.getEstatusDda()).equals(InterfazWSRespuesta.OK)) {
				estatus = new Integer(InterfazWSRespuesta.OK.getValue());
				facturaDTO.setIdSapRegistro(response.getrFactura());
			}
			else
				estatus = new Integer(InterfazWSRespuesta.ERROR.getValue());

		} catch (IOException e) {
			logger.error("Error: " + e.getMessage());
			estatus = 0;
		} catch (TransaccionException e) {
			logger.error("Error: " + e.getMessage());
			estatus = 0;
		}
		return estatus;
	}

}
