package com.mx.dla.admin.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;

import com.mx.dla.admin.bos.MenuBO;
import com.mx.dla.admin.daos.PerfilDAO;
import com.mx.dla.admin.daos.UsuarioDAO;
import com.mx.dla.admin.dtos.MenuDTO;
import com.mx.dla.admin.dtos.PerfilDTO;
import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.opensymphony.xwork2.ActionContext;

@Controller
@Scope("request")
public class InicioAction extends BaseContratoAction {
	
	private static final long serialVersionUID = 1L;
	
	@Autowired
	private UsuarioDAO usuarioDAO;
	
	@Autowired
	private PerfilDAO perfilDAO;
	
	@Autowired
	private MenuBO menuBO;
	
	List<MenuDTO> menusUsuario = null;
	
	@Override
	public String execute() throws Exception {

		Authentication autenticacion = SecurityContextHolder.getContext().getAuthentication();		 
		UsuarioDTO usuario 	= usuarioDAO.obtenerUsuario( autenticacion.getName() );
		
		ActionContext.getContext().getSession().remove("pmn");		
		ActionContext.getContext().getSession().remove("pmnReturn");
		
		String retorno = SUCCESS;
		
		if( !this.getPmn().equals("0") )
			retorno = "menu_" + this.getPmn();
		
		if( usuario != null )
		{
			getSession().put("permisos", menuBO.obtenPermisosPerfil(usuario.getPerfil().getIdPerfil()));
			String idPerfil 	= usuario.getPerfil().getIdPerfil();
			
			if( idPerfil != null )
			{
				PerfilDTO perfil 	= perfilDAO.obtenerPerfil( idPerfil );
				
				logger.debug("PerfilDTO : [{}]", perfil);
				
				
				if( perfil != null )
				{
					getSession().put("usuario", usuario);
					
					List<MenuDTO> menusPerfil = perfil.getMenus();
					
					if( menusPerfil != null ){
						menusUsuario = menuBO.armarArbolMenus( menusPerfil, idPerfil );
						getSession().put("menus", perfil.getMenus() );	
					}								
				} else
				{
					retorno = "error_002";
				}
			} else
			{
				retorno = "error_002";
			}
		} else {
			retorno = "error_001";
		}
		
		
		
		return retorno;
	}
	
}

