package com.mx.dla.dda.admin.bloqueo.actions;

import java.sql.SQLException;
import java.time.LocalDate;

import org.apache.ibatis.executor.result.ResultMapException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.carga.transaccion.bos.CargaTransaccionesBO;
import com.mx.dla.dda.carga.transaccion.dtos.FechaBloqueoDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.actions.BaseAction;
import com.opensymphony.xwork2.Action;


public class BloqueoSAPAction extends BaseAction {

	private static final long serialVersionUID = -1L;
	private static Logger log = Logger.getLogger(BloqueoSAPAction.class);
	
	private String anio;
	private String mes;
	private String dia;
	
	
	@Autowired
	private CargaTransaccionesBO bdsp;
	
	private String fecha;
	
	@Override
	public String execute() throws Exception {
		LocalDate currentDate = LocalDate.now();
		FechaBloqueoDTO fecha = bdsp.consultaMesActual(String.valueOf(currentDate.getYear()), 
				String.valueOf(currentDate.getMonthValue()));
		setAnio(fecha.getAnio());
		setMes(fecha.getMes());
		setDia(fecha.getDia());
		return SUCCESS;
	}
	
		

	

	public String ejecutaBloqueoSAP() {

		try {
			bdsp.ejecutaSP(fecha);
		} catch (ResultMapException e) {
			addActionError("Ha ocurrido un error.");
			log.error("Ha ocurrido el siguiente error durante la consulta: " + e.getMessage(), e);
		} catch (TransaccionException e) {
			addActionError("Ha ocurrido un error.");
			log.error("Ha ocurrido el siguiente error durante la consulta: " + e.getMessage(), e);
		} catch (SQLException e) {
			addActionError("Ha ocurrido un error.");
			log.error("Ha ocurrido el siguiente error durante la consulta: " + e.getMessage(), e);
		}

		return Action.SUCCESS;
	}


	public String getFecha() {
		return fecha;
	}

	public void setFecha(String fecha) {
		this.fecha = fecha;
	}

	public String getAnio() {
		return anio;
	}

	public void setAnio(String anio) {
		this.anio = anio;
	}

	public String getMes() {
		return mes;
	}

	public void setMes(String mes) {
		this.mes = mes;
	}
	
	public String getDia() {
		return dia;
	}

	public void setDia(String dia) {
		this.dia = dia;
	}	
}
