package com.mx.dla.dda.admin.catalogos.addons.actions;

import java.io.File;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;

import com.mx.dla.dda.admin.catalogos.addons.bos.AddOnBO;
import com.mx.dla.dda.admin.catalogos.addons.bos.EstudioAddonBO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.CatalogoAddOnDTO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.EstudioAddonDTO;
import com.mx.dla.dda.admin.catalogos.estudios.bos.EstudioBO;
import com.mx.dla.dda.admin.catalogos.tipoCambioAddOns.dtos.PaisAddOnsVDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.actions.BaseAction;
import com.opensymphony.xwork2.Action;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class CatalogoAddOnsAction extends BaseAction {
	private static final long serialVersionUID = 1L;

	private List<CatalogoAddOnDTO> catalogoAddOns;
	private CatalogoAddOnDTO addOn;
	private boolean addOnActualizado;
	private boolean regresoAction;
	private List<EstudioAddonDTO> estudios;
	private List<PaisAddOnsVDTO> paises;
	private Integer idAddOn;
	private Integer idRelacion;
	private Integer idEstudio;
	private String pais;
	private Integer revenueShare;
	private Double precio;
	private Double vat;
	private Double precioNeto;
	private Double vatFijo;
	private Double precioNetoFijo;
	private String tipoDeCambio;
	private String calculoMontoXPais;
	private String calculoRevenueShare;
	private String preferido;
	private Double tarifaMinima;
	private boolean seRepitePais;

	private File file;
	private String fileContentType;
	private String fileFileName;
	private InputStream fileInputStream;

	@Autowired
	private AddOnBO addOnBO;

	@Autowired
	private EstudioBO estudioBO;

	@Autowired
	private EstudioAddonBO estudioAddonBO;

	@Override
	public String execute() throws Exception {
		setPmns();
		return SUCCESS;
	}

	public String listadoAddOns() {
		try {
			catalogoAddOns = addOnBO.catalogoAddOns();
		} catch (ResultMapException e) {
			addActionError("Ha ocurrido un error.");
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			addActionError("Ha ocurrido un error.");
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			addActionError("Ha ocurrido un error.");
			logger.error("Error. {}", e);
		}

		return Action.SUCCESS;
	}

	public void setPmns() {
		logger.debug("pmn : " + this.getPmn() + "pmnReturn : " + this.getPmnReturn());
		this.getSession().put("pmn", 205);
		this.getSession().put("pmnReturn", 205);
		this.setPmn("205");
		this.setPmnReturn("205");
	}

	public String dirigirAgregarAddOn() throws Exception {
		setPmns();
		setEstudios(estudioAddonBO.getEstudios());
		setPaises(addOnBO.obtenerPaisesAddOn());
		return SUCCESS;
	}

	public String guardaAddOn() {
		if (idEstudio != null && pais != null) {
			try {
				this.addOn = addOnBO.guardarAddOn(idAddOn, idEstudio, pais, revenueShare, precio, vat, precioNeto, vatFijo, precioNetoFijo,
						tipoDeCambio, calculoMontoXPais, calculoRevenueShare, tarifaMinima, preferido);
				this.addOnActualizado = true;
			} catch (DuplicateKeyException e) {
				this.addOn = new CatalogoAddOnDTO();
				this.addOnActualizado = false;
				this.seRepitePais = true;
			} catch (ResultMapException e) {
				this.addOnActualizado = false;
				logger.error("Error. {}", e);
				return "";
			} catch (PersistenceException ibe) {
				this.addOnActualizado = false;
				logger.error("Error. {}", ibe);
				return "";
			} catch (TransaccionException e) {
				this.addOnActualizado = false;
				logger.error("Error. {}", e);
				return "";
			} catch (SQLException e) {
				this.addOnActualizado = false;
				logger.error("Error. {}", e);
				return "";
			}
		}

		setPmns();
		return Action.SUCCESS;
	}

	public String actualizaAddOn() {
		try {
			addOn.setIdAddOn(idAddOn);
			logger.debug("[{}]", addOn);
			addOnBO.updateAddOn(addOn);
			// String idAddOn = this.addOn.getIdAddOn();
			this.addOn = addOnBO.catalogoAddOnsPorId(idAddOn);
			this.addOnActualizado = true;
			setIdAddOn(addOn.getIdAddOn());

		} catch (ResultMapException e) {
			this.addOnActualizado = false;
			logger.error("Error. {}", e);
			return "";
		} catch (PersistenceException ibe) {
			this.addOnActualizado = false;
			logger.error("Error. {}", ibe);
			return "";
		} catch (TransaccionException e) {
			this.addOnActualizado = false;
			logger.error("Error. {}", e);
			return "";
		} catch (SQLException e) {
			this.addOnActualizado = false;
			logger.error("Error. {}", e);
			return "";
		}
		setPmns();

		return "addOnActualizado";
	}

	public String buscaAddOn() {
		try {
			setAddOn(addOnBO.catalogoAddOnsPorId(idAddOn));
		} catch (ResultMapException e) {
			this.addOnActualizado = false;
			logger.error("Error. {}", e);
			return "";
		} catch (PersistenceException ibe) {
			this.addOnActualizado = false;
			logger.error("Error. {}", ibe);
			return "";
		} catch (TransaccionException e) {
			this.addOnActualizado = false;
			logger.error("Error. {}", e);
			return "";
		} catch (SQLException e) {
			this.addOnActualizado = false;
			logger.error("Error. {}", e);
			return "";
		}
		return "addOnConsultado";
	}

	public String obtnerAddOn() {
		try {
			setAddOn(addOnBO.catalogoAddOnsPorId(idAddOn));
			setEstudios(estudioBO.catalogoEstudiosAddOn());
			setPaises(addOnBO.obtenerPaisesAddOn());
		} catch (ResultMapException e) {
			this.addOnActualizado = false;
			logger.error("Error. {}", e);
			return "";
		} catch (PersistenceException ibe) {
			this.addOnActualizado = false;
			logger.error("Error. {}", ibe);
			return "";
		} catch (TransaccionException e) {
			this.addOnActualizado = false;
			logger.error("Error. {}", e);
			return "";
		} catch (SQLException e) {
			this.addOnActualizado = false;
			logger.error("Error. {}", e);
			return "";
		}
		return SUCCESS;
	}

	public String actualizaAddOnMod() {
		try {
			addOnBO.actulizaCatalogoAddOn(idAddOn, idEstudio, pais, revenueShare, precio, vat, precioNeto, vatFijo, precioNetoFijo, 
					tipoDeCambio, calculoMontoXPais, calculoRevenueShare, tarifaMinima, preferido);
			this.addOn = addOnBO.catalogoAddOnsPorId(idAddOn);
			this.addOnActualizado = true;
		} catch (ResultMapException e) {
			this.addOnActualizado = false;
			logger.error("Error. {}", e);
			return "";
		} catch (PersistenceException ibe) {
			this.addOnActualizado = false;
			logger.error("Error. {}", ibe);
			return "";
		} catch (TransaccionException e) {
			this.addOnActualizado = false;
			logger.error("Error. {}", e);
			return "";
		} catch (SQLException e) {
			this.addOnActualizado = false;
			logger.error("Error. {}", e);
			return "";
		}

		return SUCCESS;
	}

	public String eliminaprecioAddOn() {
		try {
			addOnBO.eliminaprecioAddOn(idAddOn,preferido,idRelacion);
			this.addOnActualizado = true;
		} catch (ResultMapException e) {
			this.addOnActualizado = false;
			logger.error("Error. {}", e);
			return "";
		} catch (PersistenceException ibe) {
			this.addOnActualizado = false;
			logger.error("Error. {}", ibe);
			return "";
		} catch (TransaccionException e) {
			this.addOnActualizado = false;
			logger.error("Error. {}", e);
			return "";
		} catch (SQLException e) {
			this.addOnActualizado = false;
			logger.error("Error. {}", e);
			return "";
		}
		return SUCCESS;
	}

}
