package com.mx.dla.dda.admin.catalogos.estudios.actions;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.grupoestudio.bos.GrupoEstudioBO;
import com.mx.dla.dda.admin.catalogos.grupoestudio.dtos.GrupoEstudioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

public class AgregarEstudioAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	public List<GrupoEstudioDTO> grupos;

	@Autowired
	private GrupoEstudioBO grupoEstudioBO;

	@Override
	public String execute() {
		logger.debug("In AgregarEstudioAction.");
		try {
			setGrupos(grupoEstudioBO.obtenerGrupoEstudio(null));
		} catch (ResultMapException e) {
			logger.error("Ocurri un error al obtener los datos.", e);
		} catch (PersistenceException ibe) {
			logger.error("Ocurri un error al obtener los datos.", ibe);
		} catch (TransaccionException e) {
			logger.error("Ocurri un error al obtener los datos.", e);
		} catch (SQLException e) {
			logger.error("Ocurri un error al obtener los datos.", e);
		}
		this.getSession().put("pmn", this.getPmn());
		this.getSession().put("pmnReturn", this.getPmnReturn());
		return SUCCESS;
	}

	public void setGrupos(List<GrupoEstudioDTO> grupos) {
		this.grupos = grupos;
	}

	public List<GrupoEstudioDTO> getGrupos() {
		return grupos;
	}

}
