package com.mx.dla.dda.admin.catalogos.grupoestudio.actions;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.grupoestudio.bos.GrupoEstudioBO;
import com.mx.dla.dda.admin.catalogos.grupoestudio.dtos.GrupoEstudioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

public class GrupoEstudioAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;
	@Autowired
	private GrupoEstudioBO grupoEstudioBO;

	public List<GrupoEstudioDTO> grupos;
	public GrupoEstudioDTO grupo;
	public Long idGrupo;
	public String descripcion;
	public Integer estatus;
	public String operacion;
	public Integer orden;
	public Integer colapsa;

	@Override
	public String execute() {
		return SUCCESS;
	}

	public String obtnerGrupos() {
		try {
			setGrupos(grupoEstudioBO.obtenerGrupoEstudio(null));
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		}
		return "regresaInformacion";
	}

	public String obtneGrupo() {
		try {
			setGrupo(grupoEstudioBO.obtenerGrupo(idGrupo));
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		}
		return SUCCESS;
	}

	public String registraActualiza() {
		try {
			grupoEstudioBO.registraActualizaGrupo(operacion, idGrupo, descripcion, estatus, orden, colapsa);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		}
		return SUCCESS;

	}

	public void setGrupos(List<GrupoEstudioDTO> grupos) {
		this.grupos = grupos;
	}

	public List<GrupoEstudioDTO> getGrupos() {
		return grupos;
	}

	public void setIdGrupo(Long idGrupo) {
		this.idGrupo = idGrupo;
	}

	public Long getIdGrupo() {
		return idGrupo;
	}

	public void setGrupo(GrupoEstudioDTO grupo) {
		this.grupo = grupo;
	}

	public GrupoEstudioDTO getGrupo() {
		return grupo;
	}

	public void setDescripcion(String descripcion) {
		this.descripcion = descripcion;
	}

	public String getDescripcion() {
		return descripcion;
	}

	public void setEstatus(Integer estatus) {
		this.estatus = estatus;
	}

	public Integer getEstatus() {
		return estatus;
	}

	public void setOperacion(String operacion) {
		this.operacion = operacion;
	}

	public String getOperacion() {
		return operacion;
	}

	public void setOrden(Integer orden) {
		this.orden = orden;
	}

	public Integer getOrden() {
		return orden;
	}

	public void setColapsa(Integer colapsa) {
		this.colapsa = colapsa;
	}

	public Integer getColapsa() {
		return colapsa;
	}

}
