package com.mx.dla.dda.admin.catalogos.pais.actions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.pais.bos.CatalogoPaisBO;
import com.mx.dla.dda.admin.catalogos.pais.dtos.CatalogoPaisDTO;
import com.mx.dla.dda.catalogos.bos.CatalogosBO;
import com.mx.dla.dda.catalogos.dtos.RegionVentaDTO;
import com.mx.dla.dda.catalogos.dtos.TerritorioDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.actions.BaseAction;

public class CatalogoPaisAction extends BaseAction {

	private static final long serialVersionUID = -1L;
	private static Logger log = Logger.getLogger(CatalogoPaisAction.class);

	private List<CatalogoPaisDTO> catalogoPais;
	private CatalogoPaisDTO pais;
	private boolean paisActualizado;
	private boolean regresoAction;

	private List<TerritorioDTO> catalogoTerritorio;
	private List<RegionVentaDTO> catalogoRegion;

	@Autowired
	private CatalogoPaisBO catalogoPaisBO;

	@Autowired
	private CatalogosBO catalogosBO;

	@Override
	public String execute() throws Exception {
		return SUCCESS;
	}

	public String listadoPais() {

		try {
			catalogoPais = new ArrayList<CatalogoPaisDTO>();
			catalogoPais = catalogoPaisBO.getCatalogoPais();
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		}
		return "catalogoPaisLista";
	}

	public String guardaPais() {

		try {
			regresoAction = true;
			CatalogoPaisDTO paisNuevo = new CatalogoPaisDTO(this.pais);
			catalogoPaisBO.guardarPais(paisNuevo);
			paisActualizado = true;
		} catch (ResultMapException e) {
			this.paisActualizado = false;
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			this.paisActualizado = false;
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			this.paisActualizado = false;
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			this.paisActualizado = false;
			logger.error("Error. {}", e);
		}
		getListados();
		return "irCrearPais";
	}

	public String irCrearPais() {

		getListados();

		return "irCrearPais";
	}

	public String buscaPais() {
		try {

			log.info("*************Busca pais: " + this.pais.getNombre());
			int idPais = this.pais.getId();
			this.pais = catalogoPaisBO.getPaisPorId(idPais);

			getListados();

			log.info("****" + catalogoTerritorio.toString());

		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		}
		return "paisConsultado";
	}

	public String actualizaPais() {

		try {

			catalogoPaisBO.updatePais(pais);
			int idPais = this.pais.getId();
			this.pais = catalogoPaisBO.getPaisPorId(idPais);
			this.paisActualizado = true;
			this.regresoAction = true;
			getListados();

			log.info("****" + catalogoTerritorio.toString());
		} catch (ResultMapException e) {
			this.paisActualizado = false;
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			this.paisActualizado = false;
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			this.paisActualizado = false;
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			this.paisActualizado = false;
			logger.error("Error. {}", e);
		}
		return "paisConsultado";
	}

	public void getListados() {
		try {
			catalogoTerritorio = new ArrayList<TerritorioDTO>();
			catalogoTerritorio = catalogosBO.obtenListaTerritorios();

			catalogoRegion = new ArrayList<RegionVentaDTO>();
			catalogoRegion = catalogosBO.getRegiones();

		} catch (ResultMapException e) {
			this.paisActualizado = false;
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			this.paisActualizado = false;
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			this.paisActualizado = false;
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			this.paisActualizado = false;
			logger.error("Error. {}", e);
		}
	}

	// Setter y getters
	public CatalogoPaisDTO getPais() {
		return pais;
	}

	public void setPais(CatalogoPaisDTO pais) {
		this.pais = pais;
	}

	public List<CatalogoPaisDTO> getCatalogoPais() {
		return catalogoPais;
	}

	public boolean isPaisActualizado() {
		return paisActualizado;
	}

	public boolean isRegresoAction() {
		return regresoAction;
	}

	public List<TerritorioDTO> getCatalogoTerritorio() {
		return catalogoTerritorio;
	}

	public List<RegionVentaDTO> getCatalogoRegion() {
		return catalogoRegion;
	}
}
