package com.mx.dla.dda.admin.catalogos.tipoCambioAddOns.actions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.addons.dtos.EstudioAddonDTO;
import com.mx.dla.dda.admin.catalogos.estudios.bos.EstudioBO;
import com.mx.dla.dda.admin.catalogos.tipoCambio.dtos.TipoCambioDTO;
import com.mx.dla.dda.admin.catalogos.tipoCambioAddOns.bos.TipoCambioAddOnsBO;
import com.mx.dla.dda.admin.catalogos.tipoCambioAddOns.dtos.MesTiposAddOnsCTDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.reporte.cpview.exception.ReportCostPerViewException;

public class TipoCambioAddOnsAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private List<Integer> annios;
	private List<EstudioAddonDTO> estudios;
	private Integer annio;
	private String estudio;
	private List<TipoCambioDTO> nombreTipos;
	private List<MesTiposAddOnsCTDTO> mesesTipos;
	private boolean exito;
	private String mensaje;
	private String error;
	
	
	private File file;
	private String fileContentType;
	private String fileFileName;
	private InputStream fileInputStream;
	
	@Autowired
	private EstudioBO estudioBO;
	
	@Autowired
	private TipoCambioAddOnsBO tipoCambioAddOnsBO;

	@Override
	public String execute() {

		return SUCCESS;
	}

	public String obtenerLista() {
		try {
		annios = tipoCambioAddOnsBO.obtenerAnnios();
		estudios = estudioBO.catalogoEstudiosAddOn();
	}catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		}

		return SUCCESS;
	}

	public String cargaMasiva() throws ExcelMapperException, IOException {
		try{
			nombreTipos = tipoCambioAddOnsBO.obtenerNombreMeses();
			tipoCambioAddOnsBO.cargaMasivaTipoCambioAddOn(Long.valueOf(annio), Long.parseLong(estudio), file, fileFileName, nombreTipos);
		}catch (ResultMapException e) {
			error = "Ocurrio un error.";
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			error = "Ocurrio un error.";
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			error = "Ocurrio un error.";
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			error = "Ocurrio un error.";
			logger.error("Error. {}", e);
		}
		
		return SUCCESS;
	}
	
	
    public String exportarReporte() {
        try {
           
            fileInputStream = tipoCambioAddOnsBO.obtenerStreamReporte(Long.parseLong(estudio),annio);
            logger.info("ao para descarga" + annio);
        } catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			logger.error("Error. {}", ibe);
		} catch (IllegalArgumentException e) {
			logger.error("Error. {}", e);
		} catch (IllegalAccessException e) {
			logger.error("Error. {}", e);
		} catch (ParseException e) {
			logger.error("Error. {}", e);
		} catch (ExcelMapperException e) {
			logger.error("Error. {}", e);
		} catch (IOException e) {
			logger.error("Error. {}", e);
		} catch (ReportCostPerViewException e) {
			logger.error("Error. {}", e);
		}  
        return SUCCESS;
    }
	
	
	public String obtenerMesTipo() {
		try {
			nombreTipos = tipoCambioAddOnsBO.obtenerNombreMeses();
			mesesTipos = tipoCambioAddOnsBO.obtenerMesTipo(Long.valueOf(estudio), annio, nombreTipos);
		}catch (ResultMapException e) {
			error = "Ocurrio un error.";
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			error = "Ocurrio un error.";
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			error = "Ocurrio un error.";
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			error = "Ocurrio un error.";
			logger.error("Error. {}", e);
		}
		
		return SUCCESS;
	}
	
	public String guardarCambio() {
		
		try{
			exito = tipoCambioAddOnsBO.guardarCambios(mesesTipos);
			mensaje = "Se actualizaron los cambios.";
		}catch (ResultMapException e) {
			error = "Ocurrio un error.";
			mensaje = "Ocurrio un error.";
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			error = "Ocurrio un error.";
			mensaje = "Ocurrio un error.";
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			error = "Ocurrio un error.";
			mensaje = "Ocurrio un error.";
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			error = "Ocurrio un error.";
			mensaje = "Ocurrio un error.";
			logger.error("Error. {}", e);
		}
		
		return SUCCESS;
	}

	public List<Integer> getAnnios() {
		return annios;
	}

	public void setAnnios(List<Integer> annios) {
		this.annios = annios;
	}
	
	public Integer getAnnio() {
		return annio;
	}

	public void setAnnio(Integer annio) {
		this.annio = annio;
	}

	public List<TipoCambioDTO> getNombreTipos() {
		return nombreTipos;
	}

	public void setNombreTipos(List<TipoCambioDTO> nombreTipos) {
		this.nombreTipos = nombreTipos;
	}

	public List<MesTiposAddOnsCTDTO> getMesesTipos() {
		return mesesTipos;
	}

	public void setMesesTipos(List<MesTiposAddOnsCTDTO> mesesTipos) {
		this.mesesTipos = mesesTipos;
	}

	public boolean isExito() {
		return exito;
	}

	public void setExito(boolean exito) {
		this.exito = exito;
	}

	public String getMensaje() {
		return mensaje;
	}

	public void setMensaje(String mensaje) {
		this.mensaje = mensaje;
	}

	public String getError() {
		return error;
	}

	public void setError(String error) {
		this.error = error;
	}

	public List<EstudioAddonDTO> getEstudios() {
		return estudios;
	}

	public void setEstudios(List<EstudioAddonDTO> estudios) {
		this.estudios = estudios;
	}

	public EstudioBO getEstudioBO() {
		return estudioBO;
	}

	public void setEstudioBO(EstudioBO estudioBO) {
		this.estudioBO = estudioBO;
	}

	public String getEstudio() {
		return estudio;
	}

	public void setEstudio(String estudio) {
		this.estudio = estudio;
	}

	public File getFile() {
		return file;
	}

	public void setFile(File file) {
		this.file = file;
	}

	public String getFileContentType() {
		return fileContentType;
	}

	public void setFileContentType(String fileContentType) {
		this.fileContentType = fileContentType;
	}

	public String getFileFileName() {
		return fileFileName;
	}

	public void setFileFileName(String fileFileName) {
		this.fileFileName = fileFileName;
	}

	public InputStream getFileInputStream() {
		return fileInputStream;
	}

	public void setFileInputStream(InputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}
}