package com.mx.dla.dda.admin.catalogos.transacciones.actions;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.transacciones.bos.TransaccionesBO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.EstudiosTransDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.actions.BaseAction;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class EstudiosTransAction extends BaseAction {
	
	private static final long serialVersionUID = 1L;
	private List<EstudiosTransDTO> estudiosTrans;
	private EstudiosTransDTO estudio;
	private String nombreEstudio;
	private String revenueShare;
	private String idEstudio;
	private String valido;

	@Autowired
	private TransaccionesBO transacciones;

	@Override
	public String execute() throws Exception {
		setPmns();
		return SUCCESS;
	}

	public String listadoEstudiosTrans() {

		try {
			setEstudiosTrans(transacciones.getEstudiosTrans());
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		}
		return SUCCESS;
	}

	public void setPmns() {
		logger.debug("pmn : " + this.getPmn() + "pmnReturn : " + this.getPmnReturn());
		this.getSession().put("pmn", 211);
		this.getSession().put("pmnReturn", 211);
		this.setPmn("211");
		this.setPmnReturn("211");
	}

	public String dirigirAgregar() throws Exception {
		setPmns();
		return SUCCESS;
	}

	public String guardaEstudioTrans() {
		EstudiosTransDTO estudio = new EstudiosTransDTO();
		estudio.setNombre(nombreEstudio);
		estudio.setRevenueShare(revenueShare);

		try {
			transacciones.agregarEstudioTrans(estudio);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		}
		setPmns();
		return SUCCESS;
	}

	public String eliminaEstudioTrans() {
		EstudiosTransDTO estudio = new EstudiosTransDTO();
		estudio.setIdEstudio(idEstudio);
		estudio.setBorrado("0");

		try {
			transacciones.eliminarEstudio(estudio);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		}
		setPmns();
		return SUCCESS;
	}

	public String llamaObtenEstudio() throws Exception {

		try {
			setEstudio(transacciones.getEstudioTransById(idEstudio));
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		}
		setPmns();
		return SUCCESS;
	}

	public String llamaActualizaEstudio() throws Exception {
		EstudiosTransDTO estudio = new EstudiosTransDTO();
		estudio.setIdEstudio(idEstudio);
		estudio.setNombre(nombreEstudio);
		estudio.setRevenueShare(revenueShare);
		estudio.setBorrado("0");

		try {
			transacciones.updateEstudioTrans(estudio);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		}
		setPmns();
		return SUCCESS;
	}

}
