package com.mx.dla.dda.admin.catalogos.transacciones.actions;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.transacciones.bos.TransaccionesBO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.EstudiosTransDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.ExcepcionesTransDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.actions.BaseAction;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class ExcepcionesTransAction extends BaseAction {

	private static final long serialVersionUID = 1L;
	private List<ExcepcionesTransDTO> excepciones;
	private List<EstudiosTransDTO> estudiosTrans;
	private ExcepcionesTransDTO excepcion;
	private String nombreEstudio;
	private String titulo;
	private String revenueShare;
	private String fechaInicio;
	private String fechaFin;
	private String idExcepcion;

	private boolean excepcionActualizada;

	@Autowired
	private TransaccionesBO transacciones;

	@Override
	public String execute() throws Exception {
		setPmns();
		excepcionActualizada = true;
		return SUCCESS;
	}

	public String listadoExcepciones() {

		try {
			setExcepciones(transacciones.getExcepciones());
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		}
		return SUCCESS;
	}

	public void setPmns() {
		logger.debug("pmn : " + this.getPmn() + "pmnReturn : " + this.getPmnReturn());
		this.getSession().put("pmn", 213);
		this.getSession().put("pmnReturn", 213);
		this.setPmn("213");
		this.setPmnReturn("213");
	}

	public String dirigirAgregar() throws Exception {

		try {
			setEstudiosTrans(transacciones.getEstudiosTrans());
			excepcionActualizada = true;
		} catch (ResultMapException e) {
			excepcionActualizada = false;
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			excepcionActualizada = false;
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			excepcionActualizada = false;
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			excepcionActualizada = false;
			logger.error("Error. {}", e);
		}
		setPmns();
		return SUCCESS;
	}

	public String guardaExcepcion() {
		ExcepcionesTransDTO excepcion = new ExcepcionesTransDTO();
		excepcion.setEstudio(nombreEstudio);
		excepcion.setTitulo(titulo);
		excepcion.setRevenueShare(revenueShare);
		excepcion.setFechaInicio(fechaInicio);
		excepcion.setFechaFin(fechaFin);

		try {
			if (transacciones.validaExcepcionExistente(excepcion) == null
					&& transacciones.validaMescerrado(excepcion) == null) {
				setExcepcion(excepcion);
				transacciones.agregarExcepcion(excepcion);
				excepcionActualizada = true;
			} else {
				setExcepcion(null);
				excepcionActualizada = false;
			}
		} catch (ResultMapException e) {
			excepcionActualizada = false;
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			excepcionActualizada = false;
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			excepcionActualizada = false;
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			excepcionActualizada = false;
			logger.error("Error. {}", e);
		}
		setPmns();
		return SUCCESS;
	}

	public String eliminaExcepcion() {
		ExcepcionesTransDTO excepcion = new ExcepcionesTransDTO();
		excepcion.setIdExcepcion(idExcepcion);
		excepcion.setBorrado("0");

		try {
			transacciones.eliminarExcepcion(excepcion);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		}
		setPmns();
		return SUCCESS;
	}

	public String llamaObtenExcepcion() throws Exception {

		try {
			setEstudiosTrans(transacciones.getEstudiosTrans());
			setExcepcion(transacciones.getExcepcionesById(idExcepcion));
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		}
		setPmns();
		return SUCCESS;
	}

	public String llamaActualizaExcepcion() throws Exception {
		ExcepcionesTransDTO excepcion = new ExcepcionesTransDTO();
		excepcion.setIdExcepcion(idExcepcion);
		excepcion.setEstudio(nombreEstudio);
		excepcion.setTitulo(titulo);
		excepcion.setRevenueShare(revenueShare);
		excepcion.setFechaInicio(fechaInicio);
		excepcion.setFechaFin(fechaFin);

		try {
			if (transacciones.validaMescerrado(excepcion) == null) {
				setExcepcion(excepcion);
				transacciones.updateExcepcion(excepcion);
				excepcionActualizada = true;
			} else {
				setExcepcion(null);
				excepcionActualizada = false;
			}
		} catch (ResultMapException e) {
			excepcionActualizada = false;
			logger.error("Error. {}", e);
		} catch (PersistenceException ibe) {
			excepcionActualizada = false;
			logger.error("Error. {}", ibe);
		} catch (TransaccionException e) {
			excepcionActualizada = false;
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			excepcionActualizada = false;
			logger.error("Error. {}", e);
		}
		setPmns();
		return SUCCESS;
	}

}
