package com.mx.dla.dda.admin.revenue.actions;

import java.sql.SQLException;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.carga.transaccion.bos.CargaTransaccionesBO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.actions.BaseAction;
import com.opensymphony.xwork2.Action;

public class RevenuePorcAction extends BaseAction {

	private static final long serialVersionUID = -1L;
	private static Logger log = Logger.getLogger(RevenuePorcAction.class);
	
	
	@Autowired
	private CargaTransaccionesBO bdsp;
	
	private String fecha;
	
	@Override
	public String execute() throws Exception {		
		return SUCCESS;
	}
	
		

	
	public String ejecutaSP() {
		try {
			bdsp.ejecutaSP_porcR(fecha);
		} catch (ResultMapException e) {
			log.error("Error. {}", e);
		} catch (PersistenceException e) {
			log.error("Error. {}", e);
		} catch (TransaccionException e) {
			log.error("Error. {}", e);
		} catch (SQLException e) {
			log.error("Error. {}", e);
		}
		return Action.SUCCESS;
	}


	public String getFecha() {
		return fecha;
	}

	public void setFecha(String fecha) {
		this.fecha = fecha;
	}			
}
