package com.mx.dla.dda.carga.transaccion.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.json.simple.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.carga.transaccion.bos.CargaTransaccionesBO;
import com.mx.dla.dda.carga.transaccion.dtos.CargaTransaccionesDTO;
import com.mx.dla.dda.carga.transaccion.dtos.PrincipalCargaTransaccionesDTO;
import com.mx.dla.dda.carga.transaccion.dtos.RowRepErrAsocTitulosDTO;
import com.mx.dla.dda.carga.transaccion.dtos.RowRepErrResumenCargaDTO;
import com.mx.dla.dda.carga.transaccion.dtos.TitulosCargaTransaccionesDTO;
import com.mx.dla.dda.carga.transaccion.ws.asociarTitulosTransCntVigentes.ResponseAsociarTitTransCntVigentesDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.reporte.ws.dtos.ResponseGeneraReporteDTO;

public class CargaTransaccionesAction extends BaseContratoAction {

	private static final long serialVersionUID = -6159275023094659946L;

	private String mes;
	private String error;
	private String FECHA_CARGA;
	private List<CargaTransaccionesDTO> cargaTransacciones;
	private PrincipalCargaTransaccionesDTO principalCargaTransacciones;
	private PrincipalCargaTransaccionesDTO resumencarga;
	private Long idCarga;
	private String IdBv;
	private String ruta;
	private Integer id_carga_titulo;
	private String nombreEstandar;
	private String fileName;
	private ResponseGeneraReporteDTO vistaPrevia;
	private String fecha;
	private List<RowRepErrResumenCargaDTO> detalleErroresCarga;
	private List<RowRepErrAsocTitulosDTO> listadoerrasoctitulos;
	private List<TitulosCargaTransaccionesDTO> titulosdelaCarga;
	private List<TitulosCargaTransaccionesDTO> sinIdBroadView;
	private List<TitulosCargaTransaccionesDTO> idBroadViewNoExiste;
	private List<TitulosCargaTransaccionesDTO> tituloyFilialNoExiste;
	private List<TitulosCargaTransaccionesDTO> tituloFueradePeriodo;
	private List<String> listaPaises;
	private List<LinkedHashMap<String, String>> repvistaprevia;

	private InputStream fileInputStream;
	private String fileFileName;
	private JSONArray json = null;

	@Autowired
	private CargaTransaccionesBO cargaTransaccionesBO;

	@Override
	public String execute() throws Exception {

		return SUCCESS;
	}

	public String consultarCarga() {
		logger.info("mes : [{}]", mes);
		try {
			principalCargaTransacciones = cargaTransaccionesBO.obtenerPrincipalCargaTransacciones(mes);
			cargaTransacciones = cargaTransaccionesBO.obtenCargaTransacciones(mes);
		} catch (ResultMapException e) {
			error = e.getMessage();
		} catch (PersistenceException e) {
			error = e.getMessage();
		} catch (TransaccionException e) {
			error = e.getMessage();
		} catch (SQLException e) {
			error = e.getMessage();
		}
		return SUCCESS;
	}

	public String obtenerVistaPrevia() {
		try {

			String fileFileName = "vistaprevia";

			logger.info("fileName: " + fileFileName);

			listaPaises = cargaTransaccionesBO.obtenListaPaises();
			vistaPrevia = cargaTransaccionesBO.obtenerVistaPrevia(fileFileName, idCarga);
		} catch (ResultMapException e) {
			logger.error("error CargaTransaccionesAction: " + e);
		} catch (PersistenceException e) {
			logger.error("error CargaTransaccionesAction: " + e);
		} catch (TransaccionException e) {
			logger.error("error CargaTransaccionesAction: " + e);
		} catch (SQLException e) {
			logger.error("error CargaTransaccionesAction: " + e);
		} catch (IllegalArgumentException e) {
			logger.error("error CargaTransaccionesAction: " + e);
		} catch (IllegalAccessException e) {
			logger.error("error CargaTransaccionesAction: " + e);
		} catch (IOException e) {
			logger.error("error CargaTransaccionesAction: " + e);
		}
		return SUCCESS;
	}

	// nuevo reporte excel vista previa jul2017
	public String generaReporteVistaPreviaAction() {
		try {
			UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");

			java.util.Date date = new Date();

			SimpleDateFormat formatoMes = new SimpleDateFormat("MM");
			Long mes = Long.parseLong(formatoMes.format(date));

			SimpleDateFormat formatoAnio = new SimpleDateFormat("yyyy");
			Long annio = Long.parseLong(formatoAnio.format(date));

			String fileFileName = usuario.getExpediente() + "-" + mes + annio + "-reporteVistaPrevia";

			fileInputStream = cargaTransaccionesBO.dinamicIbatisRepVistaPrevia(fileFileName, idCarga);

		} catch (ResultMapException e) {
			logger.error("error generaReporteVistaPreviaAction: " + e);
		} catch (PersistenceException e) {
			logger.error("error generaReporteVistaPreviaAction: " + e);
		} catch (TransaccionException e) {
			logger.error("error generaReporteVistaPreviaAction: " + e);
		} catch (SQLException e) {
			logger.error("error generaReporteVistaPreviaAction: " + e);
		} catch (IllegalArgumentException e) {
			logger.error("error generaReporteVistaPreviaAction: " + e);
		} catch (IllegalAccessException e) {
			logger.error("error generaReporteVistaPreviaAction: " + e);
		} catch (IOException e) {
			logger.error("error generaReporteVistaPreviaAction: " + e);
		}
		return SUCCESS;
	}

	// rediseo vistaprevia jul2017
	public String reporteVistaPrevia() {
		try {
			listaPaises = cargaTransaccionesBO.obtenListaPaises();
			repvistaprevia = cargaTransaccionesBO.generaRepVistaPrevia(idCarga);
		} catch (ResultMapException e) {
			logger.error("error al obtener action reporteVistaPrevia: " + e);
		} catch (PersistenceException e) {
			logger.error("error al obtener action reporteVistaPrevia: " + e);
		} catch (TransaccionException e) {
			logger.error("error al obtener action reporteVistaPrevia: " + e);
		} catch (SQLException e) {
			logger.error("error al obtener action reporteVistaPrevia: " + e);
		} catch (IllegalArgumentException e) {
			logger.error("error al obtener action reporteVistaPrevia: " + e);
		} catch (IllegalAccessException e) {
			logger.error("error al obtener action reporteVistaPrevia: " + e);
		}
		return SUCCESS;
	}

	public String obtenerjsonVistaPrevia() {
		json = cargaTransaccionesBO.jsonVistaprevia(ruta);
		return SUCCESS;
	}

	// jun-17 rediseo: action para almacenar informacion que usara la descarga
	// excel detalle errores carga
	public String obtenerDetalleResumenCarga() {

		String nombre = "reporteDetalleErrorCargaTransacciones.xlsx";

		try {
			byte[] bytes = cargaTransaccionesBO.obtenerDetalleErroresCarga(mes);

			fileInputStream = new ByteArrayInputStream(bytes);
			fileFileName = nombre;

		} catch (ResultMapException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerDetalleResumenCargaAction: " + error + " - " + e);
		} catch (PersistenceException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerDetalleResumenCargaAction: " + error + " - " + e);
		} catch (TransaccionException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerDetalleResumenCargaAction: " + error + " - " + e);
		} catch (SQLException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerDetalleResumenCargaAction: " + error + " - " + e);
		}
		return SUCCESS;
	}

	// jun17 rediseo: action para almacenar informacion que usara la descarga excel
	// errores en asociacion de titulos
	public String obtenerListadoErrAsocTitulos() {

		String nombre = "reporteErroresAsociacionTitulos.xlsx";

		try {

			byte[] bytes = cargaTransaccionesBO.obtenerListaErrAsocTitulos(idCarga);
			fileInputStream = new ByteArrayInputStream(bytes);
			fileFileName = nombre;

		} catch (ResultMapException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerListadoErrAsocTitulos: " + error + " - " + e);
		} catch (PersistenceException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerListadoErrAsocTitulos: " + error + " - " + e);
		} catch (TransaccionException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerListadoErrAsocTitulos: " + error + " - " + e);
		} catch (SQLException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerListadoErrAsocTitulos: " + error + " - " + e);
		}
		return SUCCESS;
	}

	public String obtenerTitulosdelaCarga() {
		try {
			titulosdelaCarga = cargaTransaccionesBO.titulosdelaCarga(mes);
		} catch (ResultMapException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerTitulosdelaCarga: " + error + " - " + e);
		} catch (PersistenceException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerTitulosdelaCarga: " + error + " - " + e);
		} catch (TransaccionException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerTitulosdelaCarga: " + error + " - " + e);
		} catch (SQLException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerTitulosdelaCarga: " + error + " - " + e);
		}
		return SUCCESS;
	}

	public String obtenerResumenCarga() {
		logger.info("fecha_carga : [{}]", mes);
		try {
			resumencarga = cargaTransaccionesBO.obtenerResumenCarga(mes);
			return SUCCESS;
		} catch (ResultMapException e) {
			error = e.getMessage();
			logger.error("ObtenerResumenCarga_Exception: " + error);
			return ERROR;
		} catch (PersistenceException e) {
			error = e.getMessage();
			logger.error("ObtenerResumenCarga_Exception: " + error);
			return ERROR;
		} catch (TransaccionException e) {
			error = e.getMessage();
			logger.error("ObtenerResumenCarga_Exception: " + error);
			return ERROR;
		} catch (SQLException e) {
			error = e.getMessage();
			logger.error("ObtenerResumenCarga_Exception: " + error);
			return ERROR;
		}
	}

	public String obtenerResumenCargaIdTrans() {
		logger.info("idCarga : [{}]", idCarga);
		try {
			resumencarga = cargaTransaccionesBO.obtenerResumenCargaIdCargaTrans(idCarga);
			return SUCCESS;
		} catch (ResultMapException e) {
			error = e.getMessage();
			logger.error("Error_Action_obtenerResumenCargaIdTrans: " + error + e);
			return ERROR;
		} catch (PersistenceException e) {
			error = e.getMessage();
			logger.error("Error_Action_obtenerResumenCargaIdTrans: " + error + e);
			return ERROR;
		} catch (TransaccionException e) {
			error = e.getMessage();
			logger.error("Error_Action_obtenerResumenCargaIdTrans: " + error + e);
			return ERROR;
		} catch (SQLException e) {
			error = e.getMessage();
			logger.error("Error_Action_obtenerResumenCargaIdTrans: " + error + e);
			return ERROR;
		}
	}

	public String obtenerSinIdBroadView() {
		try {
			setSinIdBroadView(cargaTransaccionesBO.sinIdBroadView(idCarga));
		} catch (ResultMapException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerSinIdBroadView: " + error + " - " + e);
		} catch (PersistenceException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerSinIdBroadView: " + error + " - " + e);
		} catch (TransaccionException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerSinIdBroadView: " + error + " - " + e);
		} catch (SQLException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerSinIdBroadView: " + error + " - " + e);
		}
		return SUCCESS;
	}

	public String obtenerIdBroadViewNoExiste() {
		try {
			setIdBroadViewNoExiste(cargaTransaccionesBO.idBroadViewNoExiste(idCarga));
		} catch (ResultMapException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerIdBroadViewNoExiste: " + error + " - " + e);
		} catch (PersistenceException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerIdBroadViewNoExiste: " + error + " - " + e);
		} catch (TransaccionException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerIdBroadViewNoExiste: " + error + " - " + e);
		} catch (SQLException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerIdBroadViewNoExiste: " + error + " - " + e);
		}
		return SUCCESS;
	}

	public String obtenerTituloyFilialNoExiste() {
		try {
			setTituloyFilialNoExiste(cargaTransaccionesBO.tituloyFilialNoExiste(idCarga));
		} catch (ResultMapException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerTituloyFilialNoExiste: " + error + " - " + e);
		} catch (PersistenceException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerTituloyFilialNoExiste: " + error + " - " + e);
		} catch (TransaccionException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerTituloyFilialNoExiste: " + error + " - " + e);
		} catch (SQLException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerTituloyFilialNoExiste: " + error + " - " + e);
		}
		return SUCCESS;
	}

	public String obtenerTituloFueradePeriodo() {
		try {
			setTituloFueradePeriodo(cargaTransaccionesBO.tituloFueradePeriodo(idCarga));
		} catch (ResultMapException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerTituloFueradePeriodo: " + error + " - " + e);
		} catch (PersistenceException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerTituloFueradePeriodo: " + error + " - " + e);
		} catch (TransaccionException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerTituloFueradePeriodo: " + error + " - " + e);
		} catch (SQLException e) {
			error = e.getMessage();
			logger.error("ERROR. obj obtenerTituloFueradePeriodo: " + error + " - " + e);
		}
		return SUCCESS;
	}

	public String actualizarIdBv() {
		try {
			cargaTransaccionesBO.actualizarIdBv(IdBv, id_carga_titulo, nombreEstandar);
			logger.info("llego a action actualizar IdBv:  ");
		} catch (ResultMapException e) {
			error = e.getMessage();
			logger.error("ERROR. obj actualizarIdBv: " + error + " - " + e);
		} catch (PersistenceException e) {
			error = e.getMessage();
			logger.error("ERROR. obj actualizarIdBv: " + error + " - " + e);
		} catch (TransaccionException e) {
			error = e.getMessage();
			logger.error("ERROR. obj actualizarIdBv: " + error + " - " + e);
		} catch (SQLException e) {
			error = e.getMessage();
			logger.error("ERROR. obj actualizarIdBv: " + error + " - " + e);
		}
		return SUCCESS;
	}

	public String validaCarga() {
		try {
			cargaTransaccionesBO.validaCarga(idCarga);
			logger.info("llego a validar Carga:  ");
		} catch (ResultMapException e) {
			error = e.getMessage();
			logger.error("Error al intentar validar carga:  " + error);
		} catch (PersistenceException e) {
			error = e.getMessage();
			logger.error("Error al intentar validar carga:  " + error);
		} catch (TransaccionException e) {
			error = e.getMessage();
			logger.error("Error al intentar validar carga:  " + error);
		} catch (SQLException e) {
			error = e.getMessage();
			logger.error("Error al intentar validar carga:  " + error);
		}
		return SUCCESS;
	}

	// funcion para reCalculo de pago
	public String reCalculoPago() {
		ResponseAsociarTitTransCntVigentesDTO responseAsocTit = null;
		try {
			responseAsocTit = cargaTransaccionesBO.reCalculoPago(idCarga);
			logger.info("Response CalculoPago: [{}],", responseAsocTit);
		} catch (ResultMapException e) {
			error = e.getMessage();
			logger.error("Error al invocar cargaTransaccionesBO : " + error);
		} catch (PersistenceException e) {
			error = e.getMessage();
			logger.error("Error al invocar cargaTransaccionesBO : " + error);
		} catch (TransaccionException e) {
			error = e.getMessage();
			logger.error("Error al invocar cargaTransaccionesBO : " + error);
		} catch (SQLException e) {
			error = e.getMessage();
			logger.error("Error al invocar cargaTransaccionesBO : " + error);
		} catch (SocketTimeoutException e) {
			error = e.getMessage();
			logger.error("Error al invocar cargaTransaccionesBO : " + error);
		} catch (IOException e) {
			error = e.getMessage();
			logger.error("Error al invocar cargaTransaccionesBO : " + error);
		}
		return SUCCESS;
	}

	public String descargaPlantillaTransacciones() {
		try {
			fileInputStream = new ByteArrayInputStream(cargaTransaccionesBO.obtenPlantilla());
			setFileName("nombre");

		} catch (ResultMapException e) {
			logger.error("Error_Action_descargaPlantillaTransacciones: [{}],", e);
		} catch (PersistenceException e) {
			logger.error("Error_Action_descargaPlantillaTransacciones: [{}],", e);
		} catch (TransaccionException e) {
			logger.error("Error_Action_descargaPlantillaTransacciones: [{}],", e);
		} catch (SQLException e) {
			logger.error("Error_Action_descargaPlantillaTransacciones: [{}],", e);
		}
		return SUCCESS;
	}

	public List<LinkedHashMap<String, String>> getRepvistaprevia() {
		return repvistaprevia;
	}

	public void setRepvistaprevia(List<LinkedHashMap<String, String>> repvistaprevia) {
		this.repvistaprevia = repvistaprevia;
	}

	public String getFecha() {
		return fecha;
	}

	public void setFecha(String fecha) {
		this.fecha = fecha;
	}

	public JSONArray getJson() {
		return json;
	}

	public void setJson(JSONArray json) {
		this.json = json;
	}

	public String getMes() {
		return mes;
	}

	public void setMes(String mes) {
		this.mes = mes;
	}

	public String getError() {
		return error;
	}

	public void setError(String error) {
		this.error = error;
	}

	public List<TitulosCargaTransaccionesDTO> getTitulosdelaCarga() {
		return titulosdelaCarga;
	}

	public void setTitulosdelaCarga(List<TitulosCargaTransaccionesDTO> titulosdelaCarga) {
		this.titulosdelaCarga = titulosdelaCarga;
	}

	public List<CargaTransaccionesDTO> getCargaTransacciones() {
		return cargaTransacciones;
	}

	public void setCargaTransacciones(List<CargaTransaccionesDTO> cargaTransacciones) {
		this.cargaTransacciones = cargaTransacciones;
	}

	public PrincipalCargaTransaccionesDTO getPrincipalCargaTransacciones() {
		return principalCargaTransacciones;
	}

	public void setPrincipalCargaTransacciones(PrincipalCargaTransaccionesDTO principalCargaTransacciones) {
		this.principalCargaTransacciones = principalCargaTransacciones;
	}

	public Long getIdCarga() {
		return idCarga;
	}

	public void setIdCarga(Long idCarga) {
		this.idCarga = idCarga;
	}

	public ResponseGeneraReporteDTO getVistaPrevia() {
		return vistaPrevia;
	}

	public void setVistaPrevia(ResponseGeneraReporteDTO vistaPrevia) {
		this.vistaPrevia = vistaPrevia;
	}

	public List<RowRepErrResumenCargaDTO> getDetalleErroresCarga() {
		return detalleErroresCarga;
	}

	public void setDetalleErroresCarga(List<RowRepErrResumenCargaDTO> detalleErroresCarga) {
		this.detalleErroresCarga = detalleErroresCarga;
	}

	public List<String> getListaPaises() {
		return listaPaises;
	}

	public void setListaPaises(List<String> listaPaises) {
		this.listaPaises = listaPaises;
	}

	public List<TitulosCargaTransaccionesDTO> getSinIdBroadView() {
		return sinIdBroadView;
	}

	public void setSinIdBroadView(List<TitulosCargaTransaccionesDTO> sinIdBroadView) {
		this.sinIdBroadView = sinIdBroadView;
	}

	public List<TitulosCargaTransaccionesDTO> getIdBroadViewNoExiste() {
		return idBroadViewNoExiste;
	}

	public void setIdBroadViewNoExiste(List<TitulosCargaTransaccionesDTO> idBroadViewNoExiste) {
		this.idBroadViewNoExiste = idBroadViewNoExiste;
	}

	public List<TitulosCargaTransaccionesDTO> getTituloyFilialNoExiste() {
		return tituloyFilialNoExiste;
	}

	public void setTituloyFilialNoExiste(List<TitulosCargaTransaccionesDTO> tituloyFilialNoExiste) {
		this.tituloyFilialNoExiste = tituloyFilialNoExiste;
	}

	public List<TitulosCargaTransaccionesDTO> getTituloFueradePeriodo() {
		return tituloFueradePeriodo;
	}

	public void setTituloFueradePeriodo(List<TitulosCargaTransaccionesDTO> tituloFueradePeriodo) {
		this.tituloFueradePeriodo = tituloFueradePeriodo;
	}

	public String getIdBv() {
		return IdBv;
	}

	public void setIdBv(String idBv) {
		IdBv = idBv;
	}

	public String getRuta() {
		return ruta;
	}

	public void setRuta(String ruta) {
		this.ruta = ruta;
	}

	public Integer getId_carga_titulo() {
		return id_carga_titulo;
	}

	public void setId_carga_titulo(Integer id_carga_titulo) {
		this.id_carga_titulo = id_carga_titulo;
	}

	public void setNombreEstandar(String nombreEstandar) {
		this.nombreEstandar = nombreEstandar;
	}

	public String getNombreEstandar() {
		return nombreEstandar;
	}

	public PrincipalCargaTransaccionesDTO getResumencarga() {
		return resumencarga;
	}

	public void setResumencarga(PrincipalCargaTransaccionesDTO resumencarga) {
		this.resumencarga = resumencarga;
	}

	public String getFECHA_CARGA() {
		return FECHA_CARGA;
	}

	public void setFECHA_CARGA(String FECHA_CARGA) {
		this.FECHA_CARGA = FECHA_CARGA;
	}

	public List<RowRepErrAsocTitulosDTO> getListadoerrasoctitulos() {
		return listadoerrasoctitulos;
	}

	public void setListadoerrasoctitulos(List<RowRepErrAsocTitulosDTO> listadoerrasoctitulos) {
		this.listadoerrasoctitulos = listadoerrasoctitulos;
	}

	public void setFileInputStream(InputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}

	public void setFileFileName(String fileFileName) {
		this.fileFileName = fileFileName;
	}

	public String getFileFileName() {
		return fileFileName;
	}

	public InputStream getFileInputStream() {
		return fileInputStream;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

}
