package com.mx.dla.dda.contrato.bdeal.actions;

import java.sql.SQLException;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

public class BdealAction extends BaseContratoAction{

	private static final long serialVersionUID = 1L;
	
	@Autowired
	private GeneralesBO generalesBO;
	private Long idContrato;
	private Long estatus;
	
	public String execute() {
		ContratoDTO contrato = null;
		setIdContrato((Long)this.getSession().get("idContrato"));
		try {
			contrato = generalesBO.obtenContrato(idContrato);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		}
		setEstatus(contrato.getIdEstatus());
		
		return SUCCESS;
	}
	
	public void setIdContrato(Long idContrato) {
		this.idContrato = idContrato;
	}
	
	public Long getIdContrato() {
		return idContrato;
	}
	
	public void setEstatus(Long estatus) {
		this.estatus = estatus;
	}
	
	public Long getEstatus() {
		return estatus;
	}


}
