package com.mx.dla.dda.contrato.condicionesLicense.actions;

import java.text.ParseException;
import java.util.Arrays;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.common.constants.ContratoConstats;
import com.mx.dla.dda.contrato.condicionesLicense.bos.CondicionesLicenseBO;
import com.mx.dla.dda.contrato.condicionesLicense.constants.TipoAnio;
import com.mx.dla.dda.contrato.condicionesLicense.constants.TipoCondicion;
import com.mx.dla.dda.contrato.condicionesLicense.dtos.PlfRangoDTO;
import com.mx.dla.dda.contrato.condicionesLicense.dtos.PlicenseDTO;
import com.mx.dla.dda.contrato.condicionesLicense.exception.CondicionesLicenseException;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;

public class CondicionesLicenseAction extends BaseContratoAction {

	private static final long serialVersionUID = 7590885545520161328L;

	@Autowired
	private CondicionesLicenseBO condicionesLicenseBO;

	@Autowired
	private GeneralesBO generalesBO;

	private PlicenseDTO condiciones;

	@Override
	public String execute() throws Exception {

		Long idC = (Long) getSession().get(ContratoConstats.ID_CONTRATO_SESSION);
		setIdContrato(idC);
		ContratoDTO ct = generalesBO.obtenContrato(idC);
		getSession().put(ContratoConstats.CONTRATO_SESSION, ct);
		setEstatusContrato(ct.getIdEstatus());

		buscarCondiciones(ct);
		buscarJustificaciones();
		return super.execute();
	}

	public String save() {
		logger.debug("entro al save {} - {}", getCondiciones(), "");
		ContratoDTO ct = (ContratoDTO) getSession().get(ContratoConstats.CONTRATO_SESSION);
		try {
			condiciones.setIdContrato(ct.getIdContrato());
			condiciones.setFechaInicio(ct.getFechaFin());
			condiciones.setFechaFin(ct.getFechaFin());
			if (getEstatusContrato() != 1) {
				throw new CondicionesLicenseException("Estatus incorrecto");
			}
			condicionesLicenseBO.guardarCondiciones(getCondiciones());
			if (getJustificacion() != null && !"".equals(getJustificacion())) {
				guardarJustificacion();
				setJustificacion("");
			}
			addActionMessage("Los datos fueron guardados con éxito");
			buscarCondiciones(ct);
			buscarJustificaciones();
		} catch (CondicionesLicenseException e) {
			addActionError("Ocurrió un error al guardar los datos");
		} catch (ParseException e) {
			addActionError("Ocurrió un error al guardar los datos");
		}
		return SUCCESS;
	}

	public String buscarSuscriptores() throws ParseException {
		List<PlfRangoDTO> susc = condicionesLicenseBO.buscarSuscriptores(getIdContrato());
		condiciones = new PlicenseDTO();
		condiciones.setRango(susc);
		return SUCCESS;
	}

	private void buscarCondiciones(ContratoDTO ct) throws ParseException {
		if (condiciones == null) {
			condiciones = new PlicenseDTO();
		}
		condiciones.setIdContrato(ct.getIdContrato());
		condiciones.setFechaInicio(ct.getFechaInicio());
		condiciones.setFechaFin(ct.getFechaFin());
		condiciones = condicionesLicenseBO.buscarCondiciones(condiciones);
	}

	public PlicenseDTO getCondiciones() {
		return condiciones;
	}

	public void setCondiciones(PlicenseDTO condiciones) {
		this.condiciones = condiciones;
	}

	public List<TipoAnio> getTiposAnio() {
		return Arrays.asList(TipoAnio.values());
	}

	public List<CatalogoDTO> getTiposPeriodoPago() {
		return condicionesLicenseBO.buscarPeriodos();
	}

	public List<TipoCondicion> getTiposCondicion() {
		return Arrays.asList(TipoCondicion.values());
	}
}
