package com.mx.dla.dda.contrato.condicionesTransaccion.actions;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.apache.log4j.Logger;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.condicionesTransaccion.bos.CondicionesTransaccionBO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.CategoriaMgDTO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.ContratoCategoriasDTO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.ContratoPtAnnioDTO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.ContratoPtCmgDTO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.ContratoPtransDTO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.ContratoPtrsPrecioDTO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.ContratoPtrsRdDTO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.DataInicialTransaccionDTO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.ReleaseDateDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.opensymphony.xwork2.Action;

public class CatalogosTransaccionAction extends BaseContratoAction
		implements ServletRequestAware, ServletResponseAware {

	private static final long serialVersionUID = 1L;
	private Logger log = Logger.getLogger(this.getClass());
	private DataInicialTransaccionDTO catalogos = new DataInicialTransaccionDTO();
	private HttpServletRequest request;
	private HttpServletResponse response;

	@Autowired
	private CondicionesTransaccionBO transaccionBO;

	public String execute() {
		ObjectMapper mapper = new ObjectMapper();

		try {

			List<List<ContratoPtAnnioDTO>> ptrsAnnio = new ArrayList<List<ContratoPtAnnioDTO>>();
			List<List<ContratoPtCmgDTO>> ptrsCmg = new ArrayList<List<ContratoPtCmgDTO>>();
			List<List<ContratoCategoriasDTO>> ptrsCategorias = new ArrayList<List<ContratoCategoriasDTO>>();
			List<List<ContratoPtrsRdDTO>> ptrsRd = new ArrayList<List<ContratoPtrsRdDTO>>();
			List<List<ContratoPtrsPrecioDTO>> ptrsPrecio = new ArrayList<List<ContratoPtrsPrecioDTO>>();

			List<CategoriaMgDTO> categoriaMgLista = transaccionBO.obtenerCategoriaMG();
			List<ReleaseDateDTO> releaseDateLista = transaccionBO.obtenerReleaseDate();

			log.info("CONTRATO " + getIdContrato());
			log.info("CONTRATO INT " + getIdContrato().intValue());
			List<ContratoPtransDTO> ptrsLista = transaccionBO.verificaTransaccion(getIdContrato());
			catalogos.setPtrsLista(ptrsLista);
			if (!ptrsLista.isEmpty()) {
				for (int kPtrs = 0; kPtrs < ptrsLista.size(); kPtrs++) {
					ptrsAnnio.add(transaccionBO
							.cargaContratoPagoAnnio(Long.parseLong(ptrsLista.get(kPtrs).getIdContratoPtrans() + "")));
					ptrsCmg.add(transaccionBO
							.cargaContratoPagoCmg(Long.parseLong(ptrsLista.get(kPtrs).getIdContratoPtrans() + "")));
					ptrsCategorias.add(transaccionBO.cargaContratoPagoCategorias(
							Long.parseLong(ptrsLista.get(kPtrs).getIdContratoPtrans() + "")));
					ptrsRd.add(transaccionBO
							.cargaContratoPagoRD(Long.parseLong(ptrsLista.get(kPtrs).getIdContratoPtrans() + "")));
					ptrsPrecio.add(transaccionBO
							.cargaContratoPagoPrecio(Long.parseLong(ptrsLista.get(kPtrs).getIdContratoPtrans() + "")));

					catalogos.setPtrsAnnio(ptrsAnnio);
					catalogos.setPtrsCmg(ptrsCmg);
					catalogos.setPtrsCategorias(ptrsCategorias);
					catalogos.setPtrsRd(ptrsRd);
					catalogos.setPtrsPrecio(ptrsPrecio);
				}

			}

			catalogos.setCategoriaMGLista(categoriaMgLista);
			catalogos.setReleaseDateLista(releaseDateLista);

			mapper.writeValueAsString(ptrsAnnio);
			mapper.writeValueAsString(ptrsCmg);
			mapper.writeValueAsString(ptrsCategorias);
			mapper.writeValueAsString(ptrsRd);
			mapper.writeValueAsString(ptrsPrecio);
			mapper.writeValueAsString(ptrsLista);

			mapper.writeValueAsString(categoriaMgLista);
			mapper.writeValueAsString(releaseDateLista);

		} catch (JsonParseException e) {
			log.error("Error CatalogosListadoAction.", e);
		} catch (JsonGenerationException e) {
			log.error("Error CatalogosListadoAction.", e);
		} catch (JsonMappingException e) {
			log.error("Error CatalogosListadoAction.", e);
		} catch (IOException e) {
			log.error("Error CatalogosListadoAction.", e);
		} catch (ResultMapException e) {
			log.error("Error CatalogosListadoAction.", e);
		} catch (PersistenceException e) {
			log.error("Error CatalogosListadoAction.", e);
		} catch (TransaccionException e) {
			log.error("Error CatalogosListadoAction.", e);
		} catch (SQLException e) {
			log.error("Error CatalogosListadoAction.", e);
		}
		return Action.SUCCESS;

	}

	public DataInicialTransaccionDTO getCatalogos() {
		return catalogos;
	}

	public void setCatalogos(DataInicialTransaccionDTO catalogos) {
		this.catalogos = catalogos;
	}

	public CondicionesTransaccionBO getTransaccionBO() {
		return transaccionBO;
	}

	public void setTransaccionBO(CondicionesTransaccionBO transaccionBO) {
		this.transaccionBO = transaccionBO;
	}

	public HttpServletRequest getRequest() {
		return request;
	}

	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}

	public HttpServletResponse getResponse() {
		return response;
	}

	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}

	@Override
	public void setServletResponse(HttpServletResponse arg0) {
		// TODO Auto-generated method stub

	}

}
