package com.mx.dla.dda.contrato.condicionesTransaccion.actions;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.apache.log4j.Logger;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.condicionesTransaccion.bos.CondicionesTransaccionBO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.CondicionesTransaccionDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

public class GuardarTransaccionAction extends BaseContratoAction implements ServletRequestAware, ServletResponseAware {

	private static final long serialVersionUID = 1L;
	private Logger log = Logger.getLogger(this.getClass());

	private String data;

	ObjectMapper mapper = new ObjectMapper();

	@Autowired
	private CondicionesTransaccionBO transaccionBO;
	private CondicionesTransaccionDTO transaccionDTO = new CondicionesTransaccionDTO();

	private HttpServletRequest request;

	@Override
	public String execute() throws Exception {
		try {
			transaccionDTO = mapper.readValue(data, CondicionesTransaccionDTO.class);
			transaccionBO.guardar(transaccionDTO);
			setJustificacion(transaccionDTO.getJustificacion());
			setIdContrato(transaccionDTO.getIdContrato());
			if (getJustificacion() != null && !"".equals(getJustificacion())) {
				guardarJustificacion();
				setJustificacion("");
			}
		} catch (ResultMapException e) {
			log.error("ERROR:", e);
			log.error("Causa: " + e.getCause());
		} catch (PersistenceException e) {
			log.error("ERROR:", e);
			log.error("Causa: " + e.getCause());
		} catch (TransaccionException e) {
			log.error("ERROR:", e);
			log.error("Causa: " + e.getCause());
		} catch (SQLException e) {
			log.error("ERROR:", e);
			log.error("Causa: " + e.getCause());
		}
		return SUCCESS;

	}

	@Override
	public void setServletResponse(HttpServletResponse arg0) {
		// TODO Auto-generated method stub

	}

	public String getData() {
		return data;
	}

	public void setData(String data) {
		this.data = data;
	}

	public CondicionesTransaccionBO getTransaccionBO() {
		return transaccionBO;
	}

	public void setTransaccionBO(CondicionesTransaccionBO transaccionBO) {
		this.transaccionBO = transaccionBO;
	}

	public HttpServletRequest getRequest() {
		return request;
	}

	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}

}
