package com.mx.dla.dda.contrato.facturas.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.facturas.bos.FacturasBO;
import com.mx.dla.dda.contrato.facturas.dtos.FacturaViewDTO;

public class FacturasAction extends BaseContratoAction {

	@Autowired
	private FacturasBO facturasBO;
	
	private List<FacturaViewDTO> facturas;
	private Double costoTotal;
	
	private static final long serialVersionUID = 3027003012196187865L;

	@Override
	public String execute() throws Exception {
		
		this.setIdContrato((Long)this.getSession().get("idContrato"));
		
		setFacturas(facturasBO.buscarFacturas(getIdContrato()));
		return SUCCESS;
	}



	public List<FacturaViewDTO> getFacturas() {
		return facturas;
	}



	public void setFacturas(List<FacturaViewDTO> facturas) {
		this.facturas = facturas;
	}



	public Double getCostoTotal() {
		return costoTotal;
	}

	public void setCostoTotal(Double costoTotal) {
		this.costoTotal = costoTotal;
	}
	
	
}
