package com.mx.dla.dda.contrato.generales.actions;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.PoblarGeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.ApartadoDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

@Controller
@Scope("request")
public class ExponerApartadosAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private Long idEstudio;
	private Long idApartado;
	private List<ApartadoDTO> apartados;
	
	@Autowired
	private PoblarGeneralesBO poblarGeneralesBO;

	public String execute() {
		try {
			setApartados(poblarGeneralesBO.obtenerApartados(idEstudio, idApartado));
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		}
		return SUCCESS;
	}

	public void setIdEstudio(Long idEstudio) {
		this.idEstudio = idEstudio;
	}

	public Long getIdEstudio() {
		return idEstudio;
	}

	public void setApartados(List<ApartadoDTO> apartados) {
		this.apartados = apartados;
	}

	public List<ApartadoDTO> getApartados() {
		return apartados;
	}
	
	public void setIdApartado(Long idApartado) {
		this.idApartado = idApartado;
	}
	
	public Long getIdApartado() {
		return idApartado;
	}

}
