package com.mx.dla.dda.contrato.generales.actions;

import java.io.InputStream;
import java.sql.SQLException;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

@Controller
public class InfoContratoAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;
	private InputStream fileInputStream;
	private String fileName;
	
	@Autowired
	private GeneralesBO generalesBO;

	public String execute() {
		Long idContrato = (Long)this.getSession().get("idContrato");
		try {
			fileInputStream = generalesBO.h(idContrato);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		}
		fileName = "detalle_contrato_" + idContrato;
		return SUCCESS;
	}

	public InputStream getFileInputStream() {
		return fileInputStream;
	}

	public void setFileInputStream(InputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	

}
