package com.mx.dla.dda.contrato.materiales.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.materiales.bos.MaterialesBO;
import com.mx.dla.dda.contrato.materiales.dtos.MaterialDTO;

public class MaterialesAction extends BaseContratoAction {

	@Autowired
	private MaterialesBO materialesBO;
	
	private List<MaterialDTO> materiales;
	private Double costoTotal;
	
	private static final long serialVersionUID = 3027003012196187865L;

	@Override
	public String execute() throws Exception {
		
		this.setIdContrato((Long)this.getSession().get("idContrato"));
		
		logger.info("MaterialesAction idContrato {}",getIdContrato());
		
		setMateriales(materialesBO.buscarMateriales(getIdContrato()));
		setCostoTotal(materialesBO.buscarCostoTotal(getIdContrato()));
		return SUCCESS;
	}

	public List<MaterialDTO> getMateriales() {
		return materiales;
	}
	
	public void setMateriales(List<MaterialDTO> materiales) {
		this.materiales = materiales;
	}

	public Double getCostoTotal() {
		return costoTotal;
	}

	public void setCostoTotal(Double costoTotal) {
		this.costoTotal = costoTotal;
	}
	
	
}
