package com.mx.dla.dda.contrato.minimoseleccion.actions;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.bos.MinimoSeleccionBO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.AnnioDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoMinimoSeleccionDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoPagoCategoriaDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoPagoCostoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoPagoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoPagoFlatDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.MontoRealDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

public class MinSeleccionAction extends BaseContratoAction {

	private static final long serialVersionUID = 21363082260499407L;

	private List<ContratoPagoDTO> periodos;

	private List<ContratoPagoCategoriaDTO> categorias;

	private List<AnnioDTO> annios;

	private List<AnnioDTO> anniosPeriodo;

	private List<ContratoPagoFlatDTO> costosFlat;

	private List<ContratoPagoCostoDTO> costosSuscriptores;

	private List<ContratoMinimoSeleccionDTO> minimosSeleccion;
	
	private List<MontoRealDTO> montosReales;
	
	private Integer guardadoStatus;
	
	private String mensajeExcepcion;

	@Autowired
	private MinimoSeleccionBO minimoSeleccionBO;
	
	@Autowired
	private GeneralesBO generalesBO;
	
	public String primeraCarga(){
		
		Long idContrato = (Long) this.getSession().get("idContrato");
		ContratoDTO ct = null;
		try {
			ct = generalesBO.obtenContrato(idContrato);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		}			
		setEstatusContrato(ct.getIdEstatus());
		buscarJustificaciones();
		return SUCCESS;

	}

	public String obtenInformacion() {


		try {
					
			Long idContrato = (Long) this.getSession().get("idContrato");

			ContratoDTO ct = generalesBO.obtenContrato(idContrato);			
			setEstatusContrato(ct.getIdEstatus());
			
			periodos = minimoSeleccionBO.consultaInformacionPeriodos(idContrato);
			categorias = minimoSeleccionBO.consultaInformacionCategorias(idContrato);
			annios = minimoSeleccionBO.consultaInformacionAnnios(idContrato);
			costosFlat = minimoSeleccionBO.consultaInformacionCostoFlat(idContrato);
			costosSuscriptores = minimoSeleccionBO.consultaInformacionCostoSubscriptores(idContrato);
			minimosSeleccion = minimoSeleccionBO.consultaInformacionMinimos(idContrato);
			anniosPeriodo = minimoSeleccionBO.consultaInformacionAnniosPorPeriodo(idContrato);
			montosReales = minimoSeleccionBO.consultaInformacionMontosReales(idContrato); 
			guardadoStatus = 0;

		} catch (ResultMapException e) {
			logger.debug("Exception : [{}]", e);
			setMensajeExcepcion("Fallo la carga de informacin.");
		} catch (TransaccionException e) {
			logger.debug("Exception : [{}]", e);
			setMensajeExcepcion("Fallo la carga de informacin.");
		} catch (SQLException e) {
			logger.debug("Exception : [{}]", e);
			setMensajeExcepcion("Fallo la carga de informacin.");
		}

		return SUCCESS;
	}

	public String guardaInformacion() {

		logger.info("minimosSeleccion: " + minimosSeleccion);

		try {
			
			Long idContrato = (Long) this.getSession().get("idContrato");

			ContratoDTO ct = generalesBO.obtenContrato(idContrato);			
			setEstatusContrato(ct.getIdEstatus());

			for (ContratoMinimoSeleccionDTO item : minimosSeleccion)
				minimoSeleccionBO.actualizaMinimoMonto(
						item.getIdContratoPago(), item.getIdPagoCategoria(),
						item.getAnnio(), item.getMinimoSeleccion());
			
			if (getJustificacion() != null && !"".equals(getJustificacion())) {
				guardarJustificacion();
				setJustificacion("");
			}

			buscarJustificaciones();

			guardadoStatus = 1;

		} catch (ResultMapException e) {
			logger.debug("Exception : [{}]", e);
			setMensajeExcepcion("Fallo al guardar informacin.");
			guardadoStatus = -1;	
		} catch (TransaccionException e) {
			logger.debug("Exception : [{}]", e);
			setMensajeExcepcion("Fallo al guardar informacin.");
			guardadoStatus = -1;	
		} catch (SQLException e) {
			logger.debug("Exception : [{}]", e);
			setMensajeExcepcion("Fallo al guardar informacin.");
			guardadoStatus = -1;	
		}

		return SUCCESS;

	}

	public List<ContratoPagoDTO> getPeriodos() {
		return periodos;
	}

	public void setPeriodos(List<ContratoPagoDTO> periodos) {
		this.periodos = periodos;
	}

	public List<ContratoPagoCategoriaDTO> getCategorias() {
		return categorias;
	}

	public void setCategorias(List<ContratoPagoCategoriaDTO> categorias) {
		this.categorias = categorias;
	}

	public List<AnnioDTO> getAnnios() {
		return annios;
	}

	public void setAnnios(List<AnnioDTO> annios) {
		this.annios = annios;
	}

	public List<ContratoPagoFlatDTO> getCostosFlat() {
		return costosFlat;
	}

	public void setCostosFlat(List<ContratoPagoFlatDTO> costosFlat) {
		this.costosFlat = costosFlat;
	}

	public List<ContratoPagoCostoDTO> getCostosSuscriptores() {
		return costosSuscriptores;
	}

	public void setCostosSuscriptores(
			List<ContratoPagoCostoDTO> costosSuscriptores) {
		this.costosSuscriptores = costosSuscriptores;
	}

	public List<ContratoMinimoSeleccionDTO> getMinimosSeleccion() {
		return minimosSeleccion;
	}

	public void setMinimosSeleccion(
			List<ContratoMinimoSeleccionDTO> minimosSeleccion) {
		this.minimosSeleccion = minimosSeleccion;
	}

	public List<AnnioDTO> getAnniosPeriodo() {
		return anniosPeriodo;
	}

	public void setAnniosPeriodo(List<AnnioDTO> anniosPeriodo) {
		this.anniosPeriodo = anniosPeriodo;
	}

	public Integer getGuardadoStatus() {
		return guardadoStatus;
	}

	public void setGuardadoStatus(Integer guardadoStatus) {
		this.guardadoStatus = guardadoStatus;
	}
	
	public void setMontosReales(List<MontoRealDTO> montosReales) {
		this.montosReales = montosReales;
	}
	
	public List<MontoRealDTO> getMontosReales() {
		return montosReales;
	}
	
	public void setMensajeExcepcion(String mensajeExcepcion) {
		this.mensajeExcepcion = mensajeExcepcion;
	}
	
	public String getMensajeExcepcion() {
		return mensajeExcepcion;
	}

}
