package com.mx.dla.dda.contrato.minimoseleccion.actions;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.common.bos.JustificacionBO;
import com.mx.dla.dda.contrato.common.dtos.JustificacionDTO;
import com.mx.dla.dda.contrato.minimoseleccion.bos.MinimoSeleccionBO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.AnnioDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.PeriodoDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

@Controller
@Scope("request")
public class MinimoSeleccionAction extends BaseContratoAction {

	private static final long serialVersionUID = 6371845499197432247L;

	private Long idContrato;
	private Long estatus;

	private List<JustificacionDTO> justificaciones;

	@Autowired
	private MinimoSeleccionBO minimoSeleccionBO;

	@Autowired
	private JustificacionBO justificacionBO;

	private String tipoPago;

	private List<AnnioDTO> annios;

	private List<PeriodoDTO> periodos;

	@Override
	public String execute() {
		// el idContrato vendra de la sesion, por el momento llega del request

		if (getSession().get("idContrato") == null) {
			logger.info("No viene idContrato en session");
			getSession().put("idContrato", getIdContrato());
		} else {
			logger.info("Viene idContrato en Session");
			setIdContrato((Long) getSession().get("idContrato"));
		}

		try {
			setTipoPago(minimoSeleccionBO.obtenTipoPago(getIdContrato()));

			logger.info(" idContrato : " + getIdContrato() + " tipoPago : " + getTipoPago());

			if (getTipoPago() != null && !getTipoPago().equals("")) {

				if (getTipoPago().equals("FLAT")) {
					setAnnios(minimoSeleccionBO.obtenAnnioContrato(getIdContrato()));
				} else {
					setPeriodos(minimoSeleccionBO.obtnePeriodoContrato(getIdContrato()));
				}

			}

			setJustificaciones(justificacionBO.buscarJustificaciones(getIdContrato()));
			setEstatus(minimoSeleccionBO.obtenerEstatusContrato(getIdContrato()));
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		}
		return SUCCESS;
	}

	public void setIdContrato(Long idContrato) {
		this.idContrato = idContrato;
	}

	public Long getIdContrato() {
		return idContrato;
	}

	public List<JustificacionDTO> getJustificaciones() {
		return justificaciones;
	}

	public void setJustificaciones(List<JustificacionDTO> justificaciones) {
		this.justificaciones = justificaciones;
	}

	public Long getEstatus() {
		return estatus;
	}

	public void setEstatus(Long estatus) {
		this.estatus = estatus;
	}

	public void setTipoPago(String tipoPago) {
		this.tipoPago = tipoPago;
	}

	public String getTipoPago() {
		return tipoPago;
	}

	public void setAnnios(List<AnnioDTO> annios) {
		this.annios = annios;
	}

	public List<AnnioDTO> getAnnios() {
		return annios;
	}

	public void setPeriodos(List<PeriodoDTO> periodos) {
		this.periodos = periodos;
	}

	public List<PeriodoDTO> getPeriodos() {
		return periodos;
	}

}
