package com.mx.dla.dda.contrato.minimoseleccion.actions;

import java.sql.SQLException;
import java.util.Map;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.common.bos.JustificacionBO;
import com.mx.dla.dda.contrato.minimoseleccion.bos.MinimoSeleccionBO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

@Controller
@Scope("request")
public class ModificaCategoriasAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private Map<Long, String> categoriasMod;
	private String minimoMonto;
	private Long idContratoPago;
	private String mensajeRespuesta;
	private Integer annio;
	private String tipoPago;
	private String justificacion;
	private Long idContrato;

	@Autowired
	MinimoSeleccionBO minimoSeleccionBO;

	@Autowired
	private JustificacionBO justificacionBO;

	public String execute() {

		try {
			if (minimoSeleccionBO.actualizaCategoriasMonto(idContratoPago, minimoMonto, categoriasMod, annio,
					tipoPago)) {

				if (justificacion != null && !justificacion.equals("")) {
					UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");
					justificacionBO.insertarJustificacion(justificacion, idContrato, usuario);
				}

				setMensajeRespuesta("Se guardaron los cambios exitosamente");
			} else {
				setMensajeRespuesta("Ocurrio un error al guardar los cambios");
			}
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		}

		return SUCCESS;
	}

	public Map<Long, String> getCategoriasMod() {
		return categoriasMod;
	}

	public void setCategoriasMod(Map<Long, String> categoriasMod) {
		this.categoriasMod = categoriasMod;
	}

	public void setMinimoMonto(String minimoMonto) {
		this.minimoMonto = minimoMonto;
	}

	public String getMinimoMonto() {
		return minimoMonto;
	}

	public void setIdContratoPago(Long idContratoPago) {
		this.idContratoPago = idContratoPago;
	}

	public Long getIdContratoPago() {
		return idContratoPago;
	}

	public void setMensajeRespuesta(String mensajeRespuesta) {
		this.mensajeRespuesta = mensajeRespuesta;
	}

	public String getMensajeRespuesta() {
		return mensajeRespuesta;
	}

	public void setAnnio(Integer annio) {
		this.annio = annio;
	}

	public Integer getAnnio() {
		return annio;
	}

	public void setTipoPago(String tipoPago) {
		this.tipoPago = tipoPago;
	}

	public String getTipoPago() {
		return tipoPago;
	}

	public void setJustificacion(String justificacion) {
		this.justificacion = justificacion;
	}

	public String getJustificacion() {
		return justificacion;
	}

	public void setIdContrato(Long idContrato) {
		this.idContrato = idContrato;
	}

	public Long getIdContrato() {
		return idContrato;
	}

}
