package com.mx.dla.dda.contrato.notasDeCredito.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.notasDeCredito.bos.NotasDeCreditoBO;
import com.mx.dla.dda.contrato.notasDeCredito.dtos.NotaDeCreditoDbDTO;

public class NotasDeCreditoAction extends BaseContratoAction {

	@Autowired
	private NotasDeCreditoBO notasDeCreditoBO;
	
	private List<NotaDeCreditoDbDTO> notasDeCredito;
	private Double costoTotal;
	
	private static final long serialVersionUID = 3027003012196187865L;

	@Override
	public String execute() throws Exception {
		logger.debug("entro al init materiales");
		
		this.setIdContrato((Long)this.getSession().get("idContrato"));
		
		logger.info("entro al init materiales contrato {}",getIdContrato());
		
		setNotasDeCredito(notasDeCreditoBO.regresaNotasDeCredito(getIdContrato()));
		return SUCCESS;
	}

	public Double getCostoTotal() {
		return costoTotal;
	}

	public void setCostoTotal(Double costoTotal) {
		this.costoTotal = costoTotal;
	}

	public List<NotaDeCreditoDbDTO> getNotasDeCredito() {
		return notasDeCredito;
	}

	public void setNotasDeCredito(List<NotaDeCreditoDbDTO> notasDeCredito) {
		this.notasDeCredito = notasDeCredito;
	}
}
