package com.mx.dla.dda.contrato.titulo.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.listado.dtos.ContentType;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.reporte.amortizacion.baseActivos.bos.BaseActivosBO;
import com.mx.dla.dda.reporte.ws.dtos.ResponseGeneraReporteDTO;

public class DescargaMasivaTitulosAction extends BaseContratoAction {
	private static final long serialVersionUID = 1L;

	private ResponseGeneraReporteDTO respuesta;

	private String mensajeExcepcion;
	private String fecha;
	private String fechaFin;
	private String rutaArchivo;
	private String contentType;
	private boolean vigente = Boolean.FALSE;

	@Autowired
	private BaseActivosBO baseActivosBO;

	public String execute() throws Exception {
		return SUCCESS;
	}

	public String generarReporte() {
		try {
			DateFormat formatoEntrada = new SimpleDateFormat("dd/MM/yyyy");
			Date date = formatoEntrada.parse(fecha);
			Date dateFin = formatoEntrada.parse(fechaFin);

			SimpleDateFormat formatoAnio = new SimpleDateFormat("dd/MM/yyyy");
			String anio = formatoAnio.format(date);
			String anioFin = formatoAnio.format(dateFin);

			UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");
			String fileFileName = "dmt_" + usuario.getExpediente() + "" + anio.replace('/', '_');

			respuesta = baseActivosBO.generaReporteBaseActivos(fileFileName, anio, anioFin, vigente);
		} catch (IOException e) {
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		} catch (ParseException e) {
			logger.error("Error. {}", e);
		}

		return SUCCESS;

	}

	public String descargarArchivo() {

		byte[] result = null;

		logger.info("ruta archivo: " + rutaArchivo);

		try {
			String[] layRuta = rutaArchivo.split("\\/");
			Long lnuTotalRuta = (long) layRuta.length;
			String nombre = layRuta[(int) (lnuTotalRuta - 1)];
			File file = new File(rutaArchivo);

			logger.info("nombre archivo: " + nombre);
			logger.info("descar: " + rutaArchivo);

			result = IOUtils.toByteArray(new FileInputStream(file));
			contentType = ContentType.getType(FilenameUtils.getExtension(rutaArchivo));

			HttpServletResponse response = ServletActionContext.getResponse();
			response.setContentLength(result.length);
			response.setContentType(this.contentType);
			response.setHeader("Content-Disposition", "attachment; filename=" + nombre);

			logger.info("response [{}] :" + response);

			ServletOutputStream out;

			out = response.getOutputStream();
			out.write(result);
			out.flush();
		} catch (IOException e) {
			logger.error("Error. {}", e);
		}

		return null;
	}

	public ResponseGeneraReporteDTO getRespuesta() {
		return respuesta;
	}

	public void setRespuesta(ResponseGeneraReporteDTO respuesta) {
		this.respuesta = respuesta;
	}

	public String getMensajeExcepcion() {
		return mensajeExcepcion;
	}

	public void setMensajeExcepcion(String mensajeExcepcion) {
		this.mensajeExcepcion = mensajeExcepcion;
	}

	public String getRutaArchivo() {
		return rutaArchivo;
	}

	public void setRutaArchivo(String rutaArchivo) {
		this.rutaArchivo = rutaArchivo;
	}

	public String getFecha() {
		return fecha;
	}

	public void setFecha(String fecha) {
		this.fecha = fecha;
	}

	public String getFechaFin() {
		return fechaFin;
	}

	public void setFechaFin(String fechaFin) {
		this.fechaFin = fechaFin;
	}

	public boolean getVigente() {
		return vigente;
	}

	public void setVigente(boolean checkMe) {
		this.vigente = checkMe;
	}

}
