package com.mx.dla.dda.reporte.movimientos.actions;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.PoblarGeneralesBO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.reporte.movimientos.bos.ReporteMovimientosBO;
import com.mx.dla.dda.reporte.movimientos.dtos.ReporteMovimietosDTO;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class ReporteMovimientosAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private List<EstudioDTO> estudios;
	private String contrato;
	private String estudio;
	private String mes;
	private List<ReporteMovimietosDTO> reporte;

	@Autowired
	private PoblarGeneralesBO poblarGeneralesBO;

	@Autowired
	private ReporteMovimientosBO reporteMovimientos;

	public String execute() {
		try {
			setEstudios(poblarGeneralesBO.obtenListaEstudios());
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
		}
		return SUCCESS;
	}

	public String generaReporte() {
		if (mes.isEmpty()){
			mes = null;
		} else{
			mes = mes.substring(0,3) + mes.substring(6);
		}
		if(contrato.isEmpty()){
			contrato = null;
		}
		setReporte(reporteMovimientos.obtenerDatosReporte(contrato, estudio, mes));
		return SUCCESS;
	}

}
