package com.mx.dla.dda.reporte.pagosTransaccion.actions;

import java.util.Arrays;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.titulos.constants.TipoTitulo;
import com.mx.dla.dda.reporte.pagosTransaccion.bos.PagoTransaccionBO;
import com.mx.dla.dda.reporte.pagosTransaccion.dtos.PagoTransaccion;
import com.mx.dla.dda.reporte.pagosTransaccion.dtos.PagoTransaccionFiltros;
import com.mx.dla.global.actions.BaseAction;

public class PagoTransaccionAction extends BaseAction{
	
	private static final long serialVersionUID = 127647227585669066L;
	private List<PagoTransaccion> pagos;
	private PagoTransaccionFiltros filtros;
	private Boolean pendientesPorNotificar;
	private String error;
	
	@Autowired
	private PagoTransaccionBO pagoTransaccionBO;
	
	@Override
	public String execute() throws Exception {
		return super.execute();
	}
	
	public String buscaPagos()
	{
		logger.info("filtros [{}]",filtros);
		pagos =  pagoTransaccionBO.buscarPagos(filtros);
		pendientesPorNotificar = pagoTransaccionBO.tieneTransaccionesSAPPendientes(filtros);
		return SUCCESS;
	}
	
	public String notificarTransaccionSAP()
	{
		logger.info("filtros [{}]",filtros);
		pagos =  pagoTransaccionBO.buscarPagos(filtros);
		return SUCCESS;
	}

	public List<PagoTransaccion> getPagos() {
		return pagos;
	}
	
	public void setPagos(List<PagoTransaccion> pagos) {
		this.pagos = pagos;
	}
	
	public PagoTransaccionFiltros getFiltros() {
		return filtros;
	}
	public void setFiltros(PagoTransaccionFiltros filtros) {
		this.filtros = filtros;
	}
	
	public List<CatalogoDTO> getEstudios()
	{
		return pagoTransaccionBO.buscarEstudios();
	}
	
	public List<TipoTitulo> getTipoTitulos() {
		return Arrays.asList(TipoTitulo.values());
	}
	public String getError() {
		return error;
	}
	public void setError(String error) {
		this.error = error;
	}
	
	public void setPendientesPorNotificar(Boolean pendientesPorNotificar) {
		this.pendientesPorNotificar = pendientesPorNotificar;
	}
	
	public Boolean getPendientesPorNotificar() {
		return pendientesPorNotificar;
	}
}
