var precioService  = function($filter, $http, $q, tablaService, terminosValidateService) {

	return {

		
		crearTablaPrecios: function(data, encabezados, objeto){
	    	var tabla = {encabezados:[], metadatos:null, columnasEliminar: null, datos:null, mensajes : null, subEncabezadosPrecio:null, valida:true, nombre: "Precios"};
	    		    		    	
	    	for(var i=0; i<encabezados.length; i++)
	    		tabla.encabezados.push(encabezados[i]);
	    		    	
	    	tabla.datos = [];
	    	
	    	if(data != null)
	    	{
	    		for(var i=0; i < data.length;i++)
			    {
			   	   var fila = [];
			       for(var j=0; j < data[0].length;j++)
				   {		    		    		
			    	   if(data[i][j] == null)
			    		 fila.push({"valor" : null, "desc":null});
			    	   else if(j>1)
			    		 fila.push({"valor" : $filter('numDigMoneda')(data[i][j], 4), "desc":null});
			    	   else
			    		 fila.push({"valor" : data[i][j], "desc":data[i][j]});
			    		  
				   }	
			       tabla.datos.push(fila);
			    }	
	    	}		   	
		   	
		   	tabla.subEncabezadosPrecio  = [];
		   	for(var j=0; j < encabezados.length;j++)
		   	{
		   		tabla.subEncabezadosPrecio.push("ML");
		   		tabla.subEncabezadosPrecio.push("Dolares");
		   	}			   		    		    		
		       		    				   		   	
	        return tabla;
	    },
		
	    editarTablaPrecios: function(operacion, index, categoria, formatos, tablaPrecios) {		
	    	var tablaN;
			var data = tablaPrecios.datos;

			switch (operacion) {
			case 'removeRow':
				var dataT = {
					datos : [],
					encabezados : null,
					columnasEliminar : null
				}

				data.splice( index * formatos.length, formatos.length);	    	    	    
			    if (data.length === 0)
			        data = [];	
			    
			    dataT.datos = data;
				
				tablaN = dataT;
				break;
			case 'addRow':
				var dataT = {
					datos : null,
					encabezados : null,
					columnasEliminar : null
				}

				if (data.length === 0) {
					var newrow = [];
					newrow = [ {
						'valor' : ''
					} ];
					data.push(newrow);
				} else {
					for (var i = 0; i < formatos.length; i++) {
						var newrow = [];
						for (var j = 0; j < data[0].length; j++) {
							if (j == 1)
								newrow.push({
									'valor' : formatos[i]
								});
							else if (j > 1)
								newrow.push({
									'valor' : null
								});
							else {
								if (i == 0)
									newrow.push({
										'valor' : categoria
									});
								else
									newrow.push({
										'valor' : ""
									});
							}
						}
						data.push(newrow);
					}
				}
				dataT.datos = data;
				tablaN = dataT;
				break;
			default:
			}
			tablaPrecios.datos       = tablaN.datos       != null ? tablaN.datos       : tablaPrecios.datos;
			tablaPrecios.encabezados = tablaN.encabezados != null ? tablaN.encabezados : tablaPrecios.encabezados;
			return tablaPrecios;
	    },
	    
	    actualizarPrecioCelda : function(fila, columna, valor, tablaPrecios) {
			var valClean = $filter('numDigNormal')(valor.srcElement.value);
			if (!isNaN(valClean) && parseFloat(valClean) > 0) 
			{
				if (valClean == "")
					tablaPrecios.datos[fila][columna].valor = null;
				else if (columna % 2 == 0) 
				{
					tablaPrecios.datos[fila][columna].valor = $filter('numDigMoneda')(valor.srcElement.value, 4);
					tablaPrecios.datos[fila][columna + 1].valor = null;
				}
				else
				{
					tablaPrecios.datos[fila][columna].valor = $filter('numDigMoneda')(valor.srcElement.value, 4);
					tablaPrecios.datos[fila][columna - 1].valor = null;
				}
			} 
			else
				valor.srcElement.value = null;
			
			return tablaPrecios;
		},
		
		validaPrecio : function(tablaPrecios) {
			var continuar = true;
			
			//Se validan valores moneda 
			if(continuar) 
			{ 		  
	          var formato     =	tablaPrecios.datos[0][1].valor;	
			  var numFormatos = 1;
			  for(var i=1; i<tablaPrecios.datos.length;i++)
			  {
				  if(tablaPrecios.datos[i][1].valor == formato)
					  numFormatos++;
			  }
			  var numFormatos2 = tablaPrecios.datos.length / numFormatos;		  
			  var fila = numFormatos2 - 1;		  
			  var indicePais = 0;
			  
			  for(var j=2; j<tablaPrecios.datos[0].length; j+=2)
			  {			  		
				  if(!continuar) break;
				  fila = numFormatos2 - 1;
				  for(var i=0; i< tablaPrecios.datos.length; i+= numFormatos2)
				  {			
					  tablaPrecios = terminosValidateService.validarValoresMonedaTablas(tablaPrecios, i , fila, j, numFormatos2);
					  
					  var pais    = tablaPrecios.encabezados[indicePais].valor;
					  var mensaje = ". Falta regsitrar campos en el pais "+pais + " en el release "+tablaPrecios.datos[fila][0].valor;
					  continuar = terminosValidateService.mensajeValidacion(tablaPrecios.valida, tablaPrecios.nombre, mensaje);				  				  
					  fila = fila + numFormatos2;
					  if(!continuar) break;
				  }	
				  indicePais++;
			  }		  	  		   
			}
			
			return continuar;
		}, 		
		
		validaPrecioPremium : function(tablaPrecios, columnaInicial) {
			
			var continuar = false;
			var formatoPaises = [];
			var paisesMapa = [];
			var nombrePais = null;
			
			  for(var i=0; i<tablaPrecios.datos.length;i++)
			  {
				  for(var j=columnaInicial; j<tablaPrecios.datos[i].length;j+=2)
			    	if(!isNaN(parseFloat(tablaPrecios.datos[i][j].valor)) || !isNaN(parseFloat(tablaPrecios.datos[i][j + 1].valor)))
			    		formatoPaises.push(1);
			    	else
			    		formatoPaises.push(0);
				  
				  for(var k=0; k<formatoPaises.length; k++)
					if(!paisesMapa[k])
						paisesMapa[k] = formatoPaises[k];
					else 
						if(paisesMapa[k] == 0 && formatoPaises[k]  != 0)
						    paisesMapa[k] = 1;
				
				  var paisConPrecio = 0;
				  for(var k=0; k<paisesMapa.length; k++)
					  if(paisesMapa[k] == 1)
						  paisConPrecio ++;
				  
				  if(paisConPrecio == paisesMapa.length)
					  return true;

				  formatoPaises = [];
			  }
			  
			  for(var k=0; k<paisesMapa.length; k++)
				  if(paisesMapa[k] == 0){
					  nombrePais = tablaPrecios.encabezados[k].descripcion;
					  break;
				  }
			
			var mensaje = ". Falta registrar un valor de moneda en el pais " + nombrePais;
			continuar = terminosValidateService.mensajeValidacion(false, tablaPrecios.nombre, mensaje);				  				  

			return continuar;
		},
		
		validaPrecioLib : function(tablaPreciosLib) {
			//Se validan valores moneda		     
		    var indicePais = 0;
			var fila       = 0;
			var continuar  = true;
			for(var j=1; j<tablaPreciosLib.datos[0].length; j+=2)
			{			  						  				  
				tablaPreciosLib = terminosValidateService.validarValoresMonedaTablas(tablaPreciosLib, 0 , 2, j, 3);
						  
				var pais    = tablaPreciosLib.encabezados[indicePais].valor;
				var mensaje = ". Falta registrar campos en el pais "+pais + ".";
				continuar   = terminosValidateService.mensajeValidacion(tablaPreciosLib.valida, tablaPreciosLib.nombre, mensaje);				  				  				  				  				  	
					  
				indicePais++;
				if(!continuar) break;			
			}			
			return continuar;
		},
		
		obtenerEncabezadosExportar: function(datos, encabezados){
			var enc = [];
			var temp = datos;
			
			var valor = "";				
			for(var i=0; i< temp.length;i++)
			{
			   if(valor != temp[i][0])
				   valor = temp[i][0];
			   else
				  temp[i][0] = ""; 
			}
			
			var fila = [];
			fila.push("Release");
			fila.push("Formato");
			
			for(var i=0; i<(datos[0].length-2)/2;i++)
			{
				fila.push("ML");
			    fila.push("Dolares");
			}
			
			var datos1 = [];
			datos1.push(fila);
			
			for(var i=0; i<temp.length;i++)
				datos1.push(temp[i]);
			datos = datos1;	
			
			enc[0] = "Precio por evento";
			enc[1] = "";
			for(var i=0; i<encabezados.length;i++)
			{
				enc.push(encabezados[i].valor);
				enc.push("");
			}
			return {encabezados: enc, datos: datos};
		},
		
		importarExcelPrecio : function(data, tablaPrecios){
			data.splice(0, 2);		
			for(var i=0; i<tablaPrecios.datos.length; i++)
			{
				for(var j=0; j<tablaPrecios.datos[0].length; j++)
				{
					if(j>1 && data[i].fila[j] != null && data[i].fila[j] != "")
						tablaPrecios.datos[i][j].valor = $filter('numDigMoneda')(data[i].fila[j],4);
					else
						tablaPrecios.datos[i][j].valor = data[i].fila[j];					
				}
			}											
			return tablaPrecios;
		},
		
		crearTablaPreciosLibreria: function(data, encabezados){
	    	var tabla = {encabezados:[], metadatos:null, columnasEliminar: null, datos:null, mensajes : null, subEncabezadosPrecio:null, valida:true, nombre: "Precios"};	    	
	    		    		    	
	    	for(var i=0; i<encabezados.length; i++)
	    		tabla.encabezados.push(encabezados[i]);
	    		    	
	    	tabla.datos = [];
	    		    	
		   	for(var i=0; i < data.length;i++)
		    {
		   	   var fila = [];
		       for(var j=0; j < data[0].length;j++)
			   {		    		    		
		    	   if(data[i][j] == null)
			    	  fila.push({"valor" : null});
			       else if(j>1)
			    	  fila.push({"valor" : $filter('numDigMoneda')(data[i][j],4)});
			       else
			    	  fila.push({"valor" : data[i][j]});		    	
			   }	
		       tabla.datos.push(fila);
		    }
		   	
		   	tabla.subEncabezadosPrecio  = [];
		   	for(var j=0; j < encabezados.length;j++)
		   	{
		   		tabla.subEncabezadosPrecio.push("ML");
		   		tabla.subEncabezadosPrecio.push("Dolares");
		   	}			   		    		    		
		       		    				   		   	
	        return tabla;
	    },
	    	    	    
	    ajustarCategoriasAgregar : function(categoriasAgregar){
	    	var cate = "";
			for(var i=0; i<categoriasAgregar.length; i++)
			{
				if(cate != categoriasAgregar[i].categoria)
				{
					cate = categoriasAgregar[i].categoria;
				}
				else
					categoriasAgregar[i].categoria = null;
			}		
			return categoriasAgregar;
	    },
	    
	    ajustarDatosPrecio : function(datos) {		
			var cate = "";
			for(var i=0; i<datos.length; i++)
			{
				if(cate != datos[i][0])
				{
					cate = datos[i][0];
				}
				else
					datos[i][0] = null;
			}
			return datos;
		},
		
		ajustarTablaPrecio : function(datos) {		
			var cate = "";
			for(var i=0; i<datos.length; i++)
			{
				if(cate != datos[i][0].valor)
				{
					cate = datos[i][0].valor;
				}
				else
					datos[i][0].valor = null;
			}
			return datos;
		},
		
		ajustarTablasPrecio : function(data, categoriasAgregar, paises) {				
			var datos = [];
			
			if(data.datos == null || data.datos.length == 0)
			{				
				for(var i=0; i<categoriasAgregar.length;i++)
				{				
					if( categoriasAgregar[i].agregada == "true")
					{
						var fila = [];				
						fila.push(categoriasAgregar[i].valor);
						fila.push(categoriasAgregar[i].formato);
						for(var j=0; j<paises.length;j++)
						{
							fila.push(null);
							fila.push(null);
						}
						datos.push(fila);
					}								
				}							
			}
			else
			{
				var temp  = data.datos;				
				for(var i=0; i<categoriasAgregar.length;i++)
				{	
					if( categoriasAgregar[i].agregada == "true")
					{
						var fila = [];
						var encontrado = false;
						fila.push(categoriasAgregar[i].valor);
						fila.push(categoriasAgregar[i].formato);
						
						for(var j=0; j<temp.length;j++)
						{
							if( temp[j][0].valor == categoriasAgregar[i].valor && temp[j][1].valor == categoriasAgregar[i].formato)
							{
								encontrado = true;
								for(var k=0; k < temp[j].length;k++)
								{
									if(temp[j][k].valor == null)
							    	   fila.push(null);
							    	 else if(k>1)
							    	   fila.push($filter('numDigMoneda')(temp[j][k].valor, 4));
								}
							}
						}
						
						if(!encontrado)
						{
							for(var j=0; j<paises.length;j++)
							{
								fila.push(null);
								fila.push(null);
							}	
						}
						
						datos.push(fila);					
					}									
				}				
			}
		   return datos;
		},
		
		crearCategoriasAgregar : function(categorias, formatos, precio){
			categoriasAgregarMov  = [];
			
			for(var i=0; i<categorias.length; i++)			
				for(var j=0; j<formatos.length; j++)			
					categoriasAgregarMov.push({categoria: categorias[i], valor: categorias[i], formato: formatos[j], agregada: 'false'});
					
			if(precio != null && precio.length != 0)
			{
				for(var i=0; i<precio.length; i++)
				{
					for(var j=0; j<categoriasAgregarMov.length; j++)
					{
						if(precio[i][0] == categoriasAgregarMov[j].categoria && precio[i][1] == categoriasAgregarMov[j].formato)
						   categoriasAgregarMov[j].agregada = 'true';
					}	
				}
			}
			
			return categoriasAgregarMov;
		}
								
    };	
};

registraService("precioService", precioService);