package com.mx.dla.dda.catalogos.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.admin.catalogos.addons.dtos.CatalogoAddOnDTO;
import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.catalogos.dtos.CategoriaDTO;
import com.mx.dla.dda.catalogos.dtos.EmpresaVentaDTO;
import com.mx.dla.dda.catalogos.dtos.EstatusDTO;
import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.catalogos.dtos.FormatoDTO;
import com.mx.dla.dda.catalogos.dtos.MedioEntregaDTO;
import com.mx.dla.dda.catalogos.dtos.PaisVentaDTO;
import com.mx.dla.dda.catalogos.dtos.RegionVentaDTO;
import com.mx.dla.dda.catalogos.dtos.ReleaseDTO;
import com.mx.dla.dda.catalogos.dtos.ServicioDTO;
import com.mx.dla.dda.catalogos.dtos.TerritorioDTO;
import com.mx.dla.dda.contrato.fees.dtos.TiempoVidaDTO;
import com.mx.dla.dda.contrato.fees.dtos.TipoSuscriptorDTO;
public interface CatalogosDAO {
	
	List<CatalogoDTO> buscarPeriodosActivos();	
	List<EstudioDTO> obtenerEstudios();
	List<CategoriaDTO> obtenerCategorias();
	List<ServicioDTO> obtenerServicios();
	List<TerritorioDTO> obtenerTerritorios();
	List<MedioEntregaDTO> obtenerMediosEntrega();
	List<EstatusDTO> obtenerEstatus();
	int obtenerSqIdContrato();
	List<EmpresaVentaDTO> getEmpresasVenta();	
	PaisVentaDTO getPaisXId(@Param("idPais") Long idPais);	
	RegionVentaDTO getRegionXId(@Param("id") Long id);
	List<FormatoDTO> getFormatos();	
	List<ReleaseDTO> getReleases();
	List<PaisVentaDTO> getPaises();
	List<RegionVentaDTO> getRegiones();
	List<TipoSuscriptorDTO> obtenerTipoSuscriptor();
	List<TiempoVidaDTO>  obtenerTiempoVida();
	
	List<CatalogoDTO> buscarCategoriasActivas();	
	List<CatalogoDTO> buscarCategoriasMGPorEstudioActivas(@Param("idEstudio") Long idEstudio);	
	List<CatalogoDTO> buscarFormatos();		
	List<CatalogoDTO> buscarCatListaByContrato(@Param("idContrato") Long idContrato ,  @Param("prefix") String prefix );	
	List<String>      buscarListaTitlos();	
	List<CatalogoDTO> buscarCatalogoTitulos();	
	List<String> buscarListaTitlosPorEstudio(@Param("idEstudio") Long idEstudio);
	
	List<CatalogoDTO> buscarCatalogoTitulosPorEstudio(@Param("idEstudio") Long idEstudio);
	
	List<CatalogoDTO> buscarCatalogoTitulosCPV(@Param("idEstudio") Long idEstudio);
	List<CatalogoDTO> buscarCatalogoTemporadas(@Param("idEstudio") Long idEstudio ,  @Param("nombreUnico")String nombreUnico );
	
//	rfd
	List<CatalogoDTO> buscarContratosPorEstudio(@Param("idEstudio") Long idEstudio);
	List<CatalogoDTO> buscarCatalogoTitulosDC(@Param("idcontrato") Long idcontrato);
	List<CatalogoDTO> buscarCatalogoTemporadasDC(@Param("idEstudio") Long idEstudio ,  @Param("nombreUnico")Long nombreUnico );
//	rfd	
	
	
	
	CatalogoDTO buscarCategoriasMGPorEstudioYDesc(@Param("idEstudio") Long idEstudio,@Param("desc")String desc);
	List<CatalogoDTO> buscarCatalogoTiempoVida();
	CatalogoDTO buscarTiempoVidaPorDesc(@Param("desc")String desc);
	List<CatalogoDTO> buscarCatalogoReleaseDate();
	CatalogoDTO buscarReleaseDatePorDesc(@Param("desc")String desc);
	List<CatalogoDTO> buscarEstudios();
	
	
	List<CatalogoDTO> buscarCategoriaPagoTodosLosPeriodos(@Param("idContrato") Long idContrato);	
	List<CatalogoDTO> buscarCategoriaPago(@Param("idContrato") Long idContrato); 
	CatalogoDTO buscarCategoriaPagoPorDesc(@Param("idContrato") Long idContrato, @Param("description")String description);

	List<CatalogoDTO> buscarContratoMasRecientePorEstudio(@Param("idEstudio")Long idEstudio,@Param("idContratoOrig")Long idContratoOrig);
	
	List<CatalogoDTO> buscaCategoriasPorContrato(@Param("idContrato") Long idContrato);	
	
	List<CatalogoDTO> buscarListasByContrato(@Param("idContrato") Long idContrato ,  @Param("prefix") String prefix );	

	List<CatalogoDTO> obtenCatalogoEmpresas(@Param("idEmpresas") List<Long> idEmpresas, @Param("idPaises") List<Long> idPaises, @Param("descEmpresas") List<String> descEmpresas, @Param("staEmpresas") List<Long> staEmpresas);
	List<CatalogoDTO> obtenCatalogoAreas(@Param("idAreas") List<Long> idAreas, @Param("descAreas") List<String> descAreas, @Param("indAutorizaContratoAreas") List<Long> indAutorizaContratoAreas, @Param("ordenAreas") List<Long> ordenAreas);
	List<CatalogoDTO> obtenCatalogoPerfiles(@Param("idPerfiles") List<Long> idPerfiles, @Param("descPerfiles") List<String> descPerfiles, @Param("staPerfiles") List<Long> staPerfiles);
	List<CatalogoDTO> obtenCatalogoEstudios(@Param("idEstudios") List<Long> idEstudios, @Param("idSapEstudios") List<Long> idSapEstudios, @Param("descEstudios") List<String> descEstudios, @Param("monedaEstudios") List<String> monedaEstudios, @Param("codigoPaisEstudios") List<String> codigoPaisEstudios, @Param("nombrePaisEstudios") List<String> nombrePaisEstudios, @Param("sociedadEstudios") List<String> sociedadEstudios, @Param("siglaDdaEstudios") List<String> siglaDdaEstudios, @Param("ordenEstudios") List<Long> ordenEstudios, @Param("idGroupEstudios") List<Long> idGroupEstudios);

	List<CatalogoAddOnDTO> getAddOns();
}
