function FormManager() {
	this.dateFormatIn  = 'yy-mm-dd';
	this.dateFormatOut = 'mm/dd/yy';
}

FormManager.prototype.leerForma = function(_forma,columns) {
	var _i = {};
	var me = this;
	columns.forEach(function(column, i) {
		var name =   (typeof column.mname != 'undefined'  && column.mname != null ) ? column.mname : column.name;
		var _item = $("#" + _forma + "   [name='" + name + "']");
		var val;
		if (_item.is(':checkbox')) {
			val = _item.prop('checked');
		} 
		else if (_item.is('select')) {
			if(_item.val()!= '')
			{
				val = {};
				val["desc"] = _item.find('option:selected').text();
				val["value"] = _item.val();
			}
		} 
		else if(_item.is(':radio'))
		{
			val = _item.filter(':checked').val();
		}
		else {
			val = _item.val();
		}
		if (val !== '') {
			me.deepSet(_i, name, val);
		}
	});
	return _i;
};

FormManager.prototype.llenarForma = function(t,_forma,columns) {	
	var me = this;
	columns.forEach(function(column, i) {
		var name =  (typeof column.mname != 'undefined'  && column.mname != null ) ? column.mname : column.name;
		
		
		var _item = $("#" + _forma + " [name='" + name + "']");
		var value = t[name];
		
		if (column.formatter  != null  &&  column.formatter =='date' ) {
			value = me.changeDateFormat(me.dateFormatIn,
					me.dateFormatOut, t[name]);
		}
		if (_item.is(':checkbox')) {
			_item.prop('checked', value);
		} else if (_item.is('select')) {
			if( typeof value != 'undefined'  && value != null )
			{
				_item.val(value.value);
			}
			
		} else if(_item.is(':radio'))
		{
			_item.filter("[value='"+value+"']" ).prop('checked', true);
		}
		else {
			_item.val(value);
		}
		$(_item).trigger("change");
	});
};

FormManager.prototype.changeDateFormat = function (formatIn,formatOut,value)
{
	var _value = value;
	if(value != null  && value != "" && typeof value != 'undefined'){
    	_value = value.split("T")[0];
		var d = $.datepicker.parseDate( formatIn, _value ); 
		
		d = new Date(d.valueOf() + d.getTimezoneOffset() * 60000);
		_value = $.datepicker.formatDate(formatOut,d);
	}
	return _value;
};


FormManager.prototype.limpiarForma = function(idForm ) {
	$("#" + idForm).find(
			'input:text, input:hidden, input:password, input:file, select, textarea').val('');
	$("#" + idForm).find('input:radio, input:checkbox').removeAttr(
			'checked').removeAttr('selected');
	
	var validForm = this[idForm];
	if(validForm!= null && typeof validForm != 'undefined')
		validForm.resetForm();
};

FormManager.prototype.initForm = function(idForm , opts ) {
	
	var o = {};
	if(opts != null && typeof opts != 'undefined' )
	{
		o =  $.extend(true,{}, opts);
	}
	this[idForm] = $("#" + idForm).validate(o);
};

FormManager.prototype.deepSet = function(obj,path, value) {
    
    var prop = path;
	if (typeof prop === "string")
		prop = prop.split(".");

	if (prop.length > 1) {
		var e = prop.shift();
		Object.assign(
				obj[e] = Object.prototype.toString.call(obj[e]) === "[object Object]" ? obj[e]
						: {}, prop, value);
	} else {
		obj[prop[0]] = value;
	}
};