package com.mx.dla.dda.reporte.pagoSuscriptores.actions;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.PoblarGeneralesBO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.reporte.pagoSuscriptores.bos.ReportePagoSuscriptoresBO;
import com.mx.dla.dda.reporte.pagoSuscriptores.constants.TipoPago;
import com.mx.dla.dda.reporte.pagoSuscriptores.dtos.ReportePagoSuscriptoresDTO;
import com.opensymphony.xwork2.Action;

public class ReportePagoSuscriptoresAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private Long idEstudio;
	private String mes;
	private String tipoPago;

	private List<ReportePagoSuscriptoresDTO> reporteDetalle;

	@Autowired
	private PoblarGeneralesBO poblarGeneralesBO;

	@Autowired
	private ReportePagoSuscriptoresBO reportePagoSuscriptoresBO;

	public String cargaReporte() {

		ReportePagoSuscriptoresDTO parametros = new ReportePagoSuscriptoresDTO();

		SimpleDateFormat ft = new SimpleDateFormat("MM-yyyy");

		Date dateDefault = new Date();
		Calendar cal = Calendar.getInstance();
		cal.setTime(dateDefault);
		cal.add(Calendar.MONTH, -1);
		dateDefault = cal.getTime();

		String mesDefault = ft.format(dateDefault);
		parametros.setMes(mesDefault);
		
		mes = mesDefault;

		return Action.SUCCESS;

	}

	public String consultaReporte() {

		ReportePagoSuscriptoresDTO parametros = new ReportePagoSuscriptoresDTO();
		
		if(tipoPago.equals(""))
			tipoPago = null;

		parametros.setMes(mes);
		parametros.setTipoPago(tipoPago);
		parametros.setIdEstudio(idEstudio);

		reporteDetalle = reportePagoSuscriptoresBO
				.obtenInformacionReporte(parametros);

		return Action.SUCCESS;

	}

	public List<EstudioDTO> getEstudios() {
		try {
			return poblarGeneralesBO.obtenListaEstudios();
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			return null;
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			return null;
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			return null;
		}
	}

	public List<TipoPago> getTiposPago() {
		return Arrays.asList(TipoPago.values());
	}

	public Long getIdEstudio() {
		return idEstudio;
	}

	public void setIdEstudio(Long idEstudio) {
		this.idEstudio = idEstudio;
	}

	public String getMes() {
		return mes;
	}

	public void setMes(String mes) {
		this.mes = mes;
	}

	public String getTipoPago() {
		return tipoPago;
	}

	public void setTipoPago(String tipoPago) {
		this.tipoPago = tipoPago;
	}

	public List<ReportePagoSuscriptoresDTO> getReporteDetalle() {
		return reporteDetalle;
	}

	public void setReporteDetalle(
			List<ReportePagoSuscriptoresDTO> reporteDetalle) {
		this.reporteDetalle = reporteDetalle;
	}

}