package com.mx.dla.dda.carga.transaccion.daos;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.carga.transaccion.dtos.CargaTransaccionesDTO;
import com.mx.dla.dda.carga.transaccion.dtos.FechaBloqueoDTO;
import com.mx.dla.dda.carga.transaccion.dtos.PrincipalCargaTransaccionesDTO;
import com.mx.dla.dda.carga.transaccion.dtos.RowRepErrAsocTitulosDTO;
import com.mx.dla.dda.carga.transaccion.dtos.RowRepErrResumenCargaDTO;
import com.mx.dla.dda.carga.transaccion.dtos.RowReporteCargaDTO;
import com.mx.dla.dda.carga.transaccion.dtos.TitulosCargaTransaccionesDTO;
import com.mx.dla.dda.carga.transaccion.ws.procesarCargaTitulosPN.CargaPrincipalPNDTO;

public interface CargaTransaccionesDAO {
	
		public List<CargaTransaccionesDTO> obtenCargaTransacciones(@Param("mes") String mes);
		
		public PrincipalCargaTransaccionesDTO obtenerPrincipalCargaTransacciones(PrincipalCargaTransaccionesDTO principalCarga);
		
		public void registrarPrincipalCarga(PrincipalCargaTransaccionesDTO principalCarga);
		
		public List<String> obtenListaPaises();
		
		List<LinkedHashMap<String, String>> obtenReporteVistaPrevia(@Param("idCargaTrans") Long idCargaTrans, @Param("pivot_select") String pivot_select, @Param("pivot_paises") String pivot_paises);
		
		List<Map<String, String>> obtenRowReporte(@Param("idCargaTrans") Long idCargaTrans, @Param("pivot_select") String pivot_select, @Param("pivot_paises") String pivot_paises);
		//public List<RowReporteCargaDTO> obtenRowReporte(@Param("idCargaTrans") Long idCargaTrans, @Param("pivot_data") String pivot_data, @Param("pivot_p") String pivot_p);
		//public List<RowReporteCargaDTO> obtenRowReporte(@Param("idCargaTrans") Long idCargaTrans);
		//public List<RowRepErrResumenCargaDTO> obtenRowReporteResumenCarga(@Param("idCarga") Long idCarga);
		
		public List<RowRepErrResumenCargaDTO> obtenRowReporteResumenCarga(@Param("mes") String mes);
		
		public List<RowRepErrAsocTitulosDTO> obtenRowReporteErrAsocTitulos(@Param("idCarga") Long idCarga);
		
		public List<RowRepErrAsocTitulosDTO> obtenerListaErrAsocTitulos(@Param("idCarga") Long idCarga);
		
		public PrincipalCargaTransaccionesDTO obtenerResumenCarga(@Param("mes") String mes);
		
		public PrincipalCargaTransaccionesDTO obtenerResumenCargaIdCarga(@Param("idCarga") Long idCarga);
		
		public List<TitulosCargaTransaccionesDTO> titulosdelaCarga(@Param("mes") String mes);
		
		public List<TitulosCargaTransaccionesDTO> sinIdBroadView(@Param("idCarga") Long idCarga);
		
		public List<TitulosCargaTransaccionesDTO> idBroadViewNoExiste(@Param("idCarga") Long idCarga);
		
		public List<TitulosCargaTransaccionesDTO> tituloyFilialNoExiste(@Param("idCarga") Long idCarga);
		
		public List<TitulosCargaTransaccionesDTO> tituloFueradePeriodo(@Param("idCarga") Long idCarga);
		
		public void actualizarIdBv(TitulosCargaTransaccionesDTO actualizaIdBv);
		
		public void ejecutaSP(String fecha);
		
		public void ejecutaSP_porcR(String fecha);
		
		public void validaCarga(PrincipalCargaTransaccionesDTO validacarga);
		
		public void calculaOverage(@Param("idCarga") Long idCarga);
				
		public void ejecutaSP_MarcaCont(@Param("in_Contrato") String in_Contrato , @Param("in_Estudio")  String in_Estudio);
		
		public List<FechaBloqueoDTO> consultarFechaActual( @Param("mes")String mes ,@Param("anio")String anio);
		
}
