package com.mx.dla.dda.contrato.common.bos;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.contrato.common.daos.JustificacionDAO;
import com.mx.dla.dda.contrato.common.dtos.JustificacionDTO;
import com.mx.dla.global.bos.BaseBO;

@Service
public class JustificacionBO extends BaseBO {
	
	@Autowired
	private JustificacionDAO justificacionDAO;

	public JustificacionDTO insertarJustificacion(String justificacion,Long idContrato, UsuarioDTO usuario)
	{
		JustificacionDTO j = new JustificacionDTO();
		j.setFecha(new Date());
		j.setJustificacion(justificacion);
		j.setUsuario(usuario);
		j.setIdContrato(idContrato);
		justificacionDAO.insertarJustificacion(j);
		return j;
	}
	
	public void borrarJustificacion( Long idJustificacion)
	{
		justificacionDAO.borrarJustificacion(idJustificacion);
	}
	
	public List<JustificacionDTO> buscarJustificaciones( Long idContrato)
	{
		return justificacionDAO.buscarJustificaciones(idContrato);
	}
	

}
