var operacion = "";
$(document).ready(
		function(){
			inicial();
		});

function inicial(){
	reiniciaTabla();
	cargaInformacionTabla();
	$("table thead tr").addClass("encabezado");
}

function reiniciaTabla(){		
	$('#divTablaIn').remove();
	var div = '<div id="divTablaIn"></div>';
	$('#divTablaExt').append(div);
	var tabla = $("<table class='table table-striped'/>").attr('id',"tablaGrupoEstudio");       
	$("#divTablaIn").append(tabla);	
}

function cargaInformacionTabla() {
	// Obtener numero de menu
	var menu        = $("#pmn").val();
	var menuRegreso = $("#pmnReturn").val();
	var namespace = "/catalogos/estudios/index";
	
    var rowId=null;
    var oTable=null;
    
     oTable=$('#tablaGrupoEstudio').dataTable({		    
	   "bAutoWidth": false,
		"oLanguage":{	"sProcessing":     "Procesando...",
						"sLengthMenu":     "Mostrar _MENU_ registros",
						"sZeroRecords":    "Sin eventos encontrados",
						"sEmptyTable":     "Sin eventos encontrados",
						"sInfo":           "Mostrando  _START_ al _END_ de  _TOTAL_ ",
						"sInfoEmpty":      "0 registros",
						"sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
						"sSearch":         "Buscar:",
						"sInfoThousands":  ",",
						"sLoadingRecords": "Cargando...",
						"oPaginate": {
							"sFirst":    "Primero",
				        	"sLast":     "&Uacute;ltimo",
				        	"sNext":     "Siguiente",
				        	"sPrevious": "Anterior"
				    	}
				},
		"iDisplayLength": 10,
		"bInfo"     : false,
		"bFilter"   : true,
		"bSort"     : false,
		"bPaginate" :true,
		"sPaginationType" : "full_numbers",
		"aaSorting": [],
		"sAjaxSource": "obtenerInfoGrupos",
		"sAjaxDataProp":"", 
	    "aoColumns": [
						{"sTitle":"Descripcion",	"mDataProp":"descripcionGrupo",		"bSearchable": true, sWidth : "400px"},
						{"sTitle":"Estatus",		"mDataProp":"estatus",				"bSearchable": true, sWidth : "400px"},
						{"sTitle":"Orden",			"mDataProp":"orden",				"bSearchable": true, sWidth : "400px"},
						{"sTitle":"Mostrar contratos ocultos",		"mDataProp":"colapsa",				"bSearchable": true, sWidth : "400px"},
	          			],
	    		        'fnRowCallback': function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
	    		        	var link = '<a onClick="guardaIdGrupo('+aData["idGrupo"]+')" data-toggle="modal" data-target="#modalAgregaActualiza"> ' + aData["descripcionGrupo"] +'</a>';
	    		        	$('td:eq(0)', nRow).html(link);
	    		        	
	    		        	$('td:eq(1)', nRow).html(aData["estatus"] == 0 ? "Inactivo" : "Activo");
	    		        	
	    		        	var palomeado = aData["colapsa"] == 1 ? 'checked' : '';
	    		        	
	    		        	$('td:eq(3)', nRow).html('<input type="checkbox" '+ palomeado +' disabled>');
	    		        	
	   		       		}
		});
	
}

function callActionAjax(actionRoute, jsonActionParameter, functionProcessor){
	
	 $.ajax({
	     url: contextPath + actionRoute,
	     type: 'POST',
	     data:  jsonActionParameter, 
		 dataType: "json",
	     success:function(response){ 
	    	 functionProcessor(response);    
	     },
	     error:function(jqXhr, textStatus, errorThrown){
	         showError("Problemas al enviar los datos.");
	     }
	 });
	
}

function guardaIdGrupo(idGrupo) {
	operacion = "Actualiza";
	$('#inpEstatus').find('option').remove();
	llamaObtenGrupo(idGrupo);
	$("#modHeader").text(operacion + " grupo");
	
}

function defineOperacion(oper) {
	operacion = oper;
	$("#modHeader").text(operacion + " grupo");
	$('#inpIdGrupo').val('');
	$('#inpDescripcion').val('');
	$('#inpOrden').val('');
	$('#inpEstatus').find('option').remove();
	
	if(operacion == 'Crea') {
		$("#inpEstatus").append('<option value=1 >Activo</option>');
		$("#inpEstatus").append('<option value=0 >Inactivo</option>');
	}
	
	$( "#inpColapsa" ).prop( "checked", false );

}

function procesaRespuestaObtenGrupo(jsonData) {
	var gru = jsonData.grupo;
	$("#modHeader").text(operacion + " grupo");
	$('#inpIdGrupo').val(gru.idGrupo);
	$('#inpDescripcion').val(gru.descripcionGrupo);
	
	if(gru.estatus == 1){
		$("#inpEstatus").append('<option value=1 >Activo</option>');
		$("#inpEstatus").append('<option value=0 >Inactivo</option>');
	}else {
		$("#inpEstatus").append('<option value=0 >Inactivo</option>');
		$("#inpEstatus").append('<option value=1 >Activo</option>');
	}
	
	if(gru.colapsa != 0 && gru.colapsa != null && gru.colapsa != undefined ){
		$( "#inpColapsa" ).prop( "checked", true );
		$( "#inpColapsa" ).val(1);
	}else {
		$( "#inpColapsa" ).prop( "checked", false);
		$( "#inpColapsa" ).val(0);
	}
	
	if(gru.esEditable == 0){
		$('#inpDescripcion').prop( "disabled", true );
		$("#inpEstatus").prop( "disabled", true );
		$("#inpColapsa").prop( "disabled", true );
		$('#inpOrden').prop( "disabled", true );
	}else {
		$('#inpDescripcion').prop( "disabled", false );
		$("#inpEstatus").prop( "disabled", false );
		$("#inpColapsa").prop( "disabled", false );
		$('#inpOrden').prop( "disabled", false );
	}
	
	$('#inpOrden').val(gru.orden);
}

function llamaObtenGrupo(idGrupo) {
	var jsonString = '{"idGrupo" : "'+ idGrupo +'"}';
	var stringJson = JSON.parse(jsonString);
	callActionAjax( "/catalogos/grupos/llamaObtenGrupo", stringJson, procesaRespuestaObtenGrupo);
}

function procesaRespuestaRegistraActualiza(jsonData) {
	
	if(operacion == "Actualiza") {
		$('#modalAgregaActualiza').modal('hide');
		showMessage("Actualizado con \u00E9xito");
	}else {
		$('#modalAgregaActualiza').modal('hide');
		showMessage("Creado con \u00E9xito");
	}
	
	inicial();
}

function llamaRegistraActualiza() {
	var jsonString = '{"idGrupo" : "'+ $('#inpIdGrupo').val() + '", "descripcion" : "' + $('#inpDescripcion').val() + '", "estatus" : "' + $('#inpEstatus').val() + '", "colapsa" : "' + $('#inpColapsa').val() + '", "orden" : "' + $('#inpOrden').val() + '", "operacion" : "' + operacion +'"}';
	var stringJson = JSON.parse(jsonString);
	callActionAjax( "/catalogos/grupos/llamaRegistraActualiza", stringJson, procesaRespuestaRegistraActualiza);
}

function cambiaValorCheck(){
	
	if($( "#inpColapsa" ).val() == 1) {
		$( "#inpColapsa" ).val(0);
	}else {
		$( "#inpColapsa" ).val(1);
	}
}