function limpiarTabla(){		
	$('#catalogoPais').remove();				
	var table = $("<table class='table table-striped'/>").attr('id',"catalogoPais");       
	$("#contTabla").append(table);		
}

function realizaConsulta(){				
	// Obtener numero de menu
	var menu        = $("#pmn").val();
	var menuRegreso = $("#pmnReturn").val();
	var namespace   = "/catalogos/paises/index";
	
    var rowId=null;
    var oTable=null;
    oTable=$('#catalogoPais').dataTable({		    
	   "bAutoWidth": false,
		"oLanguage":{	"sProcessing":     "Procesando...",
						"sLengthMenu":     "Mostrar _MENU_ registros",
						"sZeroRecords":    "Sin eventos encontrados",
						"sEmptyTable":     "Sin eventos encontrados",
						"sInfo":           "Mostrando  _START_ al _END_ de  _TOTAL_ ",
						"sInfoEmpty":      "0 registros",
						"sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
						"sSearch":         "Buscar:",
						"sInfoThousands":  ",",
						"sLoadingRecords": "Cargando...",
						"oPaginate": {
							"sFirst":    "Primero",
				        	"sLast":     "&Uacute;ltimo",
				        	"sNext":     "Siguiente",
				        	"sPrevious": "Anterior"
				    	}
				},
		"iDisplayLength": 10,
		"bInfo"     : false,
		"bFilter"   : true,
		"bSort"     : false,
		"bPaginate" :true,
		"sPaginationType" : "full_numbers",
		"aaSorting": [],
		"sAjaxSource": "indexlistadoPais",
		"sAjaxDataProp":"", 
	    "aoColumns": [
						{"sTitle":"Nombre"      ,"mDataProp":"nombre"      ,"bSearchable": true, sWidth : "400px"},
						{"sTitle":"Territorio"  ,"mDataProp":"territorio"  ,"bSearchable": true, sWidth : "900px"},
	          			{"sTitle":"Regi\u00F3n"      ,"mDataProp":"region"      ,"bSearchable": true, sWidth : "600px"},
						{"sTitle":"Impuesto %"    ,"mDataProp":"impuesto"    ,"bSearchable": true, sWidth : "400px"}						
          			 ],          			 
	    "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
	   		        	 	
	    		        	var urlModificar = "<a href='" + contextPath + namespace +
    		        	                        "buscaPais.action?pmn="+menu + "&pmnReturn="+menuRegreso+"&pais.id=#value'>"+aData["nombre"]+"</a>";	    		        	
	    		        	$(nRow).attr("id",aData["id"]);		   		        	 	
		          			$('td:eq(0)', nRow).html(urlModificar.replace("#value", aData["id"] ));
		          			$('td:eq(1)', nRow).html(aData["territorio"]);
		          			$('td:eq(2)', nRow).html(aData["region"]);
		          			$('td:eq(3)', nRow).html(aData["impuesto"]);		          						          			 			          		
	   		       		}
		});
}

function regreso(){	
	var menu = $("#pmnReturn").val();
	window.location.href = contextPath + "/catalogos/paises/index.action?pmn=" + menu;
}

function botonesAgregar(){
	$("#nuevo").click(function()  
	{
		var menu = $("#pmn").val();
		var menuRegreso = $("#pmnReturn").val();	
		window.location.href = contextPath + "/catalogos/paises/indexirCrearPais.action?pmn="+menu+"&pmnReturn="+menuRegreso;				
	});
}

function validar(){
	$("#forma").validate(
		      {
		        rules: 
		        {
		        	"pais.nombre": 
			        {
			            required: true,
			            maxlength: 25,
			            regex:"^[A-Z. a-z\u00A0\u00E1\u00E9\u00ED\u00F3\u00FA\u00C1\u00C9\u00CD\u00D3\u00DA\u00D1\u00F1]+$"
			        },
		      		"pais.impuesto":
		      		{
		      			number: true,
		      			range:[1, 50]
		      		},
		      		"pais.idTerritorio": 
		      		{ 
		      			valueNotEquals: "", 
		      		},
		      		"pais.idRegion": 
		      		{ 
		      			valueNotEquals: "", 
		      		},
		      		"pais.estatus": 
		      		{ 
		      			valueNotEquals: "", 
		      		}
		        },
		        messages: 
		        {
		        	"pais.nombre": 
			         {
			            required: "Nombre del Pa&#237;s es obligatorio.",
			            maxlength: "Nombre no debe exceder 50 caracteres",
			            regex: "Nombre debe ser con caracteres alfab&#233;ticos"
			         },		          
		            "pais.impuesto": 
		             {
			            range: "Impuesto no debe ser mayor a 50"	
		             },
		             "pais.idTerritorio": 
		             { 
		            	 valueNotEquals: "Selecciona un valor para Territorio." 
		             },
		             "pais.idRegion": 
		             { 
		            	 valueNotEquals: "Selecciona un valor para Regi&#243;n." 
		             },
		             "pais.estatus": 
		             { 
		            	 valueNotEquals: "Selecciona un valor para Estatus." 
		             }
		        }
	});
	
	$.validator.addMethod("regex",function(value,element,regexp){
		  var re= new RegExp(regexp);
	      return this.optional(element) || re.test(value);
	},"Only Characters from A-z");
	
	$.validator.addMethod("valueNotEquals", function(value, element, arg){
		  return arg != value;
	}, "Value must not equal arg.");
}