var uploaderLib = new UploaderEX("cargaFeesDivLib"); //Se crear el objeto para cargar archivos
var datosSubirLib = null;

var rentaLibreriaController = function($scope, $filter, rentaLibreriaService, tablaService, feesValidateService) {		  	 	 	 	 	
	 $scope.tablaMinGarLib       = null;
	 $scope.tablaMinGarAnioLib   = null;
	 $scope.tablaImpuestosLib    = null;
	 $scope.tablaPreciosLib      = null;
	 $scope.tablaRevenueLib      = null;
	 $scope.tablaRevenueBoxLib   = null;
	 $scope.tipoMinLib           = null;
	 $scope.tipoRevenue          = null;	 
	 $scope.formatos             = null;
	 $scope.revenueBoxEditable   = null;
	 $scope.idsCatLib            = null;	 	 
	 $scope.idCatEliLib          = [];
	 
	rentaLibreriaService.inicializarTablasLibreria().then(function(data){		 
		 $scope.inicializar(data);		
	});
	 
	$scope.inicializar = function(data){	
		 if(data.datosMin != null && data.datosMinAnio == null)
		 {
			 $scope.tablaMinGarLib     = rentaLibreriaService.crearTablaMinimosGaranzatidosCateg(data.datosMin,null, data);
			 
			 var dataTem = [];			 
			 var filaTem = [];
			 for(var i=0; i<data.aniosMin.length;i++)
				 filaTem.push(null);
			 dataTem.push(filaTem);
			 
			 $scope.tablaMinGarAnioLib = rentaLibreriaService.crearTablaMinimosGaranzatidosAnio(dataTem,null, data);;
			 $scope.tipoMinLib         = "categoria";			  
			 $scope.idsCatLib          = data.idCatMin;
			 this.inicializarDivMinimos();
		 }			 
		 else if(data.datosMinAnio != null && data.datosMin == null)
		 {			 						 
			 $scope.tablaMinGarAnioLib  = rentaLibreriaService.crearTablaMinimosGaranzatidosAnio(data.datosMinAnio,null, data);
			 			 
			 var dataTem = [];
			 var filaTem = [null,null,"MFTV/MFV"];
			 for(var i=0; i<data.aniosMin.length;i++)
				 filaTem.push(null);
			 dataTem.push(filaTem);			 
			 			 
			 $scope.tablaMinGarLib = rentaLibreriaService.crearTablaMinimosGaranzatidosCateg(dataTem, null, data);
			 $scope.tipoMinLib     = "anio";
			 $scope.idsCatLib      = [0];
			 this.mostrarRevenue();
			 this.inicializarDivMinimos();
		 }
		 else if(data.datosMinAnio != null && data.datosMin != null)
		 {
			 $scope.tablaMinGarAnioLib  = rentaLibreriaService.crearTablaMinimosGaranzatidosAnio(data.datosMinAnio,null, data);
			 $scope.tablaMinGarLib      = rentaLibreriaService.crearTablaMinimosGaranzatidosCateg(data.datosMin,null, data);
			 $scope.tipoMinLib = null;
			 $scope.idsCatLib  = [0];
			 this.inicializarDivMinimos();
		 }		 
		 
		 $scope.tablaImpuestosLib = rentaLibreriaService.crearTablaImpuestos(data.datosImpuestos, data.paises, null);
		 $scope.tablaPreciosLib   = rentaLibreriaService.crearTablaPreciosLibreria(data.datosPrecio,  data.paises, null);
		 
		 if(data.revenueGlobal)
		 {
			 var temp = [];
			 temp.push([null, null, null, null,null])
			 $scope.tablaRevenueLib     = rentaLibreriaService.crearTablaRevenue(data.datosRevenue, [], null);
			 $scope.tablaRevenueBoxLib  = rentaLibreriaService.crearTablaRevenueBox(temp, [], null);
			 $scope.tipoRevenue         = "global";			 
		 }

		 if(data.revenueBox)
		 {
			 var temp = [];
			 temp.push([null,null]);
			 $scope.tablaRevenueLib     = rentaLibreriaService.crearTablaRevenue(temp, [], null);
			 $scope.tablaRevenueBoxLib  = rentaLibreriaService.crearTablaRevenueBox(data.datosRevenueBox, [], null);
			 $scope.tipoRevenue         = "box";
			 			 
			 if(data.datosMin)
			 {
				 var num = $scope.tablaMinGarLib.datos.length;
				 for(var i =0; i<num; i++)
				 {
					 for(var j =0; j<$scope.tablaRevenueBoxLib.datos[0].length; j++)
					     $scope.tablaRevenueBoxLib.datos[i][j].editable = false;				      
				 }								 
			 }
			 else
			 {
				 $scope.tablaRevenueBoxLib.datos[0][0].editable = true;
				 $scope.tablaRevenueBoxLib.datos[0][1].editable = true;
			 }
			 
		 }	
		 if(!data.revenueBox && !data.revenueGlobal) 
		 {
			 $scope.tablaRevenueLib     = rentaLibreriaService.crearTablaRevenue(data.datosRevenue, [], null);
			 $scope.tablaRevenueBoxLib  = rentaLibreriaService.crearTablaRevenueBox(data.datosRevenueBox, [], null);
		 }
		 $scope.formatos       = data.formatos;		 
	}	    	 	 		
	
	$scope.inicializarDivMinimos = function() {				
		if($scope.tipoMinLib == "categoria")
		{
			$("#divMinCateLib").show();
			$("#divMinAnioLib").hide();			
		}
		else if($scope.tipoMinLib == "anio")
		{
			$("#divMinAnioLib").show();
			$("#divMinCateLib").hide();
		}
		else		
		{
			$("#divMinAnioLib").hide();
			$("#divMinCateLib").hide();
		}
	};

	$scope.editarTablaMinGarantizados = function(operacion, index, encabezado){
		 var tablaN;
		 var modificado = false;
		 
		 switch (operacion) 
		 {
	         case 'removeRow':	        	 
	        	 rentaLibreriaService.verificarCategMin($scope.idsCatLib[index]).then(function(data) {

	        		 if(data.fees.valido)
	 				 {
	        		    tablaN  = tablaService.removeRow($scope.tablaMinGarLib.datos, index);
	        		    
	 					if ($scope.idsCatLib[index] != 0)
	 						$scope.idCatEliLib.push($scope.idsCatLib[index]);

	 					$scope.idsCatLib.splice( index, 1);
	 					modificado = true;
	 				}
	 				else
	 					showError("La categor\u00EDa no se puede eliminar.");				
	 			 });	        		 	        		
	        		 
	             break;
	         case 'addRow':	        	 
	        	 tablaN  = tablaService.addRow($scope.tablaMinGarLib.datos);	        	 
	        	 $scope.idsCatLib.push(0);
	        	 modificado = true;
	             break;
	         case 'addColumn':			
	 			tablaN = tablaService.addColumn($scope.tablaMinGarLib.datos, $scope.tablaMinGarLib.encabezados, null, encabezado);
	 			modificado = true;
	 			break;
	         default:
		 }
		 if(modificado)
		 {			
			 $scope.tablaMinGarLib.datos            = tablaN.datos            != null ? tablaN.datos            : $scope.tablaMinGarLib.datos;		 			
			 $scope.tablaMinGarLib.encabezados      = tablaN.encabezados      != null ? tablaN.encabezados      : $scope.tablaMinGarLib.encabezados ;
			 if( $('#box').prop('checked'))
			     this.actualizarBox();
		 }
	 };
	 	 	 	 	 
	 $scope.editarTablaMinGarantizadosAnio = function(operacion, index, encabezado){
		 var tablaN;
		 var numAnio = $scope.tablaMinGarAnioLib.datos[0].length+1;
		 switch (operacion) 
		 {
	         case 'addColumn':
	        	 tablaN = tablaService.addColumn($scope.tablaMinGarAnioLib.datos, $scope.tablaMinGarAnioLib.encabezados, $scope.tablaMinGarAnioLib.columnasEliminar, encabezado);
	             break;
	         case 'removeColumn':
	        	 tablaN = tablaService.removeColumn($scope.tablaMinGarAnioLib.datos, $scope.tablaMinGarAnioLib.encabezados, $scope.tablaMinGarAnioLib.columnasEliminar, index);
	             break;	         
	         default:
		 }		 
		 $scope.tablaMinGarAnioLib.datos            = tablaN.datos            != null ? tablaN.datos            : $scope.tablaMinGarAnioLib.datos;				
		 $scope.tablaMinGarAnioLib.encabezados      = tablaN.encabezados      != null ? tablaN.encabezados      : $scope.tablaMinGarAnioLib.encabezados ; 		 		 
	 };
	 			 
	 $scope.editarTablaRevenueBoxLib = function(operacion, index){
		 var tablaN;		 
		 switch (operacion) 
		 {
			 case 'removeRow':
	        	 tablaN  = tablaService.removeRow($scope.tablaRevenueBoxLib.datos, index);
	             break;
	         case 'addRow':
	        	    data =  $scope.tablaRevenueBoxLib.datos
	        	    var dataT = {datos : null, encabezados : null, columnasEliminar: null}
								
	        	    var newrow = [];	
					data[0].forEach(function (row) {
					     newrow.push({'valor':'' , "editable": true});
					});				    	     
				    data.push(newrow);							    
				    dataT.datos = data;
				    tablaN = dataT; 
             break;	         
	         default:
		 }		 
		 $scope.tablaRevenueBoxLib.datos            = tablaN.datos            != null ? tablaN.datos            : $scope.tablaRevenueBoxLib.datos;				
		 $scope.tablaRevenueBoxLib.encabezados      = tablaN.encabezados      != null ? tablaN.encabezados      : $scope.tablaRevenueBoxLib.encabezados ; 		 		 
	 };
	 
     $scope.actualizarMinCelda = function(fila, columna, valor){			
    	  var valClean =  $filter('numDigNormal')(valor.srcElement.value);
    	  var valNum;
	   	  if(!isNaN(valClean) && parseFloat(valClean) > 0 && valClean != "")
	   	  {
	   		  if($scope.tipoMin == "anio")
	       	  {
	       		  if(valClean == "")    			
	   				 $scope.tablaMinGarAnioLib.datos[fila][columna].valor = null;    			    			  
	       		  else
	       		     valor.srcElement.value = $filter('numDigMoneda')(valClean,2); 
	       	  }    	      		    		     	  
	       	  else
	       	  {    		
	       		  if(columna != 2)
	       		  {
	       			 if(valClean == "")        			  
	        		    $scope.tablaMinGarLib.datos[fila][columna].valor = null;    			        			      				
	        		 else
	        		 {
	        			 valor.srcElement.value = $filter('numDigMoneda')(valClean,2);
	        			 valNum = $filter('numDigMoneda')(valClean,2);
	        		 }	        			 
	       		  }    		    			               	      		      			          	           		    		  
	       	  }
	   	  }
	   	  else
	   	  {
	   		  if($scope.tipoMin != "categoria" && columna != 2)    			  
	   		     valor.srcElement.value = null;
	   	  }    		      	         		  
	   	  debugger	  	   	  
	   	  if(columna < 3 && $('#box').prop('checked'))	   	  
	   	  {
	   		  if(columna == 2)
	   		     $scope.tablaRevenueBoxLib.datos[fila][columna].valor = valor.srcElement.value;
	   		  else
	   			 $scope.tablaRevenueBoxLib.datos[fila][columna].valor = valNum;
	   	  }
	  };
	  
	  $scope.actualizarImpCelda = function(fila, columna, valor){		  
    	  if(valor.srcElement.checked)
    		 $scope.tablaImpuestosLib.datos[fila][columna].valor = 'true';
    	  else
    		 $scope.tablaImpuestosLib.datos[fila][columna].valor = 'false';
	  };
	  
	  $scope.actualizarPrecioCelda = function(fila, columna, valor){			
		  var valClean =  $filter('numDigNormal')(valor.srcElement.value);		  
    	  if(!isNaN(valClean) && parseFloat(valClean) > 0)
    	  {
    		  if(valClean == "")			  
 				 $scope.tablaPreciosLib.datos[fila][columna].valor = null;    		  
    		  else if(columna % 2 == 0)
        	  {        		      			
        		 $scope.tablaPreciosLib.datos[fila][columna].valor = $filter('numDigMoneda')(valor.srcElement.value,4); 
        		 $scope.tablaPreciosLib.datos[fila][columna-1].valor = null;        		        			 
        	  }    		    	
    		  else
    		  {
    			 $scope.tablaPreciosLib.datos[fila][columna].valor = $filter('numDigMoneda')(valor.srcElement.value,4); 
         		 $scope.tablaPreciosLib.datos[fila][columna+1].valor = null;
    		  }
    	  }
    	  else    	      		        	  
    		valor.srcElement.value = null;    		    	                                
	  };	
	  
	  $scope.actualizarRevenueCelda = function(fila, columna, valor, metadatos){		      	  
		  var valClean =  $filter('numDigNormal')(valor.srcElement.value);
   	      var resto    = 0;
   	     	      
	   	  if(!isNaN(valClean) && valClean != "")
	   	  {
	   		  if(valClean > 100 || valClean < 0)
	   	    	valClean = 0;
	   	      else
	   	    	resto = 100 - valClean;  
	   		  
	   		  valor.srcElement.value = $filter('numDigMoneda')(String(valClean),2);
	   		  $scope.tablaRevenueLib.datos[fila][columna+1].valor = $filter('numDigMoneda')(String(resto),2);
	   	  }	   	 	   	     	  	   	      	      	      		      	                  		      	        		    		      	    	      	
	  };
	 	  
	  $scope.actualizarRevenueBoxCelda = function(fila, columna, valor, metadatos){		      	  		  		  
		  var valClean =  $filter('numDigNormal')(valor.srcElement.value);
   	      	  
		  if(columna == 3)
		  {
			  var resto    = 0;		   	  
		   	  if(!isNaN(valClean) && valClean != "")
		   	  {
		   		  if(valClean > 100 || valClean < 0)
		   	    	valClean = 0;
		   	      else
		   	    	resto = 100 - valClean;  
		   		  
		   		  valor.srcElement.value = $filter('numDigMoneda')(String(valClean),2);
		   		  $scope.tablaRevenueBoxLib.datos[fila][columna+1].valor = $filter('numDigMoneda')(String(resto),2);
		   	  }		   	 		   	  		   	    
		  }		
		  else if(columna <= 1)
		  {
			  if(!isNaN(valClean) && valClean != "" && parseFloat(valClean) > 0)		   	  
				  valor.srcElement.value = $filter('number')(valClean);		   	  
		   	  else		   	  
		   		  valor.srcElement.value = null;			  			  			  
		  }
	  };
	
	  $scope.actualizarGlobal = function(){
		  $scope.tablaRevenueBoxLib.datos   = [];
		  $scope.tablaRevenueBoxLib.datos.push([{"valor":null,"editable":true},{"valor":null,"editable":true},{"valor":null,"editable":true},{"valor":null,"editable":true},{"valor":null,"editable":true}] );
	  };
		 
	  $scope.actualizarBox = function(){		  
		            
		  $scope.tablaRevenueLib.datos  = [[{"valor":null},{"valor":null}]];
		  if($scope.tablaRevenueBoxLib.datos.length > 0)
		  {
			  var temp = $scope.tablaRevenueBoxLib.datos;
			  			  		 			 
			  if(temp.length == 1 && temp[0][0].valor == null  && temp[0][1].valor == null && 
			     temp[0][2].valor == null  && temp[0][3].valor == null  && temp[0][4].valor == null )
				 temp = [];
				  			  
			  $scope.tablaRevenueBoxLib.datos = [];
			  if($scope.tipoMinLib == "categoria")
			  {				  
				  for(var i=0; i<$scope.tablaMinGarLib.datos.length; i++)
				  {
					  var fila = [];
					  for(var j=0; j<=2; j++)
					  {
						  fila.push({"valor" : $scope.tablaMinGarLib.datos[i][j].valor, "editable":false});				  
					  }  
					  
					  var indice = null;
					  for(var k=0; k<temp.length; k++)
					  {
						  if(temp[k][2].valor == $scope.tablaMinGarLib.datos[i][2].valor)
							 indice = k; 
					  }
					  if(indice != null)
					  {
						  fila.push({"valor" : temp[indice][3].valor, "editable":false});
						  fila.push({"valor" : temp[indice][4].valor, "editable":false});  
						  temp.splice(indice, 1);
					  }
					  else
					  {
						  fila.push({"valor" : null, "editable":false});
						  fila.push({"valor" : null, "editable":false});
					  }
					  
					  $scope.tablaRevenueBoxLib.datos.push(fila);
				  }	
			  }			  
			  
			  for(var i=0; i<temp.length; i++)
			  {
				  var fila = [];
				  for(var j=0; j<temp[0].length; j++)				  					  
					  fila.push({"valor" : temp[i][j].valor, "editable":temp[i][j].editable});				  				  
				  $scope.tablaRevenueBoxLib.datos.push(fila);
			  }			  			  			  
		  }
		  else
		  {
			  if($scope.tipoMinLib == "categoria")
			  {				  
				  for(var i=0; i<$scope.tablaMinGarLib.datos.length; i++)
				  {
					  var fila = [];
					  for(var j=0; j<=2; j++)
					  {
						  fila.push({"valor" : $scope.tablaMinGarLib.datos[i][j].valor, "editable":false});				  
					  }  
					  fila.push({"valor" : null, "editable":false});
					  fila.push({"valor" : null, "editable":false});
					  $scope.tablaRevenueBoxLib.datos.push(fila);
				  }   
			  }			   
		  }
		  
		  if($scope.tablaRevenueBoxLib.datos.length == 0)
			  $scope.tablaRevenueBoxLib.datos.push([{"valor":null,"editable":true},{"valor":null,"editable":true},{"valor":null,"editable":true},{"valor":null,"editable":true},{"valor":null,"editable":true}] );
	 };
	
	 $scope.mostrarRevenue = function(){
		 this.inicializarDivMinimos();
		 if($scope.tipoMinLib == "categoria")
		 {
			 $("#dbox").show();
			 $("#tRevBox").show();
		 }			 
		 else
		 {			 
			 $("#dbox").hide();
			 $("#tRevBox").hide();
		 }			 
	 };
	 
	 $scope.guardarLibreria = function(){		  		     
	     var continuar = true;	     		  	 	     	     
	     //Se validan campos vacios
	     if($scope.tipoMinLib == "categoria")
	     {
	    	 $scope.tablaMinGarLib.datos[0][0].valor = 1;
	    	 $scope.tablaMinGarLib.datos[0][1].valor = 1;	    	 
	    	 $scope.tablaMinGarLib = feesValidateService.validarCeldasVacias($scope.tablaMinGarLib, $scope.tablaMinGarLib.datos[0].length, true);
	    	 continuar = feesValidateService.mensajeValidacion($scope.tablaMinGarLib.valida, $scope.tablaMinGarLib.nombre, "");	    	 
	    	 $scope.tablaMinGarLib.datos[0][0].valor = null;
	    	 $scope.tablaMinGarLib.datos[0][1].valor = null;
	     }
	     else
	     {
	    	 $scope.tablaMinGarAnioLib = feesValidateService.validarCeldasVacias($scope.tablaMinGarAnioLib, $scope.tablaMinGarAnioLib.datos[0].length, true);
	    	 continuar = feesValidateService.mensajeValidacion($scope.tablaMinGarAnioLib.valida, $scope.tablaMinGarAnioLib.nombre, "");
	     }
	     	     
	     if(continuar)
	     {
	    	 if($scope.tipoRevenue == "box")
	    	 {
	    		 if($scope.tipoMinLib == "categoria")
		    	 {
		    		 $scope.tablaRevenueBoxLib.datos[0][0].valor = 1;
			    	 $scope.tablaRevenueBoxLib.datos[0][1].valor = 1;	    	 
			    	 $scope.tablaRevenueBoxLib = feesValidateService.validarCeldasVacias($scope.tablaRevenueBoxLib, 3, true);
			    	 continuar = feesValidateService.mensajeValidacion($scope.tablaRevenueBoxLib.valida, $scope.tablaRevenueBoxLib.nombre, "");	    	 
			    	 $scope.tablaRevenueBoxLib.datos[0][0].valor = null;
			    	 $scope.tablaRevenueBoxLib.datos[0][1].valor = null;	 
		    	 }
		    	 else
		    	 {		    		 
		    		 if($scope.tablaRevenueBoxLib.datos[0][2].valor === "MFTV/MFV")
		    		 {
		    			 $scope.tablaRevenueBoxLib.datos[0][0].valor = 1;
				    	 $scope.tablaRevenueBoxLib.datos[0][1].valor = 1;	 
		    		 }		    		 	    	 			    	 			    	 
		    		 $scope.tablaRevenueBoxLib = feesValidateService.validarCeldasVacias($scope.tablaRevenueBoxLib, 3, true);
			    	 continuar = feesValidateService.mensajeValidacion($scope.tablaRevenueBoxLib.valida, $scope.tablaRevenueBoxLib.nombre, "");
			    	 
			    	 if($scope.tablaRevenueBoxLib.datos[0][2].valor === "MFTV/MFV")
		    		 {
			    		 $scope.tablaRevenueBoxLib.datos[0][0].valor = null;
				    	 $scope.tablaRevenueBoxLib.datos[0][1].valor = null;
		    		 }
		    	 }	 
	    	 }	    	 	    	 
	     }
	     	     	     		  	 
	     //Se valida longitud categorias		      
	     if(continuar)
	     {
	    	 if($scope.tipoMinLib == "categoria")
		     {
		    	 $scope.tablaMinGarLib = feesValidateService.validarLongitudCeldas($scope.tablaMinGarLib, null, null, [2]);
		    	 continuar = feesValidateService.mensajeValidacion($scope.tablaMinGarLib.valida, $scope.tablaMinGarLib.nombre, "");
		     }
	     }
	     
	     if(continuar)
	     {		    	 
		   	 $scope.tablaRevenueBoxLib = feesValidateService.validarLongitudCeldas($scope.tablaRevenueBoxLib, null, null, [2]);
		   	 continuar = feesValidateService.mensajeValidacion($scope.tablaRevenueBoxLib.valida, $scope.tablaRevenueBoxLib.nombre, "");			  
	     }
	     
	     //Se validan categorias repetidas
	     if(continuar)
	     {
	    	 if($scope.tipoMinLib == "categoria")
		     {
		    	 $scope.tablaMinGarLib = feesValidateService.validarCategoriasRepetidas($scope.tablaMinGarLib, 2);
		    	 continuar = feesValidateService.mensajeValidacion($scope.tablaMinGarLib.valida, $scope.tablaMinGarLib.nombre, ", existen categor\u00EDas repetidas");
		     }
	     }
	     
	     if(continuar)
	     {
	    	 $scope.tablaRevenueBoxLib = feesValidateService.validarCategoriasRepetidas($scope.tablaRevenueBoxLib, 2);
		     continuar = feesValidateService.mensajeValidacion($scope.tablaRevenueBoxLib.valida, $scope.tablaRevenueBoxLib.nombre, ", existen categor\u00EDas repetidas");			    
	     }	     		     
	     
	     //Se validan rangos		     
	     if(continuar)
	     {
	    	 if($scope.tipoMinLib == "categoria")
		     {
		    	 $scope.tablaMinGarLib = feesValidateService.validarRangosTablas($scope.tablaMinGarLib, 0 ,1, 1);
		    	 continuar = feesValidateService.mensajeValidacion($scope.tablaMinGarLib.valida, $scope.tablaMinGarLib.nombre, "");
		     }	
	     }
	     
	     if(continuar)
	     {
	         $scope.tablaRevenueBoxLib = feesValidateService.validarRangosTablas($scope.tablaRevenueBoxLib, 0 ,1, 1);
		     continuar = feesValidateService.mensajeValidacion($scope.tablaRevenueBoxLib.valida, $scope.tablaRevenueBoxLib.nombre, "");			    	
	     }
	    
	     //Se validan valores moneda		     
	     if(continuar)
	     {	    	  	
			  var indicePais = 0;
			  var fila       = 0;
			  for(var j=1; j<$scope.tablaPreciosLib.datos[0].length; j+=2)
			  {			  						  				  
				  $scope.tablaDtoSeries = feesValidateService.validarValoresMonedaTablas($scope.tablaPreciosLib, 0 , 2, j, 3);
					  
				  var pais    = $scope.tablaPreciosLib.encabezados[indicePais].valor;
				  var mensaje = ". Falta registrar campos en el pa\u00EDs "+pais + ".";
				  continuar   = feesValidateService.mensajeValidacion($scope.tablaPreciosLib.valida, $scope.tablaPreciosLib.nombre, mensaje);				  				  				  				  				  	
				  
				  indicePais++;
				  if(!continuar) break;
			  }			    	 	 	    	 	 
	     }

	     //Se validan porcentajes en tablas
	     if(continuar)
	     {
	    	 if($scope.tipoRevenue == "box")
	    	 {
	    		 $scope.tablaRevenueBoxLib = feesValidateService.validarTablasPorcentaje($scope.tablaRevenueBoxLib, 3);
			     continuar = feesValidateService.mensajeValidacion($scope.tablaRevenueBoxLib.valida, $scope.tablaRevenueBoxLib.nombre, ", no se ha registrado campos porcentaje.");
	    	 }
	    	 else
	    	 {
	    		 $scope.tablaRevenueLib = feesValidateService.validarTablasPorcentaje($scope.tablaRevenueLib, 0);
			     continuar = feesValidateService.mensajeValidacion($scope.tablaRevenueLib.valida, $scope.tablaRevenueLib.nombre, ", no se ha registrado campos porcentaje.");
	    	 }	    	 	 
	     }
	     
	     if (continuar)
	     {
	    	 if(!$('#global').prop('checked') && !$('#box').prop('checked') )
	    	 {
	    		 continuar = false;
	    		 showError("Se debe seleccionar un tipo de Revenue.");
	    	 }	    		 	    	 
	     }
	     
	     if (continuar)
		 {	    	 	    	 
			var periodos = [];
			if ($scope.tipoMinLib == "categoria") 
			{				
					$("#tabMinCatLib thead tr th").each(function(index) {						
						if(index > 1 && $(this).text() != "")
						{
							console.log($(this).text())
							var fechas = $(this).text().split("-");
							if(fechas.length == 2)
							   periodos.push({fechaInicio: fechas[0], fechaFin: fechas[1]})						
						}					   
					});					
			}
			else 
			{				
					$("#tabAnioMinLib thead tr th").each(function() {
						var fechas = $(this).text().split("-");
						if(fechas.length == 2)
						   periodos.push({fechaInicio: fechas[0], fechaFin: fechas[1]})
					});					
			}

			var valido = rentaLibreriaService.validarFechasPeriodos(periodos);
			continuar  = valido.validacion;
			if(!valido.validacion)
			   showError(valido.mensaje);
						
			if(continuar)
			{
			   if( ($.datepicker.parseDate( 'mm/dd/yy',  $("#fechaInicioCto").val()).getTime() > $.datepicker.parseDate( 'mm/dd/yy',  periodos[0].fechaInicio).getTime()) ||  	    
				   ($.datepicker.parseDate( 'mm/dd/yy',  $("#fechaFinCto").val()).getTime()    < $.datepicker.parseDate( 'mm/dd/yy',  periodos[periodos.length-1].fechaFin).getTime()) )
			   {
				   continuar = false;
				   showError("El rango de fecha del periodo no est\u00E1 en el rango de tiempo del contrato.");
			   }			      		 
			}
		}
	     
	    if (continuar)
		{
			if($("#tipoCambio").val() == "0")
			{
				showError("Se debe seleccionar un valor para Tipo de Cambio.");
				continuar = false;
			}
		}
	    
	    if(continuar)
	    {	
	    	 var fees = { 	    		  					    
				  "minimos"       : null,
				  "minimosAnio"   : null,				
				  "impuestos"     : null,
				  "revenue"       : null,
				  "revenueB"      : null,
				  "precio"        : null,
				  "idCatMin"      : null,
				  "aniosMin"      : null,
				  "idCatEli"      : null,
				  "revenueGlobal" : null,
	    	      "revenueBox"    : null
             }
	    	 	    	 
		     if($scope.tipoMinLib == "categoria")
		     {		    	 
		    	 fees.minimos   = rentaLibreriaService.crearMatriz($scope.tablaMinGarLib);
		    	 fees.idCatMin  = $scope.idsCatLib;
		    	 fees.aniosMin  = [];
				 $("#tabMinCatLib thead tr th").each(function(index) {
				   	 if(index > 1)
					 {
						fees.aniosMin.push($(this).text())						
					}						  
				  });
				  fees.idCatEli = $scope.idCatEliLib;			    	 
		     }
		     else
		     {
		    	 fees.minimosAnio = rentaLibreriaService.crearMatriz($scope.tablaMinGarAnioLib);
		    	 fees.aniosMin    = [ ];
				 $("#tabAnioMinLib thead tr th").each(function() {
				  	fees.aniosMin.push($(this).text())
				 });
		     }
	    	 	    	 
	    	 fees.impuestos = rentaLibreriaService.crearMatriz($scope.tablaImpuestosLib);
	    	 fees.precio    = rentaLibreriaService.crearMatriz($scope.tablaPreciosLib);
	    	 
	    	 if($('#global').prop('checked'))
	    	 {
	    		 fees.revenue       = rentaLibreriaService.crearMatriz($scope.tablaRevenueLib);
	    		 fees.revenueGlobal =  true;	    	      
	    	 }
	    	 if($('#box').prop('checked'))
	    	 {
	    		 fees.revenueB   = rentaLibreriaService.crearMatriz($scope.tablaRevenueBoxLib);
	    		 fees.revenueBox = true;
	    	 }	    	 	    	 
	    		 
	    	 var idCto        = $("#idCto").val();
			 var idTipoCambio = $("#tipoCambio").val();
				
	    	 rentaLibreriaService.guardarLibreria(fees, idCto, idTipoCambio).then(function(data){				   
		    	    if(data.error != null)
					   showError(data.error);
		    	    else
		    	    {
		    	    	showMessage("Se han guardado los datos de la seccion Librer\u00EDa.");
		    	    	rentaLibreriaService.inicializarTablasLibreria().then(function(data){		 		    	   		   
		    	   		   $scope.inicializar(data);
		    	   	 	});
		    	    }			    	    	
			  });
	     }
	 };
	 
	 $scope.abrirModalFechas = function(tipo, columna, operacion) {
			if(operacion == "periodo")
			{	
				$("#aceptarPerLib").hide();
				$("#addPerLib").show();
				$("#fechaPerInicioLib").val("");
				$("#fechaPerFinLib")   .val("");
				$("#modificarPeriodoLib").modal("show");
			}
			else
			{
				tipo = parseInt(tipo);
				$("#aceptarPerLib").show();
				$("#addPerLib").hide();
				if (tipo == 1) 
				{
					if (parseInt(columna) > 1) 
					{
						var fechas = $("#tabMinCatLib").find("thead tr th:nth-child(" + (columna + 1) + ")").text().split("-");
						$("#fechaPerInicioLib").val(fechas[0]);
						$("#fechaPerFinLib").val(fechas[1]);
						$("#modificarPeriodoLib").modal("show");
					}
				}
				if (tipo == 2) 
				{
					var fechas = $("#tabAnioMinLib").find("thead tr th:nth-child(" + (columna + 1) + ")").text().split("-");
					$("#fechaPerInicioLib").val(fechas[0]);
					$("#fechaPerFinLib").val(fechas[1]);
					$("#modificarPeriodoLib").modal("show");
				}
				$("#modificarPeriodoLib").find("input[id='tipo']").val(tipo);
				$("#modificarPeriodoLib").find("input[id='columna']").val(columna);

		    }
	 };

	 $scope.actualizarPorFechas = function() {
			var tipo = parseInt($("#modificarPeriodoLib").find("input[id='tipo']").val());
			var col  = parseInt($("#modificarPeriodoLib").find("input[id='columna']").val());
			var id   = tipo == 1 ? "tabMinCatLib" : "tabAnioMinLib";

			var fecha = $("#fechaPerInicioLib").val() + "-" + $("#fechaPerFinLib").val();
			$("#" + id).find("thead tr th:nth-child(" + (col + 1) + ")").text(fecha);
			$("#modificarPeriodoLib").modal("hide");
	  };
	 	 	 	 	 	 	
	  $scope.agregarNuevoPeriodo = function() {
			
			if($("#fechaPerInicioLib").val() == "" || $("#fechaPerFinLib").val() == "")		
			   $("#labErroPer").text("No se han ingresado las fechas del periodo").show();
			else
			{
				var encabezado = $("#fechaPerInicioLib").val() +"-" +$("#fechaPerFinLib").val();
					
				if($scope.tipoMinLib == "categoria")			
				   this.editarTablaMinGarantizados("addColumn",null, encabezado);	
				
				else if($scope.tipoMinLib == "anio")
					this.editarTablaMinGarantizadosAnio("addColumn",null, encabezado) ;
							
				$("#modificarPeriodoLib").modal("hide");	
			}			
		};
	  	 
		//funciones para importar exceles
		$scope.abrirModalCarga = function(){
			  uploaderLib.limpiaForma("idFormCargaAlgoLib");
			  $("#esperaDivLib").html("");
			  $("#modalImportarArchivoLib").modal("show");		   
		};
		  
		$scope.cargarDatos = function(){		  
			  uploaderLib.startUpload("cargaFeesDivLib");		   
	    };
		  
		$scope.verificarDatos = function() {
			$('#modalImportarArchivoLib').modal('hide');			
			if (datosSubirLib != null && datosSubirLib.datosMatriz != null) 
			{			
				if(uploaderLib.tipoFees == "libreria" && uploaderLib.operacion == "minimos")			
				   this.importarMinimos(datosSubirLib.datosMatriz);				
				if(uploaderLib.tipoFees == "libreria" && uploaderLib.operacion == "precio")
				   this.importarPrecio(datosSubirLib.datosMatriz);						
			}
		};
		
		$scope.verifcarFilaVacia = function(data) {		
			var cont = 0;
			
			for(var i=0; i<data.fila.length; i++)
			{
				if(data.fila[i] === "" || data.fila[i] == null)
				   cont++
			}
			
			if(cont == data.fila.length)
				return true;
			else
				return false;
		};
		
		$scope.abrirModalMinimos = function() {
			uploaderLib = new UploaderEX("cargaFeesDivLib");
			uploaderLib.tipoFees  = "libreria";
			uploaderLib.operacion = "minimos";
			this.abrirModalCarga();
		};
		
		$scope.importarMinimos = function(data) {		
			data.splice(0, 1);
			
			for(var i=0; i<data.length; i++)
			{
				if(!this.verifcarFilaVacia(data[i]))
				{
					var encontrado = false;
					for(var j=0; j<$scope.tablaMinGarLib.datos.length; j++)
					{										
						if($scope.tablaMinGarLib.datos[j][2].valor == data[i].fila[2])
						{
							$scope.tablaMinGarLib.datos[j][0].valor = data[i].fila[0];
							$scope.tablaMinGarLib.datos[j][1].valor = data[i].fila[1];
							
							var numCol = data[i].fila.length < $scope.tablaMinGarLib.datos[j].length ? data[i].fila.length :  $scope.tablaMinGarLib.datos[j].length;
							
							for(var k= 3; k< numCol; k++)
								$scope.tablaMinGarLib.datos[j][k].valor = data[i].fila[k];
							encontrado = true;
						}					 
					}
					
					if(!encontrado)
					{
						this.editarTablaMinGarantizados("addRow",null,null);
						var numCol = data[i].fila.length < $scope.tablaMinGarLib.datos[0].length ? data[i].fila.length :  $scope.tablaMinGarLib.datos[0].length;
											
						$scope.tablaMinGarLib.datos[$scope.tablaMinGarLib.datos.length-1][0].valor = data[i].fila[0];
						$scope.tablaMinGarLib.datos[$scope.tablaMinGarLib.datos.length-1][1].valor = data[i].fila[1];
						$scope.tablaMinGarLib.datos[$scope.tablaMinGarLib.datos.length-1][2].valor = data[i].fila[2];
																			
						for(var k= 3; k< numCol; k++)
							$scope.tablaMinGarLib.datos[$scope.tablaMinGarLib.datos.length-1][k].valor = data[i].fila[k];																	 					
					}
				}
			}
		};
										
		$scope.abrirModalPrecio = function() {
			uploaderLib = new UploaderEX("cargaFeesDivLib");
			uploaderLib.tipoFees  = "libreria";
			uploaderLib.operacion = "precio";
			this.abrirModalCarga();
		};
		
		$scope.importarPrecio = function(data) {		
			data.splice(0, 2);		
			for(var i=0; i<$scope.tablaPreciosLib.datos.length; i++)		
				for(var j=0; j<$scope.tablaPreciosLib.datos[0].length; j++)				
					$scope.tablaPreciosLib.datos[i][j].valor = data[i].fila[j];		
		};
											
		//funcion para exportar excel
		$scope.exportarExcel = function(seccion, operacion, datos, encabezados) {
						
			datos   = rentaLibreriaService.crearMatriz(datos);		
			var enc = [];
			
			if(operacion == "min_cat")
			{
			   enc[0] = encabezados[0].valor;
			   enc[1] = "";
			   for(var i=1; i<encabezados.length;i++)
				   enc[i+1] = encabezados[i].valor;	
			}
			else if(operacion == "min_anio")
			{				
				$( "#tabAnioMinLib thead tr" ).find("th").each(function() {
					  enc.push($(this).text());
				});		   	
				enc.splice(enc.length-1,1);				
			}			
			else if(operacion == "precio")
			{
				var temp = datos;
				var fila = [];				
				fila.push("Formato");
				
				for(var i=0; i<(datos[0].length-2)/2;i++)
				{
					fila.push("ML");
				    fila.push("Dolares");
				}
				
				var datos1 = [];
				datos1.push(fila);
				
				for(var i=0; i<temp.length;i++)
					datos1.push(temp[i]);
				datos = datos1;	
				
				enc[0] = "Precio por evento";				
				for(var i=0; i<encabezados.length;i++)
				{
					enc.push(encabezados[i].valor);
					enc.push("");
				}
				    
			}
			
			rentaLibreriaService.descargarArchivo(seccion, operacion, $("#idCto").val(), datos, enc).then(function(data) { console.log(data) });				
   	  };
	  
	  $scope.setColspan = function(x){
		   return x.colspan;    		
	 };
};

registraController("rentaLibreriaController", rentaLibreriaController);