package com.mx.dla.dda.ncredito;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.Test;



import com.mx.dla.dda.common.test.BaseDaoTest;
import com.mx.dla.dda.ncredito.general.daos.NotaCreditoDAO;
import com.mx.dla.dda.ncredito.general.dtos.ContratoTitulo;
import com.mx.dla.dda.ncredito.general.dtos.NotaCredito;
import com.mx.dla.dda.ncredito.general.dtos.NotaCreditoDetalle;

public class NotaCreditoTest extends BaseDaoTest {

	@Autowired
	private NotaCreditoDAO notaCreditoDAO;

	@Test(enabled = false)
	public void consultaTitulosBajaDisponiblesTest() {
		Long idEstudio = 1L;
		List<ContratoTitulo> datos = notaCreditoDAO.consultaTitulosBajaDisponibles(idEstudio);
		logger.info("{}", datos);
	}
	
	@Test(enabled = false)
	public void consultaTitulosBajaUtilizadasTest() {
		Long idEstudio = 1L;
		Long idNota = 0L;

		List<ContratoTitulo> datos = notaCreditoDAO.consultaTitulosBajaUtilizados(idEstudio, idNota);
		logger.info("{}", datos);
	}

	@Test(enabled = false)
	public void consultaTitulosDisminucionDisponiblesTest() {
		Long idContrato = 1L;

		List<ContratoTitulo> datos = notaCreditoDAO.consultaTitulosDisminucionDisponibles(idContrato);
		logger.info("{}", datos);
	}

	@Test(enabled = false)
	public void consultaNotaCreditoGeneralTest() {
		Long idNota = null;
		List <Long> estudios =  new ArrayList<Long>() ;
		estudios.add(4L);
		String noFactura = null;

		List<NotaCredito> datos = notaCreditoDAO.consultaNotaCreditoGeneral(4L, null, noFactura);
		logger.info("{}", datos);
	}

	@Test(enabled = false)
	public void consultaNotaCreditoDetalleTest() {
		
		//3	2	20	83377
		Long idNotaDetalle = null;
		Long idNota = 2L;
		Long idContrato = 20L;
		Long idTituloCnt = 83377L;

		List<NotaCreditoDetalle> datos = notaCreditoDAO.consultaNotaCreditoDetalle(idNotaDetalle, idNota, idContrato, idTituloCnt);
		logger.info("{}", datos);
	}

	@Test(enabled = false)
	public void guardarNotaCreditoTest() {

		// Long idNota = 1L;
		Long idEstudio = 7L;
		String noFactura = "F4";
		Date fecha = new Date();
		Integer approved = 1;
		String idSapRegistro = "S1";
		String comentario = "C1";
		
		//20, 21, 10
		//1, 13, 7   Estudios
		//83377,83378    88323,88325  93326

		NotaCredito notaCredito = new NotaCredito();
		notaCredito.setNoFactura(noFactura);
		notaCredito.setApproved(approved);
		notaCredito.setComentario(comentario);
		notaCredito.setFecha(fecha);
		notaCredito.setIdEstudio(idEstudio);
		notaCredito.setIdSapRegistro(idSapRegistro);
		notaCreditoDAO.guardarNotaCredito(notaCredito);

	}

	@Test(enabled = false)
	public void actualizarNotaCreditoTest() {

		Long idNota = 1L;
		Long idEstudio = 1L;
		String noFactura = "F1";
		Date fecha = new Date();
		Integer approved = 1;
		String idSapRegistro = "S1";
		String comentario = "Actaulizado";

		NotaCredito notaCredito = new NotaCredito();
		notaCredito.setIdNota(idNota);
		notaCredito.setNoFactura(noFactura);
		notaCredito.setApproved(approved);
		notaCredito.setComentario(comentario);
		notaCredito.setFecha(fecha);
		notaCredito.setIdEstudio(idEstudio);
		notaCredito.setIdSapRegistro(idSapRegistro);
		notaCreditoDAO.actualizarNotaCredito(notaCredito);

	}

	@Test(enabled = false)
	public void eliminarNotaCreditoTest() {

		Long idNota = 1L;
		Long idEstudio = 1L;
		String noFactura = "F1";
		Date fecha = new Date();
		Integer approved = 1;
		String idSapRegistro = "S1";
		String comentario = "C1";

		NotaCredito notaCredito = new NotaCredito();
		notaCredito.setIdNota(idNota);
		notaCredito.setNoFactura(noFactura);
		notaCredito.setApproved(approved);
		notaCredito.setComentario(comentario);
		notaCredito.setFecha(fecha);
		notaCredito.setIdEstudio(idEstudio);
		notaCredito.setIdSapRegistro(idSapRegistro);
		notaCreditoDAO.eliminarNotaCredito(notaCredito);

	}

	@Test(enabled = false)
	public void guardarNotaCreditoDetalleTest() {

		Long idNota = 2L;
		Long idContrato = 20L;
		Long idTituloCnt = 83377L;
		String monto = "444";

		NotaCreditoDetalle notaCreditoDetalle = new NotaCreditoDetalle();
		notaCreditoDetalle.setIdContrato(idContrato);
		notaCreditoDetalle.setIdNota(idNota);
		notaCreditoDetalle.setIdTituloCnt(idTituloCnt);
		notaCreditoDetalle.setMonto(monto);

		notaCreditoDAO.guardarNotaCreditoDetalle(notaCreditoDetalle);

	}

	@Test(enabled = false)
	public void actualizarNotaCreditoDetalleTest() {

		Long idNotaDetalle = 2L;
		Long idNota = 1L;
		Long idContrato = 1L;
		Long idTituloCnt = 1L;
		String monto = "9876";

		NotaCreditoDetalle notaCreditoDetalle = new NotaCreditoDetalle();
		notaCreditoDetalle.setIdContrato(idContrato);
		notaCreditoDetalle.setIdNota(idNota);
		notaCreditoDetalle.setIdNotaDetalle(idNotaDetalle);
		notaCreditoDetalle.setIdTituloCnt(idTituloCnt);
		notaCreditoDetalle.setMonto(monto);

		notaCreditoDAO.actualizarNotaCreditoDetalle(notaCreditoDetalle);

	}

	@Test(enabled = false)
	public void eliminarNotaCreditoDetalleTest() {

		Long idNotaDetalle = 2L;
		Long idNota = 1L;
		Long idContrato = 1L;
		Long idTituloCnt = 1L;
		String monto = "444";

		NotaCredito notaCreditoDetalle = new NotaCredito();
		notaCreditoDetalle.setIdNota(idNota);

		notaCreditoDAO.eliminarNotaCreditoDetalle(notaCreditoDetalle);

	}

}
