package com.mx.dla.dda.contrato.titulo.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.common.constants.ContratoConstats;
import com.mx.dla.dda.contrato.titulo.bos.TituloAmortizacionBO;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.reporte.amortizacion.dtos.MesesAmortizacionDTO;

public class TituloAmortizacionGridAction extends BaseContratoAction {
		
	private static final long serialVersionUID = 1L;
	
	private List<MesesAmortizacionDTO> reporte;	
	private String error;
	private Integer anio;
	
	@Autowired
	private TituloAmortizacionBO tituloAmortizacionBO;
	
	public String reporte()
	{
	
		try {
			Lista li = (Lista) getSession().get( ContratoConstats.LISTA_SESSION);
			logger.debug("anio: "+ anio +" -- idContrato:"+ (Long)this.getSession().get("idContrato") + " idLista : " + li.getIdLista());
			reporte = tituloAmortizacionBO.amortizacionTitulos((Long)this.getSession().get("idContrato"), anio, li.getIdLista());							
		}catch (Exception e)
		{
			logger.error("Error :",e);
			setError("Ocurrio un error");
		}
		return SUCCESS;
	}
	
	public String getError() {
		return error;
	}
	public void setError(String error) {
		this.error = error;
	}

	public List<MesesAmortizacionDTO> getReporte() {
		return reporte;
	}

	public void setAnio(Integer anio) {
		this.anio = anio;
	}		
}
