package com.mx.dla.dda.contrato.transaccion.titulos.bos;

import java.util.ArrayList;
import java.util.List;

import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.enums.TransaccionesTituloTypes;
import com.mx.dla.dda.contrato.transaccion.titulos.dtos.TituloTransDB;
import com.mx.dla.dda.contrato.transaccion.titulos.dtos.TituloTransaccionDTO;
import com.mx.dla.dda.general.utilerias.ListaUtilerias;
import com.mx.dla.global.bos.BaseBO;
import org.apache.commons.lang3.math.NumberUtils;

public class TituloTranUtil extends BaseBO{

	public static TituloTransDB TituloDTO2BD(TituloTransaccionDTO titulo, List<CatalogoDTO> filiales, List<CatalogoDTO> categorias, List<CatalogoDTO> generosA, List<CatalogoDTO> generosB, 
			                                                              List<CatalogoDTO> tiers, List<CatalogoDTO> categoriasSer){
		TituloTransDB bd = new TituloTransDB();
																																			
		bd.setIdTituloCnt   (titulo.getIdTituloCnt()    != null ? titulo.getIdTituloCnt()    : null);
		bd.setIdContrato    (titulo.getIdContrato()     != null ? titulo.getIdContrato()     : null);
		bd.setIdLista       (titulo.getIdLista()        != null ? titulo.getIdLista()        : null);				
		bd.setIdBv          (titulo.getIdBv()           != null ? titulo.getIdBv()           : null);
		bd.setNombreUnico   (titulo.getNombreUnico()    != null ? titulo.getNombreUnico()    : null);
		bd.setNombreEstandar(titulo.getNombreEstandar() != null ? titulo.getNombreEstandar() : null);						
		bd.setIdFilial      (titulo.getFilial()         != null ? getValorCatalogo(filiales, titulo.getFilial()) : null);
		bd.setIdCategoria   (titulo.getCategoria()      != null ? getValorCatalogo(categorias, titulo.getCategoria()) : null);
		bd.setIdTier        (titulo.getTier()           != null ? getValorCatalogo(tiers,titulo.getTier())            : null);
		bd.setIdGeneroA     (titulo.getGenero()         != null ? getValorCatalogo(generosA, titulo.getGenero())      : null);
		bd.setIdGeneroB     (titulo.getGeneroB()        != null ? getValorCatalogo(generosB, titulo.getGeneroB())     : null);
		bd.setIdCategoriaSerie(titulo.getCategoriaSerie() != null ? getValorCatalogo(categoriasSer,titulo.getCategoriaSerie()) : null);				
		bd.setTemporada     (titulo.getTemporada()      != null ? titulo.getTemporada()    : null);
		bd.setEpisodio      (titulo.getEpisodio()       != null ? titulo.getEpisodio()     : null);
		bd.setHvrd          (titulo.getHvrd()           != null ? titulo.getHvrd()         : null);
		bd.setFechaInicio   (titulo.getFechaInicio()    != null ? titulo.getFechaInicio()  : null);
		bd.setFechaFin      (titulo.getFechaFin()       != null ? titulo.getFechaFin()     : null);		
		bd.setCategoriaDTR  (titulo.getCategoriaDTR()   != null ? titulo.getCategoriaDTR() : null);				
		bd.setBriefcase     (titulo.getBriefcase()      != null && titulo.getBriefcase() ? 1 : 0);
		bd.setDtr           (titulo.getDtr()            != null && titulo.getDtr()       ? 1 : 0);
		bd.setDto           (titulo.getDto()            != null && titulo.getDto()       ? 1 : 0);
		bd.setFsd           (titulo.getSd()             != null && titulo.getSd()        ? 1 : 0);
		bd.setFhd           (titulo.getHd()             != null && titulo.getHd()        ? 1 : 0);
		bd.setF3d           (titulo.getTresd()          != null && titulo.getTresd()     ? 1 : 0);
		bd.setDuracion      (titulo.getDuracion()       != null ? String.valueOf(titulo.getDuracion()) : null);
		bd.setAnio          (titulo.getAnio()           != null ? String.valueOf(titulo.getAnio()): null);				
		bd.setIdSap         (titulo.getIdSap()          != null ? titulo.getIdSap() : null);		
		bd.setFechaNotiSap  (titulo.getFechaNotiSap()   != null ? titulo.getFechaNotiSap() : null);
		bd.setBoxOffice     (titulo.getBoxOffice()      != null ? String.valueOf(titulo.getBoxOffice()) : null);		
		bd.setTypeTitulo    (getTituloType(titulo));
		bd.setNombreEnIngles(titulo.getNombreEnIngles()   != null ? titulo.getNombreEnIngles() : null);
		bd.setNombreEnEspaniol(titulo.getNombreEnEspaniol()   != null ? titulo.getNombreEnEspaniol() : null);
        bd.setNombreEnPortugues(titulo.getNombreEnPortugues()   != null ? titulo.getNombreEnPortugues() : null);
		
		return bd;
	}
	
	public static TituloTransaccionDTO TituloBD2DTO(TituloTransDB titulo){
		TituloTransaccionDTO dto = new TituloTransaccionDTO();
					
		dto.setIdTituloCnt   (titulo.getIdTituloCnt() != null ? titulo.getIdTituloCnt() : null);
		dto.setIdContrato    (titulo.getIdContrato()  != null ? titulo.getIdContrato()  : null);
		dto.setIdLista       (titulo.getIdLista()     != null ? titulo.getIdLista()     : null);
		dto.setFilial        (titulo.getFilialS()     != null ? titulo.getFilialS()     : null);
		dto.setIdBv          (titulo.getIdBv()        != null ? titulo.getIdBv()        : null);
		dto.setNombreUnico   (titulo.getNombreUnico() != null ? titulo.getNombreUnico() : null);
		dto.setNombreEstandar(titulo.getNombreEstandar() != null ? titulo.getNombreEstandar() :null);
		dto.setCategoria     (titulo.getCategoriaS()  != null ? titulo.getCategoriaS()  : null);
		dto.setTemporada     (titulo.getTemporada()   != null ? titulo.getTemporada()   : null);
		dto.setEpisodio      (titulo.getEpisodio()    != null ? titulo.getEpisodio()    : null);
		dto.setHvrd          (titulo.getHvrd()        != null ? titulo.getHvrd()        : null);
		dto.setFechaInicio   (titulo.getFechaInicio() != null ? titulo.getFechaInicio() : null);
		dto.setFechaFin      (titulo.getFechaFin()    != null ? titulo.getFechaFin()    : null);
		dto.setBoxOffice     (titulo.getBoxOffice()   != null && NumberUtils.isNumber(titulo.getBoxOffice()) ? Double.parseDouble((titulo.getBoxOffice())) : null);
		dto.setCategoriaDTR  (titulo.getCategoriaDTR()!= null ? titulo.getCategoriaDTR(): null);
		dto.setCategoriaSerie(titulo.getCatSerieS()   != null ? titulo.getCatSerieS()   : null);
		dto.setTier          (titulo.getTierS()       != null ? titulo.getTierS()       : null);
		dto.setBriefcase     (titulo.getBriefcase() != null && titulo.getBriefcase()  == 1 ? true : false);
		dto.setDtr           (titulo.getDtr()       != null && titulo.getDtr() == 1 ? true : false);
		dto.setDto           (titulo.getDto()       != null && titulo.getDto() == 1 ? true : false);
		dto.setSd            (titulo.getFsd()       != null && titulo.getFsd()  == 1 ? true : false);
		dto.setHd            (titulo.getFhd()       != null && titulo.getFhd() == 1 ? true : false);
		dto.setTresd         (titulo.getF3d()       != null && titulo.getF3d() == 1 ? true : false);
		dto.setDuracion      (titulo.getDuracion()  != null && NumberUtils.isDigits(titulo.getDuracion()) ? Integer.parseInt(titulo.getDuracion()) : null);
		dto.setAnio          (titulo.getAnio()      != null && NumberUtils.isDigits(titulo.getAnio()) ?  Integer.parseInt(titulo.getAnio()): null);		
		dto.setGenero        (titulo.getGeneroAS()  != null ? titulo.getGeneroAS() : null);
		dto.setGeneroB       (titulo.getGeneroBS()  != null ? titulo.getGeneroBS() : null);
		dto.setCategoriaDTO  (titulo.getCategoriaDTO() != null ? titulo.getCategoriaDTO() : null);
		dto.setAgrupable     (titulo.getAgrupable() != null ? titulo.getAgrupable() : null);
		dto.setNombreTotalSer(titulo.getNombreTotalSer() != null ? titulo.getNombreTotalSer() : null);
		dto.setNombreEnIngles(titulo.getNombreEnIngles()   != null ? titulo.getNombreEnIngles()   : null);
		dto.setNombreEnEspaniol(titulo.getNombreEnEspaniol()   != null ? titulo.getNombreEnEspaniol()   : null);
		dto.setNombreEnPortugues(titulo.getNombreEnPortugues()   != null ? titulo.getNombreEnPortugues()   : null);
		return dto;
	}
	
	public static List<TituloTransaccionDTO> TituloBD2DTO(List<TituloTransDB> titulos) {
		List<TituloTransaccionDTO> lista = new ArrayList<TituloTransaccionDTO>();
		for (TituloTransDB titulo : ListaUtilerias.safeList(titulos))
			lista.add(TituloBD2DTO(titulo));
		return lista;
	}

	public static Long getValorCatalogo( List<CatalogoDTO> catalogo, String valor){
		
		Long id = null;		
		for(CatalogoDTO c :catalogo)
		{
			if(c.getDesc().compareTo(valor) == 0)
			{
				id = new Long(c.getValue());
				break;
			}
		}
		return id;
	}
	
	public static String getTituloType(TituloTransaccionDTO titulo) {
		return (titulo.getCategoriaDTR() != null ? TransaccionesTituloTypes.get(titulo.getCategoriaDTR())
		        : titulo.getCategoriaSerie() != null ? TransaccionesTituloTypes.Series.getDesc() : titulo.getTier() != null ? TransaccionesTituloTypes.Tiers.getDesc() : null);
	}
	

}
