//Archivo que contiene la funcionalidad de flat   
function crearFlat(flat){	
	pintarDatosFlat(flat);	   
	llenarDatosFlat(flat);		
	bindingInputCategoriaFlat();
	bindingInputValores();	
}

function pintarDatosFlat(data){	    	    		
		var idPeriodo = data.datos[0].idContratoPago;
		var divPrincipal = $("<div/>").attr('id',"Contenedor"+idPeriodo).addClass("contenedor col-xs-11");				
		divPrincipal.append("<div><label class='mensajePer' style='color:red;'></label></div><br>");		
		divPrincipal.append($("<div/>").attr('id',"divPeriodo"+idPeriodo).addClass("row periodo").attr("divPer",idPeriodo));		
		divPrincipal.append(crearTablaFlat(idPeriodo, data.datos));		
		$("#divFlat").append(divPrincipal);
		if(idPeriodo <= 0)
		   $("#divFlat").find("div.contenedor:last").before(divPrincipal);
		$("table.tFlat thead").find("th:last").attr("style","background:white;").attr("width","50px;");
}

function crearTablaFlat(idPeriodo, data){
	var numCol = data.length;				
	var tabla  = tablaDinam.crearTabla("tabla" + idPeriodo, "tFlat");	
	
	var encabezados = [];
	encabezados.push({id:null, clase : '', colspan: 1, texto:'Categor\u00EDa',  html:''});
	
	for(var i=0; i<numCol; i++)
	{		
		var atributos = [];
		atributos.push({nombre: "onclick", valor: "modificarPeriodos(" + i + ")"});
		atributos.push({nombre : "idPer" , valor: data[i].idContratoPago});
		encabezados.push({id:i, clase : 'thPeriodo', colspan:1, texto: data[i].anioContrato+": "+data[i].fechaInicio +"-"+data[i].fechaFin,  html: "", atributos : atributos});
	}	
						
	var html = "";
	if(edoCto == 1)			
		html = "<label><span data-bs-toggle='tooltip' title='Agregar Categor\u00EDa' class='ui-icon ui-icon-plus' onclick='agregarFilaVaciaTablaFlat()'></span></label>";	
	encabezados.push({id:null, clase : 'thMin', colspan:1, texto: "",  html: html});
	
	tablaDinam.agregarFilaEncabezado(tabla, encabezados, 'encabezado');
	
	//Se agrega la fila eliminar periodos
	tabla.find("tbody").append($("<tr class='eliminarCol'/>").append($("<td id='0'/>")));
	return tablaDinam.envolverTabla("divTabla" + idPeriodo, tabla);
}


function llenarDatosFlat(data){	 	
	 var numCategorias = data.datos[0].flats.length;	 	 	 
	 
	 for(var j=0; j < numCategorias; j++)
	 {
		 var datos = [];
		 datos.push(createTdThTabla(1, data.datos[0].flats[j].descCategoria == null ? "" : data.datos[0].flats[j].descCategoria, true, null, 1));
		 		 
	     for(var i=0; i < data.datos.length; i++)	     	    	 	    	 
	    	 datos.push(createTdThTabla(1, data.datos[i].flats[j].anios[0].costo == null ? "" :   formatCurrency(Number(unformatCurrency(data.datos[i].flats[j].anios[0].costo)), 2), true, null, 1));	     	
	     agregarFilaTablaFlat(datos, data.datos[0].flats[j].idCategoria, data.datos[0].idContratoPago);
	 }
	 
	 //Se agrega fila eliminar periodo
	 var datos = [];
	 if(edoCto == 1)
	 {		 
		for(var i=0; i < data.datos.length; i++)				
			$("table.tFlat tbody tr.eliminarCol").append("<td id='"+data.datos[i].idContratoPago+"'><label class='mensaje'/><label><span data-bs-toggle='tooltip' title='Eliminar Periodo'  onclick='eliminarColumnaFlat("+ data.datos[i].idContratoPago +")'  class='ui-icon ui-icon-close'></span></label></td>");		
			
		if(data.datos.length > 0)
			$("table.tFlat tbody tr.eliminarCol").append("<td></td>");				  
	 }			 			 			 	 	 	 		 		
}

function agregarFilaTablaFlat(data, id, idPeriodo){		
	var atributos = [];
	
	if(edoCto == 1)
		data.push("<th><label class='mensaje'/><label><span data-bs-toggle='tooltip' title='Eliminar'  onclick='eliminarFila("+idPeriodo+","+ id +",1)'  class='ui-icon ui-icon-close'></span></label></th>");
	else
		data.push("<th></th>");
					
	atributos.push(["id", id]);		
	$("#tabla" + idPeriodo +" tbody").find("tr.eliminarCol").before(tablaDinam.crearFila("categoria", data, atributos));
	
	bindingInputCategoriaFlat();
	bindingInputValores();
}

function agregarNuevoPeriodoFlat(tipo, idPeriodo, inflacion, anioCto){	
	nuevaColumna--;
	var id    = ($("table.tFlat thead tr").find("th").length-2);	
	var fecha = anioCto + ": "+$("#iniAddPeriodo").val() + "-" + $("#finAddPeriodo").val();
	
	if(tipo == "VACIO") //se agrega periodo vacio
	{				
		$("table.tFlat thead tr").find("th:last").before(
				 $("<th/>").text(fecha).attr("id",id).attr("onclick", "modificarPeriodos("+id+")").attr("idPer", nuevaColumna)
				 .addClass("thPeriodo"));		
		$("table.tFlat tr.categoria").each(function(){							
			$(this).find("td:last").after(createTdThTabla(1, "", true, 0, 1).attr("nuevo",1));        			
		});
		$("table.tFlat tbody tr.eliminarCol").find("td:last").before("<td id='"+nuevaColumna+"'><label class='mensaje'/><label><span data-bs-toggle='tooltip' title='Eliminar Periodo'  onclick='eliminarColumnaFlat("+ nuevaColumna +")'  class='ui-icon ui-icon-close'></span></label></td>");
	}
	else
	{		
		$("table.tFlat thead tr").find("th:last").before($("<th/>").text(fecha).attr("id",id).attr("onclick", "modificarPeriodos("+id+")").attr("idPer", nuevaColumna)
				  .addClass("thPeriodo"));
		$("table.tFlat tr.categoria").each(function(){					
			var input = $(this).find("td:last input[type='text']").val();			
			var valor = input != "" ? formatCurrency(Number(unformatCurrency( calculaValorInflacion(unformatCurrency(input), inflacion) )), 2) : "";		
			$(this).find("td:last").after(createTdThTabla(1, valor, true, 0, 1).attr("nuevo",1));        			
		});
		$("table.tFlat tbody tr.eliminarCol").find("td:last").before("<td id='"+nuevaColumna+"'><label class='mensaje'/><label><span data-bs-toggle='tooltip' title='Eliminar Periodo'  onclick='eliminarColumnaFlat("+ nuevaColumna +")'  class='ui-icon ui-icon-close'></span></label></td>");
	}	
	
	var valorPrevio = $("#bonoInicio").val();
	$("#bonoInicio").empty();	
	$("table.tFlat thead tr.encabezado").find("th").each(function(){			
		if($(this).text().indexOf("-") > 0)
		{
			var opcion = '<option value="'+ $(this).text() +'">'+ $(this).text() +'</option>';
			$("#bonoInicio").append(opcion);
		}
	});
	$("#bonoInicio").val(valorPrevio);
	bindingInputCategoriaFlat();
	bindingInputValores();
	bindingInputValoresBono();	
}

function agregarFilaVaciaTablaFlat(){			
	var numCols     = $("table.tFlat thead tr").find("th").length-2; 		
	var idCategoria = nuevoCategoria--;	
	var atributos   = [];
	var datos       = [];
	var idPeriodo   = parseInt($("table.tFlat").attr("id").substr(5, $("table.tFlat").attr("id").length));
	atributos.push(["id", idCategoria]);
									
	datos.push(createTdThTabla(1, "", true, 0, 1));
			
	for(var i=0; i< numCols; i++)						
	    datos.push(createTdThTabla(1, "", true, 0, 1).attr("nuevo",1));
			
	if(edoCto == 1)
	   datos.push("<th><label class='mensaje'/><label><span data-bs-toggle='tooltip' title='Eliminar'  onclick='eliminarFila("+idPeriodo+","+idCategoria+",1)'  class='ui-icon ui-icon-close'></span></label></th>");
	else
	   datos.push("<th></th>");
			
	var fila = tablaDinam.crearFila("categoria", datos, atributos);																			
	$("table.tFlat tbody").find("tr.eliminarCol").before(fila); //Se agrega la nueva fila a cada tabla						
	
	bindingInputCategoriaFlat();
	bindingInputValores();
}

function modificarPeriodos(id){
	
	var fecha1 = $("table.tFlat").find("th[id='"+id+"']").text().split(":");
	var fecha = fecha1[1].trim().split("-");
	$("#modificarPeriodo").modal('show');
			
	if(fecha1 != null && fecha1.length >0)
		$("#editarFlatPeriodo").show();
	
	$("#idPerFecha").val(id);
	if(fecha.length == 2)
	{		
		$("#fechaPerInicio").val(fecha[0]);
		$("#fechaPerFin").val(fecha[1]);
		$("#anioEdContratoFlat").val(fecha1[0]);
	}
	else
	{
		$("#fechaPerInicio").val("");
		$("#fechaPerFin").val("");
	}	
	$("table.tFlat").find(".datepicker").datepicker( { dateFormat: 'mm/dd/yy' } );	
}

function actualizarPerFechas(){
	var id = $("#idPerFecha").val();	
	
	if($("#fechaPerFin").val() == "" || $("#fechaPerInicio").val() == "")
		$("#labErroPer").text("Falta registrar las fecha de inicio y fecha de termino.").show();
	else if($.datepicker.parseDate('mm/dd/yy',$("#fechaPerInicio").val()).getTime() >  $.datepicker.parseDate('mm/dd/yy',$("#fechaPerFin").val()   ).getTime())	
		$("#labErroPer").text("La fecha fin no puede ser menor a la fecha inicio.").show();		
	else if($("#fechaPerFin").val() == $("#fechaPerInicio").val())	
		$("#labErroPer").text("Ambas fechas son iguales.").show();
	else if(!verificarAniosContratosFlat($("#anioEdContratoFlat").val()))		
		$("#labErroPer").text("Verifica el campo a\u00F1o Contrato es obligatorio, \u00FAnico y debe ser n\u00FAmero entero de dos digitos entre 0 y 100.").show();
	else 
	{
		$("#labErroPer").hide();
		$("table.tFlat").find("th[id='"+id+"']").text(parseInt($("#anioEdContratoFlat").val()) +": "+$("#fechaPerInicio").val() +"-"+$("#fechaPerFin").val());
		$("#modificarPeriodo").modal('hide');
		
		$("#bonoInicio").empty();
		$("table.tFlat thead tr.encabezado").find("th").each(function(){			
			if($(this).text().indexOf("-") > 0)
			{
				var opcion = '<option value="'+ $(this).text() +'">'+ $(this).text() +'</option>';
				$("#bonoInicio").append(opcion);
			}
		});		
	}			
}

function mostrarDivFlat(){
	$("#optradioSusc").attr('checked', false);
	$("#optradioNA").attr('checked', false);
	$("#optradioCostoTotal").attr('checked', false);
    tipoSuscriptor = "f";
    $("#divFlat").show();
    $("#divSuscriptores").hide();    
    $("#divBotones").show();    
    $("#tiempoVida").show();
    mostrarComunDiv();
}

function bindingInputCategoriaFlat(){
	$("#divFlat table.tFlat tr.categoria").each(function() {    	
    	var idCat = $(this).attr("id");
    	$(this).find("td:first input").change(function() {
			var valor = $(this).val();
			$("#divFlat table.tFlat").each(function(){
				 $(this).find("tr[id="+idCat+"] td:first input").val(valor);		
			});
    	});
	});
}

function bindingInputValores(){	
	$("table tr.categoria").each(function(){
		var valido = false;
		var cate = $(this);
    	$(this).find("input").each(function(){    		    	
    		if(valido)
    			$(this).change(function() {  
    				var valor = $(this).val() == "0" ? $(this).val() : unformatCurrency($(this).val());    				
    				if(!validaNumero(valor))
    				   showError("El valor ingresado no es un numero."); 
    				else
    					$(this).val( formatCurrency(Number(unformatCurrency(valor)), 2) );
    			});
    		valido = true;
    	});
	});
}

function obtenerFlats(){			
	var periodos = [];
	var validacion = true;	
	validacionForma = true;
	
	if($("#divFlat .contenedor").length > 0)
	{					
		periodos = obtenerTodosFlat();		
		
		if(periodos[0].flats.length == 0)
		{
			for(var i=0; i< periodos.length; i++)			
			    periodosEliminar.push(periodos[i]);
			periodos.splice(0, periodos.length);
		}		
		else
		{
			for(var i=0; i< periodos.length; i++)
			{		   
			   if(validacionForma)
			   {
			      validacion  = validarFlat(periodos[i]);		   
				  validacionForma = validacion;
			   }
			}						
			validacionFeesInflacionYFechas(periodos);
		}				
	}		
	return periodos;	
}

function validarFlat(periodo){
	var valido = true;
		
	for(var i=0; i < periodo.flats.length; i++)
	{	//Se valida el periodo			
		var resultado = validaPeriodoFlat(periodo);		
		if(valido)
		   valido = resultado.validacion;
		if(!resultado.validacion)		
			$("label.mensajePer").text(resultado.mensaje).show();									
		else
			$("label.mensajePer").hide();
												
		if(resultado.validacion)
		{   //Se valida las categorias
			resultado = validarCategoriaFlat(periodo.flats[i], periodo.flats.length);			
			if(valido)
			   valido = resultado.validacion;
							
			if(!resultado.validacion)		
				$("table.tFlat tr[id='"+periodo.flats[i].idCategoria+"']").find("label.mensaje").text(resultado.mensaje).show(); 
			else		
				$("table.tFlat tr[id='"+periodo.flats[i].idCategoria+"']").find("label.mensaje").hide();
		}																			 				
	}	
		
	if(valido)
	{
		var resultado = validarCategoriasFees(periodo.flats);		
		if(valido)
		   valido = resultado.validacion;
		if(!resultado.validacion)		
			$("label.mensajePer").text(resultado.mensaje).show();									
		else
			$("label.mensajePer").hide();
	}
									
	if(!valido)
		showError("Revisar los datos.");
	return valido;
}

function obtenerTodosFlat(){			
	var periodos    = [];	
	var numPeriodos = $("table.tFlat thead tr").find("th").length-2; 
	var idPeriodo   = parseInt($("table.tFlat").attr("id").substr(5, $("table.tFlat").attr("id").length));
	
	for(var i=0; i<numPeriodos; i++)
	{
		var categorias = [];
		$("table.tFlat tr.categoria").each(function(){			
			var inputs = $(this).find("td input[type='text']");
			var tds    = $(this).find("td");
			var categoria = { "descCategoria": encodeURIComponent(inputs[0].value), "idCategoria": $(this).attr("id"), "anios": null };
			
			var anios = [];			
			var monto = inputs[i+1].value == "0" ? inputs[i+1].value : unformatCurrency(inputs[i+1].value);
			var anio  = { "anio": 1, "costo": monto, "idPagoFlat": inputs[i+1].id }				
			anios.push(anio);												
			
			categoria.anios = anios;											 					
			categorias.push(categoria);									
		});
		
		var encabezados = $("table.tFlat thead tr").find("th.thPeriodo");
		var fecha       = $("table.tFlat thead tr").find("th.thPeriodo")[i].innerText;
		var anio        = fecha.split(":");		
		fecha           = anio[1].trim().split("-");
		anio            = anio[0];
		
		var inicio = fecha.length < 2 ? null : fecha[0]; 
		var fin    = fecha.length < 2 ? null : fecha[1];
		periodos.push(crearPeriodo(categorias, inicio, fin, parseInt($("table.tFlat thead tr").find("th.thPeriodo")[i].attributes["idPer"].value), anio));
	}				
	return periodos;
}

function crearPeriodo(categorias, fechaInicio, fechaFin, idContratoPago, anio){
	debugger
	var periodo = { 
			"flats"          : categorias,					         			
		    "fechaFin"       : fechaFin, 
		    "fechaInicio"    : fechaInicio,						    
		    "tipoAnio"       : "Contractual",
            "idContratoPago" : idContratoPago, 
            "operacion"      : tipoOperacion,
            "tipoPago"       : "FLAT",
            "eliminarBono"   : false,
            "maxAnios"       : 0,
            "anioContrato"   : anio
    };
	return periodo;
}

function inicializarVacioFlat(fechaInicio, fechaFin){	  
	  var aniosA = [];	  	  
	  var flats  = [];
	  
	  aniosA.push({ "anio": "Fecha Inicio-Fecha Fin", "costo": "", "nuevo": 0 });		  	  	  
	      
	  if($("#divFlat div.contenedor").length > 0)
	  {
		   $("#divFlat div.contenedor:first tr.categoria").each(function(){												
				var categoria = { "descCategoria": $(this).find("td:first input[type='text']").val(), "idCategoria": $(this).attr("id") == null ?0 :$(this).attr("id"), "idPagoFlat": 0, "anios": aniosA };		
				flats.push(categoria);   
		   });
	  }
	  else
		  flats = [{ "descCategoria": "", "idPagoFlat": 0, "idCategoria": 0, "anios": aniosA }];
	   	  
	  var fechaFin = addYear($("#fechaCtoInicio").val()); 	  
	  var json = { "datos": [{	        						              
						        "flats": flats,
						        "descSuscriptor": "",
						        "fechaFin": fechaFin, "fechaInicio": $("#fechaCtoInicio").val(),
						        "idContrato": 0,
						        "idContratoPago": 0,
						        "idSuscriptor": 0,
						        "maxAnios": 0,
						        "maxRangos": 1,
						        "operacion": "nuevo",
						        "tipoAnio": "0",
						        "tipoPago": "",
						        "anioContrato": 0
	  						}]
	}	  
	json.datos[0].idContratoPago = nuevoPeriodo;
	crearFlat(json);		
}

function eliminarColumnaFlat(idCol){		
	if($("table.tFlat thead tr.encabezado").find("th").length == 3)
		showError("Debe existir al menos un Periodo.");
	else if(idCol > 0)	
		eliminarPeriodo(idCol);
	else if(idCol < 0)
		eliminarColFlat(idCol);				
}


function eliminarColFlat(idCol)
{
	var encontrado =  false;
	var columnas = 1;
	
	$("table.tFlat tbody tr.eliminarCol").find("td").each(function(){			
		if(parseInt($(this).attr("id")) !== parseInt(idCol) && !encontrado)		
			columnas++;
		if(parseInt($(this).attr("id")) === parseInt(idCol))
			encontrado = true;					        			
	});				
	
	var fecha = $("table.tFlat thead tr.encabezado").find("th:nth-child("+columnas+")").text();

	$("table.tFlat thead tr.encabezado").each(function(){		
		$(this).find("th:nth-child("+columnas+")").remove();				        		
	});
	
	$("table.tFlat tbody tr").each(function(){		
		$(this).find("td:nth-child("+columnas+")").remove();				        		
	});
		
	$("#bonoInicio option[value='"+ fecha +"']").remove();	
}	

function verificarAniosContratosFlat(valor){
	var valido = true;
	
	var cont = 0;
	var numPeriodos = $("table.tFlat thead tr").find("th").length-2; 
	var idPeriodo   = parseInt($("table.tFlat").attr("id").substr(5, $("table.tFlat").attr("id").length));	
	for(var i=0; i<numPeriodos; i++)
	{					
		var fecha  = $("table.tFlat thead tr").find("th.thPeriodo")[i].innerText.split(":");				 
		var anio   = fecha.length == 0 || fecha == null ? null : fecha[0];
		if(anio == valor)
		{
			valido = false;
			cont++;
		}					
	}		
	if(!valido && cont == 1)
	   valido = true;
	
	if(isNaN(valor))
		valido = false;
	if(parseInt(valor) >= 100 || parseInt(valor) <= 0)
		valido = false;
	
	return valido;
}

function verificarAniosContratosFlatUnico(){
	var valido = true;
	
	var numPeriodos = $("table.tFlat thead tr").find("th").length-2; 
	var idPeriodo   = parseInt($("table.tFlat").attr("id").substr(5, $("table.tFlat").attr("id").length));
	
	for(var i=0; i<numPeriodos; i++)
	{					
		var fecha  = $("table.tFlat thead tr").find("th.thPeriodo")[i].innerText.split(":");				 
		var anio   = fecha.length == 0 || fecha == null ? null : fecha[0];		
		for(var j=i+1; j<numPeriodos; j++)
		{					
			var fecha1  = $("table.tFlat thead tr").find("th.thPeriodo")[j].innerText.split(":");				 
			var anio1   = fecha1.length == 0 || fecha1 == null ? null : fecha1[0];
			if(anio == anio1)
				valido = false;
		}
	}					
	return valido;
}
