package com.mx.dla.dda.ncredito.general.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.ncredito.general.dtos.ContratoTitulo;
import com.mx.dla.dda.ncredito.general.dtos.NotaCredito;
import com.mx.dla.dda.ncredito.general.dtos.NotaCreditoDetalle;

public interface NotaCreditoDAO {

	public List<ContratoTitulo> consultaTitulosBajaDisponibles(@Param("idEstudio") Long idEstudio);
	
	public List<ContratoTitulo> consultaTitulosBajaUtilizados(@Param("idEstudio") Long idEstudio, @Param("idNota") Long idNota);

	public List<ContratoTitulo> consultaTitulosDisminucionDisponibles(@Param("idContrato") Long idContrato);
	
	public List<ContratoTitulo> consultaTitulosDisminucionUtilizados(@Param("idContrato") Long idContrato, @Param("idNota") Long idNota);

	public List<NotaCredito> consultaNotaCreditoGeneral(@Param("idNota") Long idNota, @Param("estudios")List<Long> estudios, @Param("noFactura") String noFactura);

	public List<NotaCreditoDetalle> consultaNotaCreditoDetalle(@Param("idNotaDetalle") Long idNotaDetalle, @Param("idNota") Long idNota, @Param("idContrato") Long idContrato,
	        @Param("idTituloCnt") Long idTituloCnt);

	public Long guardarNotaCredito(@Param("nota") NotaCredito nota);

	public void actualizarNotaCredito(@Param("nota") NotaCredito nota);

	public void eliminarNotaCredito(@Param("nota") NotaCredito nota);

	public void guardarNotaCreditoDetalle(@Param("notaDetalle") NotaCreditoDetalle notaDetalle);

	public void actualizarNotaCreditoDetalle(@Param("notaDetalle") NotaCreditoDetalle notaDetalle);

	public void eliminarNotaCreditoDetalle(@Param("nota") NotaCredito nota);
	
	public List<ContratoTitulo> obtenContratosConBaja(@Param("idEstudio") Long idEstudio);
	public List<ContratoTitulo> obtenContratosConDisminucion(@Param("idEstudio") Long idEstudio);
	public List<ContratoTitulo> obtenTitulosBajaPorContrato(@Param("idEstudio") Long idEstudio, @Param("idContrato") Long idContrato);
	public List<ContratoTitulo> obtenTitulosDisminucionPorContrato(@Param("idEstudio") Long idEstudio, @Param("idContrato") Long idContrato);
	public List<ContratoTitulo> obtenTitulosBajaPorContratoEnNota(@Param("idEstudio") Long idEstudio, @Param("idContrato") Long idContrato, @Param("idNota") Long idNota);
	public List<ContratoTitulo> obtenTitulosDisminucionPorContratoEnNota(@Param("idEstudio") Long idEstudio, @Param("idContrato") Long idContrato, @Param("idNota") Long idNota);
	public List<ContratoTitulo> obtenTitulosBajaPorContratoNoEnNota(@Param("idEstudio") Long idEstudio, @Param("idContrato") Long idContrato, @Param("idNota") Long idNota);
	public List<ContratoTitulo> obtenTitulosDisminucionPorContratoNoEnNota(@Param("idEstudio") Long idEstudio, @Param("idContrato") Long idContrato, @Param("idNota") Long idNota);


}
