package com.mx.dla.admin.actions;

import java.sql.SQLException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.ibatis.executor.result.ResultMapException;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;

import com.mx.dla.admin.bos.MenuBO;
import com.mx.dla.admin.daos.PerfilDAO;
import com.mx.dla.admin.daos.UsuarioDAO;
import com.mx.dla.admin.dtos.MenuDTO;
import com.mx.dla.admin.dtos.PerfilDTO;
import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.opensymphony.xwork2.ActionContext;

@Controller
@Scope("request")
public class InicioAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	@Autowired
	private UsuarioDAO usuarioDAO;

	@Autowired
	private PerfilDAO perfilDAO;

	@Autowired
	private MenuBO menuBO;

	List<MenuDTO> menusUsuario = null;

	@Override
	public String execute() throws TransaccionException {
		String retorno = SUCCESS;
		try {
			Authentication autenticacion = SecurityContextHolder.getContext().getAuthentication();
			HttpServletRequest request = ServletActionContext.getRequest();

	        // Obtener la direccin IP del cliente
	        String ipAddress = request.getHeader("X-FORWARDED-FOR");
	        if (ipAddress == null || ipAddress.isEmpty()) {
	            ipAddress = request.getRemoteAddr();
	        }
	        
	        String userAgent = request.getHeader("User-Agent");
			UsuarioDTO usuario = usuarioDAO.obtenerUsuario(autenticacion.getName());

			ActionContext.getContext().getSession().remove("pmn");
			ActionContext.getContext().getSession().remove("pmnReturn");
			getSession().put("ipAdress",ipAddress);
			getSession().put("userAgent",userAgent);

			if (!this.getPmn().equals("0"))
				retorno = "menu_" + this.getPmn();
	
			if (usuario != null) {

				getSession().put("permisos", menuBO.obtenPermisosPerfil(usuario.getPerfil().getIdPerfil()));

				String idPerfil = usuario.getPerfil().getIdPerfil();

				if (idPerfil != null) {
					PerfilDTO perfil = perfilDAO.obtenerPerfil(idPerfil);

					logger.debug("PerfilDTO : [{}]", perfil);

					if (perfil != null) {
						getSession().put("usuario", usuario);

						List<MenuDTO> menusPerfil = perfil.getMenus();

						if (menusPerfil != null) {
							menusUsuario = menuBO.armarArbolMenus(menusPerfil, idPerfil);
							getSession().put("menus", perfil.getMenus());
						}
					} else {
						retorno = "error_002";
					}
				} else {
					retorno = "error_002";
				}
			} else {
				retorno = "error_001";
			}
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return retorno;
	}

}
